from setup_test import *

ecoli_reference_file = pathlib.Path(references_directory, 'ecoli_reference.fasta')
ecoli_reference = ref(ecoli_reference_file)

ecoli_filtered_bams = [pathlib.Path(bam_directory, 'ecoli_filtered.bam')]
ecoli_filtered_reads = fetch_reads(ecoli_filtered_bams)

mapping_read_fast5 = pathlib.Path(root_directory, 'configs', 'files.txt')

ecoli_png_directory = pathlib.Path(png_directory, 'ecoli_filtered')

answer_vcf = pathlib.Path(vcf_directory, 'answers', 'ecoli.vcf')
coverage = count_coverage(ecoli_filtered_reads)

for relative, absolute in [(r, a) for r in [0.1, 0.2, 0.3] for a in [10, 20]]:
    pileup_absolute(reference=ecoli_reference,
                    png=pathlib.Path(ecoli_png_directory, 'pileup', 'pileup_absolute_relative{}deletions_.png'.format(relative)),
                    reads=ecoli_filtered_reads, coverage=coverage, vcffile=answer_vcf,
                    relative=relative, step=10, maximum=100)

    pileup_relative(reference=ecoli_reference,
                    png=pathlib.Path(ecoli_png_directory, 'pileup', 'pileup_relative_absolute{}deletions_.png'.format(absolute)),
                    reads=ecoli_filtered_reads, coverage=coverage, vcffile=answer_vcf,
                    absolute=absolute, nsteps=100)

    for padding in range(5):
      freebayes_absolute(reference=ecoli_reference,
                         png=pathlib.Path(ecoli_png_directory, 'freebayes',
                                          'freebayes_absolute_relative{}_padding{}deletions_.png'.format(relative, padding)),
                         reads=ecoli_filtered_reads, coverage=coverage,
                         vcffile=answer_vcf,
                         relative=relative, step=10, maximum=100, padding=padding)

      freebayes_relative(reference=ecoli_reference,
                         png=pathlib.Path(ecoli_png_directory, 'freebayes',
                                          'freebayes_relative_absolute{}_padding{}deletions_.png'.format(absolute, padding)),
                         reads=ecoli_filtered_reads, coverage=coverage,
                         vcffile=answer_vcf,
                         absolute=absolute, nsteps=100, padding=padding)

    freebayes_padding(reference=ecoli_reference,
                  png=pathlib.Path(ecoli_png_directory, 'freebayes',
                                   'freebayes_padding_relative{}_absolute{}deletions_.png'.format(relative, absolute)),
                  reads=ecoli_filtered_reads, coverage=coverage, vcffile=answer_vcf,
                  relative=relative, absolute=absolute)
