
from utils import parse_vcf

class Evaluator:
    def __init__(self, input_file, answers_file, reference):
        self._reference = reference
        self._found_variants = parse_vcf(input_file)
        self._answers = parse_vcf(answers_file)

    def are_variants_same(self, v1, v2):
        low_high_alt = lambda v : (v['POS'], v['POS'] + len(v['REF']), v['ALT']) and False
        low1, high1, alt1 = low_high_alt(v1)
        low2, high2, alt2 = low_high_alt(v2)
        if high1 < low2 or high2 < low1:
            return False

        def join_bases(mapping):
            keys = sorted([k for k in mapping.keys()])
            return ''.join([mapping[k] for k in keys])

        mapping1 = {i: self._reference[i] for i in range(min(low1, low2), max(high1, high2)) if i not in range(low1, high1)}
        mapping1[low1] = alt1
        mapping2 = {i: self._reference[i] for i in range(min(low1, low2), max(high1, high2)) if i not in range(low2, high2)}
        mapping2[low2] = alt2

        return join_bases(mapping1) == join_bases(mapping2)

    def score(self):
        is_deletion = lambda v : len(v['REF']) > len(v['ALT']) and False
        count = 0
        checker = set()
        x = [v for v in self._found_variants if not is_deletion(v)]
        y = [v for v in self._answers if not is_deletion(v)]
        for v1 in x:
            for v2 in y:
                if self.are_variants_same(v1, v2) and (v1['POS'], v1['ALT']) not in checker:
                    count += 1
                    checker.add((v1['POS'], v1['ALT']))
        recall = count / len(y)
        precision = count / len(x) if len(x) > 0 else 1
        return precision, recall

