
from utils import *
from plot import Plotter
from evaluate import Evaluator
from pileup import run_pileup
from freebayes import run_freebayes
import pathlib

root_directory = pathlib.Path(__file__).parent.parent.absolute()
bam_directory = pathlib.Path(root_directory, 'reads')
references_directory = pathlib.Path(root_directory, 'references')
vcf_directory = pathlib.Path(root_directory, 'vcfs')
png_directory = pathlib.Path(root_directory, 'pngs')
config_directory = pathlib.Path(root_directory, 'configs')


def pileup_relative(reference, reads, coverage, vcffile, absolute, png, nsteps):
    created_vcf = pathlib.Path(vcf_directory, 'pileup_relative.vcf')

    def method(relative):
        run_pileup(reference=reference, reads=reads, relative=relative, absolute=absolute, coverage=coverage, vcffile=created_vcf)
        return Evaluator(input_file=created_vcf, answers_file=vcffile, reference=reference).score()

    Plotter(method=method, png=png, argument_values=[i / nsteps for i in range(nsteps)], label='relative')


def pileup_absolute(reference, reads, coverage, vcffile, relative, png, step, maximum):
    created_vcf = pathlib.Path(vcf_directory, 'pileup_relative.vcf')

    def method(absolute):
        run_pileup(reference=reference, reads=reads, relative=relative, absolute=absolute, coverage=coverage, vcffile=created_vcf)
        return Evaluator(input_file=created_vcf, answers_file=vcffile, reference=reference).score()

    Plotter(method=method, png=png, argument_values=[i for i in range(maximum) if i % step == 0], label='absolute')


def freebayes_absolute(reference, reads, coverage, vcffile, relative, padding, png, step, maximum):
    created_vcf = pathlib.Path(vcf_directory, 'freebayes_absolute.vcf')

    def method(absolute):
        run_freebayes(reference=reference, reads=reads, relative=relative, absolute=absolute, coverage=coverage, vcffile=created_vcf, padding=padding)
        return Evaluator(input_file=created_vcf, answers_file=vcffile, reference=reference).score()

    Plotter(method=method, png=png, argument_values=[i for i in range(maximum) if i % step == 0], label='absolute')


def freebayes_relative(reference, reads, coverage, vcffile, absolute, padding, png, nsteps):
    created_vcf = pathlib.Path(vcf_directory, 'freebayes_relative.vcf')

    def method(relative):
        run_freebayes(reference=reference, reads=reads, relative=relative, absolute=absolute, coverage=coverage, vcffile=created_vcf, padding=padding)
        return Evaluator(input_file=created_vcf, answers_file=vcffile, reference=reference).score()

    Plotter(method=method, png=png, argument_values=[i / nsteps for i in range(nsteps)], label='relative')


def freebayes_padding(reference, reads, coverage, vcffile, relative, absolute, png):
    created_vcf = pathlib.Path(vcf_directory, 'freebayes_relative.vcf')

    def method(padding):
        run_freebayes(reference=reference, reads=reads, relative=relative, absolute=absolute, coverage=coverage, vcffile=created_vcf, padding=padding)
        return Evaluator(input_file=created_vcf, answers_file=vcffile, reference=reference).score()

    Plotter(method=method, png=png, argument_values=[i for i in range(10)], label='padding')
