//---------------------------------------------------------------------------


#pragma hdrstop

#include "Structures.h"

#include <stdio.h>
#include <stdlib.h>

void *mycalloc (int nitems, int nbytes)
{
   void *ptr = calloc(nitems, nbytes);
   if (ptr != NULL) return ptr;
   fprintf(stderr, "can't calloc %d bytes\n", nitems*nbytes);
   exit(1);
   return NULL;
}

void myfree (void *block){
  free(block);
}

/*
void cross(T3DPoint pA, T3DPoint pB, T3DPoint *pC){
  pC->X = pA.Y * pB.Z - pA.Z * pB.Y;
  pC->Y = pA.Z * pB.X - pA.X * pB.Z;
  pC->Z = pA.X * pB.Y - pA.Y * pB.X;
} */



T3DPoint operator +(const T3DPoint pA, const T3DPoint pB){
  T3DPoint pC;
  pC.X = pA.X + pB.X;
  pC.Y = pA.Y + pB.Y;
  pC.Z = pA.Z + pB.Z;
  return pC;
}

T3DPoint operator -(const T3DPoint pA, const T3DPoint pB){
  T3DPoint pC;
  pC.X = pA.X - pB.X;
  pC.Y = pA.Y - pB.Y;
  pC.Z = pA.Z - pB.Z;
  return pC;
}

double operator *(const T3DPoint pA, const T3DPoint pB){
  return pA.X * pB.X + pA.Y * pB.Y + pA.Z * pB.Z;
}

T3DPoint operator %(const T3DPoint pA, const T3DPoint pB){
  T3DPoint pC;
  pC.X = pA.Y * pB.Z - pA.Z * pB.Y;
  pC.Y = pA.Z * pB.X - pA.X * pB.Z;
  pC.Z = pA.X * pB.Y - pA.Y * pB.X;
  return pC;
}

T3DPoint operator *(const double c, const T3DPoint pA){
  T3DPoint pC;
  pC.X = c * pA.X;
  pC.Y = c * pA.Y;
  pC.Z = c * pA.Z;
  return pC;
}
T3DPoint operator /(const T3DPoint pA, const double c){
  T3DPoint pC;
  pC.X = pA.X / c;
  pC.Y = pA.Y / c;
  pC.Z = pA.Z / c;
  return pC;
}

int operator ==(const T3Index id1, const T3Index id2){
  return (id1.I == id2.I) && (id1.J == id2.J) && (id1.K == id2.K);
}

//---------------------------------------------------------------------------

#pragma package(smart_init)
