#include <stdio.h>
#include <cstdlib>
#include <time.h>

#include <map>
#include <vector>
#include <string>
#include <algorithm>

#define OMIT_EXON 10

using namespace std;

struct SHint {
	char	label;
	int		start;
	int		stop;
	bool	plus_strand;
	int		frame;			// maybe not necessary
	char	gene_ID[100];   // maybe not necessary

	bool	dont_use;  // helper
};

class Hinter 
{
public:
	// files
	FILE *gtf;
	FILE *output;
	FILE *resp;

	// helpers
	bool read;
	char buffer[1000];

	// restrictions
	int minIntervals;

	// the big map 
	string chromosome;
	map<string, vector<SHint> > hints;   // mapped transcript_ID to its intervals

	// good annotation
	vector<char> annotation;

	// labels - hints & states
	map<char, vector<char> >	hintToStateLabel;	// hint -> vector of state labels
	map<char, char>				stateToHint;		// state label -> hint label
	

public:
	Hinter();

	int SetGTF(char* file);
	int SetOutput(char* file);
	int SetResp(char* file);
	
	// labels for resp_hints
	int LoadLabels(char* file);

	int LoadGtf();
	int LoadGood(bool set_chr = false);

	// helper function 
	bool RespHint(SHint hint);

	// restrictions
	void SetIntervalRest(int k);  // -1 == no restriction

	// resp_hints - respected annotation, testing purposes
	int ConvertToComplex(char *src, char *dst, bool add_int = false, char *resp_hints = NULL);
	int ConvertToIntervals(char *src, char *dst);
	int ConvertToPoints(char *src, char *dst);

	// create fake hints from good annotation
	int CreateFake(char *src, char *dst_com, char *dst_int, int length, double coverage);

	// Modify 
	int Modify(char *resp_hints = NULL);   //counts bad hints if good annotation available
};