#include "card.h"

Card::Card()
{
}

QString Card::color(int c){
	if(c/8==0)return "gula";
	if(c/8==1)return "zalud";
	if(c/8==2)return "zelen";
	if(c/8==3)return "cerven";
	qCritical() << "zly kod karty: " << c;
	return "";
}

QString Card::colorZ(int c){
	if(c/8==0)return "gulov";
	if(c/8==1)return "zaludn";
	if(c/8==2)return "zelen";
	if(c/8==3)return "cerven";
	return "";
}

QString Card::value(int c){
	if(c%8==0)return "7";
	if(c%8==1)return "8";
	if(c%8==2)return "9";
	if(c%8==3)return "10";
	if(c%8==4)return "dolnik";
	if(c%8==5)return "hornik";
	if(c%8==6)return "kral";
	if(c%8==7)return "eso";
	qCritical() << "zly kod karty: " << c;
	return "";
}

QString Card::valueA(int c){
	if(c%8==0)return "u 7";
	if(c%8==1)return "u 8";
	if(c%8==2)return "u 9";
	if(c%8==3)return "u 10";
	if(c%8==4)return "eho dolnika";
	if(c%8==5)return "eho hornika";
	if(c%8==6)return "eho krala";
	if(c%8==7)return "e eso";
	qCritical() << "zly kod karty: " << c;
	return "";
}

QString Card::title(int c){
	QString s = colorZ(c);
	if(c%8<4)s+="a ";
	if(c%8>=4 && c%8<=6)s+="y ";
	if(c%8==7)s+="e ";
	return s+value(c);
}

QString Card::titleA(int c){
	return colorZ(c)+valueA(c);
}

bool Card::isFatty(int c){
	return value(c)=="eso" || value(c)=="10";
}

bool Card::isTromf(int c,Hra hra){
	return equalColor(c,hra.tromf);
}

bool Card::equalColor(int c,int d){
	return c/8==d/8;
}

bool Card::stronger(int c,int d, Hra hra){
	if(!hra.farba)
		return c%8>d%8 && equalColor(c,d);
	qreal cc = c%8;
	qreal dd = d%8;
	if(cc==3)cc+=3.5;
	if(dd==3)dd+=3.5;
	if(equalColor(c,d) && cc>dd)return true;
	if(equalColor(c,d) && cc<=dd)return false;
	//!equalColor
	return isTromf(c,hra);
}

bool Card::greater(int c,int d){
	if(c/8 > d/8)return true;
	if(c/8 < d/8)return false;
	return stronger(c,d, Hra());
}

bool Card::less(int c,int d){
	return greater(d,c);
}

int Card::plus1(int c, bool farba){
	if(!farba)return c+1;
	if(c%8==2)return c+2;
	if(c%8==6)return c-3;
	if(c%8==3)return c+4;
	return c+1;
}

int Card::stich(int c,int d,int e, Hra hra){
	if(!stronger(d,c,hra) && !stronger(e,c,hra))
		return 0;
	if(stronger(d,c,hra) && !stronger(e,d,hra))
		return 1;
	return 2;
}
