#ifndef CARDITEM_H
#define CARDITEM_H

/**
  *Classes that extends various graphics items and adds properties that can be animated.
  *
  */

class CardItem;
class CardItemGroup;
class SuperText;

#include <QFont>
#include <QGraphicsTextItem>
#include <QGraphicsItem>
#include <QGraphicsItemGroup>
#include <QMouseEvent>
#include <QDebug>
#include "deskview.h"

class CardItem : public QObject, public QGraphicsPixmapItem
{
	Q_OBJECT
 Q_PROPERTY(QPointF pos READ pos WRITE setPos)
 Q_PROPERTY(qreal x READ x WRITE setX)
 Q_PROPERTY(qreal y READ y WRITE setY)
 Q_PROPERTY(qreal opacity READ opacity WRITE setOpacity)
 Q_PROPERTY(qreal z READ zValue WRITE setZValue)
public:
	CardItem();
	void mousePressEvent(QGraphicsSceneMouseEvent *event);
	int cid;
};

// deprecated
class CardItemGroup : public QObject, public QGraphicsItemGroup
{
	Q_OBJECT
 Q_PROPERTY(QPointF pos READ pos WRITE setPos)
 Q_PROPERTY(qreal opacity READ opacity WRITE setOpacity)
};

class SuperText : public QGraphicsTextItem
{
	Q_OBJECT
 Q_PROPERTY(qreal opacity READ opacity WRITE setOpacity)
};

#endif // CARDITEM_H
