#include "game.h"
#include "playerfactory.h"

Game::Game(Marias* m)
{
	marias = m;
	settings = new QSettings("marias.ini", QSettings::IniFormat);
	bd = new BiddingDialog(this);
	profiler = new Profiler();
    for(int i=0;i<3;i++)stats[i]=0;
}

Game::~Game(){
	foreach(Player* p,players){
		delete p;
	}
	delete profiler;
    qDebug() << stats[0] << stats[1] << stats[2];
    QString uncompressed = QString::number(stats[0]) + " " + QString::number(stats[1]) + " " + QString::number(stats[2]);
    QByteArray compressed = uncompressed.toAscii().toBase64();
    QFile file("vysledky.txt");
    file.open(QIODevice::WriteOnly | QIODevice::Text);
    QTextStream out(&file);
    out << compressed;
    file.close();
}

void Game::init(){
	qDebug() << "game init";
	quickGame = false;
    if(settings->value("shuffling/random",1)==1)
    {
        qDebug() << "random";
        rg.setSeed();
    }
    else
    {
        qDebug() << "not random";
        rg.setSeed(settings->value("shuffling/seed",47).toInt());
    }
	shuffleDeck();
	players.clear();
	players.push_back(PlayerFactory::create(settings->value("players/front","HumanPlayer").toString()));
	players.push_back(PlayerFactory::create(settings->value("players/left","RandomPlayer").toString()));
	players.push_back(PlayerFactory::create(settings->value("players/right","RandomPlayer").toString()));
	players[0]->name = settings->value("players/front_name",tr("front")).toString();
	players[1]->name = settings->value("players/left_name",tr("left")).toString();
	players[2]->name = settings->value("players/right_name",tr("right")).toString();
	for(int i=0;i<3;i++){
		players[i]->setStav(&stav);
		players[i]->setId(i);
		players[i]->profiler = profiler;
        players[i]->init();
	}
	resetMoney();
	stav.forhont = 2;
	stav.kolo = -6;
}

void Game::resetMoney(){
    for(int i=0;i<3;i++){
        players[i]->peniaze = 0;
    }
}

void Game::newGame(){
	profiler->start("dealing and bidding");
	if(bd->isVisible())
		bd->hide();
	for(int i=0;i<3;i++){
		players[i]->body = 0;
		players[i]->hlasky = 0;
		players[i]->quickGame = quickGame;
	}
	stav.newGame();
    shuffleDeck();
	if(!quickGame){
		DeskView::log(tr("Nova hra."));
		DeskView::log(tr("Forhont je %1").arg(players[stav.forhont]->name));
		DeskView::gather();
		DeskView::draw();
	}
	rozdaj1();
}

void Game::results(){
	int p = stav.trick();
	if(!quickGame){
		DeskView::log(tr("Stich berie ")+players[p]->name);
		qDebug() << "Stich berie " + players[p]->name;
	}
	foreach(int c,stav.kopa){
		if(Card::value(c)=="10" || Card::value(c)=="eso")
			players[p]->body += 10;
	}
	if(stav.kolo==9)players[p]->body += 10;
	stav.id=p;
	//first kolo increase, then animation
	stav.kolo++;
	if(!quickGame)
		DeskView::animateStich(p);
	stav.pHist.push_back(p);
	stav.vysid = p;
	stav.kopa.clear();

	if(stav.kolo==10){
		profiler->stop("game - trick taking");
		int res = stav.results(true);
		qDebug() << "stav results: " << QString::number(res);
		players[stav.forhont]->peniaze += res*2;
		players[(stav.forhont+1)%3]->peniaze -= res;
		players[(stav.forhont+2)%3]->peniaze -= res;
        if(players[0]->type=="human" && players[1]->type=="minimax" && players[2]->type=="smart")
        {
            stats[stav.forhont] += res*2;
            stats[(stav.forhont+1)%3] -= res;
            stats[(stav.forhont+2)%3] -= res;
        }
	}

	profiler->stop("trick taking - stich results");
	if(quickGame)
		animationFinished(stav.kolo);
}

void Game::cardClicked(int k){
	profiler->stop(players[stav.id]->name);
	qDebug() << "click";
	if(quickGame)return;
	if(!waitingForClick){qDebug("pozhovej");DeskView::print(tr("pozhovej"),0);return;}
	if(stav.kolo==10)return;
	if(!turn(k))return;
	waitingForClick=false;
	DeskView::animateCard(k,stav.id);
	stav.dalsi();
}

bool Game::turn(int k){
	if(!quickGame)
		qDebug() << players[stav.id]->name << ": " << Card::title(k);
	QString result = players[stav.id]->validate(k);
	if(result!=""){
		if(!quickGame)
			DeskView::print(result,stav.id);
		qDebug() << players[stav.id]->name << " zahrala nevalidnu kartu " << Card::title(k);
		return false;
	}

        if(Card::value(k)=="hornik" && players[stav.id]->hand.contains(k+1)){
            int hlaska = 20;
            if(Card::color(k)==Card::color(stav.hra.tromf))
                hlaska = 40;
			if(!quickGame)
				DeskView::print(QString::number(hlaska),stav.id);
            players[stav.id]->body += hlaska;
			players[stav.id]->hlasky++;
			stav.hlaska(hlaska);
        }

	stav.cHist.push_back(k);
	stav.kopa.push_back(k);
	players[stav.id]->removeCard(k);
	return true;
}

void Game::shuffleDeck(){
	deck.clear();
	for(int i=0;i<32;i++){
		deck.push_back(i);
	}
	int swapCount = 1000+rg.rand(1000);
	for(int i=0;i<swapCount;i++)
		deck.swap(rg.rand(32),rg.rand(32));
}

void Game::rozdaj1(){
	//first kolo increase, then animation
	profiler->start("rozdaj 1");
	stav.kolo = -5;
	for(int i=0;i<3;i++)
		players[i]->hand.clear();
	for(int i=0;i<7;i++){
		players[stav.forhont]->hand.push_back(deck[i]);
		if(!quickGame)
			DeskView::rozdaj(deck[i],stav.forhont,i,i);
	}
	for(int i=7;i<12;i++){
		players[(stav.forhont+1)%3]->hand.push_back(deck[i]);
		if(!quickGame)
			DeskView::rozdaj(deck[i],(stav.forhont+1)%3,i-7,i);
	}
	for(int i=12;i<17;i++){
		players[(stav.forhont+2)%3]->hand.push_back(deck[i]);
		if(!quickGame)
			DeskView::rozdaj(deck[i],(stav.forhont+2)%3,i-12,i,i==16);
	}
	profiler->stop("rozdaj 1");
	if(quickGame)
		animationFinished(-5);
}

void Game::rozdaj2(){
	profiler->start("rozdaj 2");
	//first kolo increase, then animation
	stav.kolo = -3;
	for(int i=17;i<22;i++){
		players[stav.forhont]->hand.push_back(deck[i]);
		if(!quickGame)
			DeskView::rozdaj(deck[i],stav.forhont,i-10,i-17);
	}
	for(int i=22;i<27;i++){
		players[(stav.forhont+1)%3]->hand.push_back(deck[i]);
		if(!quickGame)
			DeskView::rozdaj(deck[i],(stav.forhont+1)%3,i-17,i-17);
	}
	for(int i=27;i<32;i++){
		players[(stav.forhont+2)%3]->hand.push_back(deck[i]);
		if(!quickGame)
			DeskView::rozdaj(deck[i],(stav.forhont+2)%3,i-22,i-17,i==31);
	}
	profiler->stop("rozdaj 2");
	if(quickGame)animationFinished(-3);
}

QString Game::validateTalon(int k){
	if(!players[stav.forhont]->hand.contains(k))
		return tr("ZO SVOJICH KARIET!");
	if(stav.hra.farba){
		if(Card::value(k)=="10" || Card::value(k)=="eso")
			return tr("DO TALONA NESMU IST 10 A ESO");
		if(k==stav.hra.tromf)
			return tr("DO TALONA NESMIE IST VOLENY TROMF");
	}
	return "";
}

void Game::talonClicked(int k){
//	if(!quickGame)
//		qDebug() << players[stav.forhont]->name << " chce dat do talonu " << Card::titleA(k);
	QString res = validateTalon(k);
	if(res!=""){
		qDebug() << res;
		if(players[stav.forhont]->type=="human" && !quickGame)
			DeskView::print(res,stav.forhont);
		return;
	}
	players[stav.forhont]->removeCard(k);


//	if(!quickGame)
//		DeskView::log(players[stav.forhont]->name+tr(" dal do talonu ")+Card::titleA(k));

	if(players[stav.forhont]->hand.count()==11){
		players[stav.forhont]->talonCards[0]=k;
		if(!quickGame)
			DeskView::talon(k);
		if(players[stav.forhont]->type=="human" && !quickGame)
			DeskView::print(tr("ESTE JEDNU"),stav.forhont);
	}else if(players[stav.forhont]->hand.count()==10){
		//first kolo increase, then animation
		players[stav.forhont]->talonCards[1]=k;
		stav.kolo=-1;
		if(!quickGame)
			DeskView::talon(k,true);
		else animationFinished(-1);
	}else if(players[stav.forhont]->hand.count()<10)
		qCritical() << players[stav.forhont]->name << tr(" ma menej ako 10 kariet ??");
}

void Game::tromfClicked(int k){
//	if(!quickGame)
//		qDebug() << players[stav.forhont]->name << tr(" chce zvolit tromf ") << Card::titleA(k);
	if(!players[stav.forhont]->hand.contains(k)){
//		qDebug("Ale taku kartu nema");
		if(!quickGame)
			DeskView::print(tr("VYBERAJ LEN ZO SVOJEJ RUKY!"),stav.forhont);
		return;
	}
	waitingForClick=false;
	stav.hra.tromf = k;
	if(!quickGame){
		DeskView::ejectTromf(k,false);
        DeskView::log(players[stav.forhont]->name+tr(" zvolil tromfa."));
	}
	rozdaj2();
}

void Game::changePlayer(int i,QString newType){
	if(i<0 || i>2)return;
	if(quickGame)return;

	QList<int> hand = players[i]->hand;
	int body = players[i]->body;
	int peniaze = players[i]->peniaze;
	int hlasky = players[i]->hlasky;
	QString message = players[i]->message;
	int talonCards[2];
	talonCards[0] = players[i]->talonCards[0];
	talonCards[1] = players[i]->talonCards[1];

	delete players[i];
	players[i] = PlayerFactory::create(newType);

	players[i]->hand = hand;
	players[i]->body = body;
	players[i]->peniaze = peniaze;
	players[i]->hlasky = hlasky;
	players[i]->setStav(&stav);
	players[i]->profiler = profiler;
	players[i]->message = message;
	players[i]->setId(i);
	if(stav.forhont == i){
		players[i]->talonCards[0] = talonCards[0];
		players[i]->talonCards[1] = talonCards[1];
	}
    players[i]->init();

	DeskView::draw();
}

void Game::animationFinished(int round){
	if(!quickGame)
		qDebug() << "animation finished " << stav.kolo << ":" << round;
	if(stav.kolo!=round){
		qDebug() << "animation synchro fail";
		return;
	}
	if(stav.kolo==-6){
		if(!quickGame)
			DeskView::gather();
		stav.kolo=-5;
		return;
	}
	if(stav.kolo==-5){
		if(!quickGame)
			for(int i=0;i<players[0]->hand.count();i++)
				DeskView::revealCard(players[0]->hand[i]);
		players[0]->sortHand();
		//first kolo increase, then animation
		stav.kolo=-4;
		if(!quickGame)
			for(int i=0;i<players[0]->hand.count();i++)
				DeskView::rozdaj(players[0]->hand[i],0,i,0,i==players[0]->hand.count()-1);
		else animationFinished(-4);
		return;
	}

	if(stav.kolo==-4){
		if(players[stav.forhont]->type=="human" && !quickGame){
			DeskView::print(tr("ZVOL TROMF"),stav.forhont);
			waitingForClick=true;
		}else{
			int k = players[stav.forhont]->tromf();
			tromfClicked(k);
		}
		return;
	}

	if(stav.kolo==-3){
		//first kolo increase, then animation
		stav.kolo=-2;
		if(!quickGame)
			for(int i=0;i<players[0]->hand.count();i++)
				DeskView::revealCard(players[0]->hand[i]);
		players[0]->sortHand();
		if(!quickGame)
			DeskView::fixHand(0,true);
		else animationFinished(-2);
		return;
	}

	if(stav.kolo==-2){
		if(players[stav.forhont]->type=="human" && !quickGame){
			DeskView::print(tr("2 KARTY DO TALONU"),stav.forhont);
			waitingForClick=true;
		}else{
			int tal = players[stav.forhont]->talon();
			talonClicked(tal%32);
			talonClicked(tal/32);
		}
		return;
	}
	if(stav.kolo==-1){
		if(!quickGame)
			DeskView::fixHand(0);
		//farba - dobra - dobra
		if(!quickGame)
			DeskView::draw();
		stav.hra.farba = true;
		stav.kopa.clear();
		stav.id = stav.forhont;
		bd->startBidding();
		return;
	}
	if(stav.kolo==10){
		stav.hra.tromf=-1;
		if(!quickGame){
			profiler->start("draw");
			DeskView::draw();
			DeskView::drawResults();
			profiler->stop("draw");
		}
		profiler->stop("game - results");
		profiler->start("game - after results");
		return;
	}
	if(stav.kolo>=0){
		if(stav.kopa.count()<3){
			profiler->start(players[stav.id]->name);
			int k = players[stav.id]->play();
			profiler->stop(players[stav.id]->name);
			if(!quickGame)qDebug() << players[stav.id]->name << " rozmyslal: " << profiler->totals[players[stav.id]->name];
			if(k==-1 && players[stav.id]->type=="human"){
				profiler->start(players[stav.id]->name);
				waitingForClick=true;
				return;
			}
			if(!turn(k))
				qFatal("Niekto nevie zahrat toto kolo");
			if(!quickGame){
				if(players[stav.id]->message!=""){
					DeskView::log(players[stav.id]->message);
					players[stav.id]->message = "";
                    DeskView::draw();
				}
				DeskView::animateCard(k,stav.id);
			}
			stav.dalsi();
			if(quickGame)
				animationFinished(stav.kolo);
		}else{
			profiler->start("trick taking - stich results");
			results();
		};
		return;
	}
}
