#include <QtGui/QApplication>
#include <QTranslator>
#include <QSettings>
#include <QFile>
#include "marias.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
	QCoreApplication::setOrganizationName("Mio Kov");
	QCoreApplication::setApplicationName("OpenMarias");

	if(!QFile::exists("marias.ini"))
		QFile::copy("default.ini","marias.ini");
	QSettings* settings = new QSettings("marias.ini", QSettings::IniFormat);
	QTranslator translator(0);
	translator.load(settings->value("i18n/lang","sk").toString(),settings->value("i18n/dir","i18n/").toString());
	a.installTranslator(&translator);
	delete settings;

    Marias w;
    w.show();
    return a.exec();
}
