#include "playerfactory.h"

#include "players/humanplayer.h"
#include "players/randomplayer.h"
#include "players/minplayer.h"
#include "players/maxplayer.h"
#include "players/smartplayer.h"
#include "players/minimaxplayer.h"
#include "players/trustingminimaxplayer.h"

PlayerFactory::PlayerFactory()
{
}

Player* PlayerFactory::create(QString type){
	if(type=="HumanPlayer")
		return new HumanPlayer();
	if(type=="RandomPlayer")
		return new RandomPlayer();
	if(type=="MinPlayer")
		return new MinPlayer();
	if(type=="MaxPlayer")
		return new MaxPlayer();
	if(type=="SmartPlayer")
        return new SmartPlayer();
    if(type=="MinimaxPlayer")
        return new MinimaxPlayer();
    if(type=="TrustingMinimaxPlayer")
        return new TrustingMinimaxPlayer();
	qCritical() << "Invalid player type: " << type;
	return new RandomPlayer();
}
