#include <QQueue>
#include "minimaxplayer.h"
#include "minimax/rozdania.h"
#include "minimax/mystav.h"
#include "minimax/evaluator.h"
#include <cmath>

#define TIME_LIMIT_GENERATION 100
#define TIME_LIMIT_SEARCH 200

MinimaxPlayer::MinimaxPlayer()
{
	type="minimax";
	name="Minimax player";
}

MinimaxPlayer::~MinimaxPlayer()
{
	delete tromfChooser;
}

void MinimaxPlayer::init()
{
	profiler->start("Minimax init");
	tromfChooser = new TromfChooser();
	tromfChooser->init();
	qDebug() << "Minimax init: " << profiler->getTime("Minimax init");
}

/**
  * Trochu paranoidne predpokladam, ze opozicia spolupracuje, iba ked som forhont.
  * Akonahle uz nie som forhont, tak moj spoluhrac je zakerny.
  *
  */
bool MinimaxPlayer::isMaximizing(MyStav ms)
{
    return (this->somForhont() == (ms.stav.id == this->id));
}

int MinimaxPlayer::minimax(MyStav ms,bool firstLevel,int alpha)
{
	if(firstLevel)
		for(int i=0;i<ms.getHeight()+1;i++)
			this->states.push_back(0);
	this->states[ms.getHeight()]++;
    if(ms.getHeight() == this->cutoffLevel && this->cutoffLevel>0)
    {
        return Evaluator::evaluate(&ms);
    }
	if(profiler->getTime("minimaxSearch")>TIME_LIMIT_SEARCH){
		fail=true;
		return 0;
	}
//	qDebug() << "Vnaram sa, level=" << ms.getHeight();
	ms.checkIntegrity();
	if(ms.getHeight()==0){
		int outcome = ms.stav.results(true);
//            qDebug() << ms.stav.hra.forhontPoints << ":" << ms.stav.hra.oppPoints;
//            qDebug() << "pHist" << ms.stav.pHist;
//            qDebug() << "cHist" << ms.stav.cHist;
//            if(ms.stav.hra.stovka)qDebug() << "hrala sa stovka";
//            if(ms.stav.hra.stovkaProti)qDebug() << "hrala sa stovka proti";
//            if(ms.stav.hra.sedma)qDebug() << "hrala sa sedma";
//            if(ms.stav.hra.sedmaProti)qDebug() << "hrala sa sedma proti";
//            for(int i=0;i<ms.stav.res.size();i++){
//                Stav::ResRow r = ms.stav.res.at(i);
//                qDebug() << r.first << r.second << r.third;
//            }
//            qDebug() << "outcome="<<outcome;
		return outcome;
	}
    QList<MyStav> gen = ms.generate();
    if(gen.size()==0 && !quickGame)qDebug() << "Generated 0 further states";
    bool max = this->isMaximizing(ms);
	int best;
	if(max)best=-999999;
	else best=999999;
    if(ms.getHeight() > cutoffLevel+1 && ms.getHeight()%3==1)
    {
        if(max)
        {
            qSort(gen.begin(),gen.end(),Evaluator::greater);
        }
        else
        {
            qSort(gen.begin(),gen.end(),Evaluator::less);
        }
    }
	for(int i=0;i<gen.size();i++){
//		qDebug() << "skusi sa zahrat " << Card::title(gen[i].stav.cHist.last()) << " " << ms.stav.pHist.size();
        int outcome = minimax(gen[i],false,best);
		if(fail)return 0;
//		qDebug() << "vynaram sa, level=" << ms.getHeight() << ", outcome=" << outcome;
		if(firstLevel)
			this->rewards[gen[i].stav.cHist.last()] += outcome;
		if((outcome-alpha)*(max?1:-1) >= 0){
//			qDebug() << "alphabeta cut, alpha = " << alpha << " , beta = " << outcome;
//			qDebug() << "na tahu je " << stav->id << ", moje id=" << this->id << ", forhont je " << ms.stav.forhont;
			return outcome;
		}
		if((outcome-best)*(max?1:-1) > 0){
			best = outcome;
		}
	}
//	qDebug() << "Vynaram sa, best=" << best;
	return best;
}

int MinimaxPlayer::play(){
	profiler->start("minimaxSearch");
	rozdania.stav = stav;
	rozdania.quickGame = quickGame;
	rozdania.profiler = profiler;
	if(rozdania.positions.size()==0 || stav->kolo == 0){ //toto nastane na zaciatku hry, alebo ked sa zmeni hrac
		rozdania.hand = hand;
		rozdania.initPositions();
		rozdania.hand = hand;
		rozdania.talon[0] = talonCards[0];
		rozdania.talon[1] = talonCards[1];
	}
	if(stav->kolo>0){
		fail=false;
		rozdania.generuj(this->somForhont(),this->id,TIME_LIMIT_GENERATION);
        qDebug() << "Vygenerovalo sa" << rozdania.r.size() << "rozdani" << "za cas" << profiler->getTime("minimaxSearch");
        if(rozdania.fail)qDebug() << "Nestihli sa vygenerovat vsetky";


        MyStav ms(this);
        ms.stav = *rozdania.stav;
        for(this->cutoffLevel = 3*(this->hand.size()-1);this->cutoffLevel>=0;this->cutoffLevel-=3)
        {
            if(!quickGame)qDebug() << "Idem prehladavat, cutoff level=" << this->cutoffLevel;
            for(int i=0;i<32;i++)this->rewards[i]=0;
            this->kolkoSaStihlo = 0;
            for(int i=0;i<rozdania.r.size();i++){
//    				QString s="";
//    				for(int j=0;j<32;j++)
//    					s += (rozdania.r[i] & rozdania.getMask(j) )?"1":"0";
//    				qDebug() << s;
                QPair<QList<int>, QList<int> > handsLeftRight = rozdania.getCardsAtRozdanie(i);
//                    qDebug() << rozdania.getCardsAtRozdanie(i);
                ms.hand[this->id] = hand;
                ms.hand[(this->id+1)%3] = handsLeftRight.first;
                ms.hand[(this->id+2)%3] = handsLeftRight.second;
                ms.talon[0] = rozdania.r[i]&31;
                ms.talon[1] = (rozdania.r[i]&992)/32;
//                if(!quickGame)qDebug() << ms.hand[0] << ms.hand[1] << ms.hand[2];
                this->states.clear();
                minimax(ms,true,somForhont()?999999:-999999);
                this->kolkoSaStihlo = i+1;
                if(this->fail){
                    if(!quickGame)
                        qDebug() << "Minimax failed - stihlo sa " << this->kolkoSaStihlo << "/" << rozdania.r.size();
                    break;
                }
            } // end for each rozdanie
            qDebug() << "process rewards";
            int response = this->processRewards();
            if(response==-1)break;
            if(fail)
            {
                if(this->kolkoSaStihlo > 1)
                {
                    return response;
                }
                break;
            }

        } // end for each cutoff level
    } // end if stav->kolo>0
	profiler->stop("minimaxSearch");
	profiler->reset("minimaxSearch");
    return pickSmart(getLegalList());
}

int MinimaxPlayer::processRewards()
{
    for(int i=0;i<32;i++)
    {
        this->rewards[i] /= this->kolkoSaStihlo;
    }
    int chosen=-1;
    qreal max=999999;
    if(somForhont())max=-999999;
    for(int i=0;i<hand.size();i++)
        if(validate(hand[i])==""){
            qreal rew = this->rewards[hand[i]];
            if((rew-max>0)==somForhont()){
                max=rew;
                chosen=hand[i];
            }
        }
    if(this->validate(chosen)==""){
        QString word = QString::number(this->cutoffLevel) + ":reward="+QString::number(max)+" card="+Card::title(chosen);
        if(!quickGame){
//            this->say(word);
            qDebug() << "Minimax time=" << profiler->getTime("minimaxSearch");
        }
    }else{
        QString word = "MINIMAX FAILED "+Card::title(chosen)+" expected reward="+QString::number(max);
//        if(!quickGame)this->say(word);
    }
    return chosen;
}

int MinimaxPlayer::talon(){
    QList<int> legal;
    int pocetKarietFarby[4] = {0,0,0,0};
    foreach(int c,hand){
        pocetKarietFarby[c/8]++;
        if(Card::value(c)!="10" && Card::value(c)!="eso" && c!=stav->hra.tromf){
            legal.push_back(c);
        }
    }
    int esteDoTalonu = 2;
    QList<int> vyber;
    for(int farba=0;farba<4;farba++){
        if(Card::isTromf(farba*8,stav->hra))continue;
        //ak mam eso
        if(hand.contains(farba*8+7)){
            //ak mam aj 10, tak tuto farbu vobec nezhadzujem
            if(hand.contains(farba*8+3))
                continue;
            //ak mam aj hlasku, tiez nezhadzujem tuto farbu
            if(hand.contains(farba*8+5) && hand.contains(farba*8+6))
                continue;
            if(pocetKarietFarby[farba]==2)
                //do talonu dam tu jedinu kartu z farby, ktora nie je eso, takze mi ostane na ruke jedno eso
                for(int c=farba*8;c<farba*8+7;c++)
                    if(hand.contains(c)){
                        vyber.append(c);
                        legal.removeOne(c);
                    }
        }
    }

    for(int farba=0;farba<4;farba++){
        if(Card::isTromf(farba*8,stav->hra))continue;
        if(!hand.contains(farba*8+3) && !hand.contains(farba*8+7) &&
           !this->chcemHratSedmu() &&
           !(hand.contains(farba*8+5) && hand.contains(farba*8+6))) {
                if(esteDoTalonu >= pocetKarietFarby[farba])
                    for(int c=farba*8;c<farba*8+7;c++)
                        if(hand.contains(c)){
                            vyber.append(c);
                            legal.removeOne(c);
                        }
        }
    }

    while(esteDoTalonu>0){
        int min = 9999;
        foreach(int c,legal){
            if(c<min && !Card::isTromf(c,stav->hra)){
                min = c;
            }
        }
        if(min!=9999){
            vyber.append(min);
            legal.removeOne(min);
            esteDoTalonu--;
        } else {
            min = pickMin(legal);
            vyber.append(min);
            legal.removeOne(min);
            esteDoTalonu--;
        }
    }

    return 32*vyber[0]+vyber[1];
}

int MinimaxPlayer::tromf(){
    this->tromfChooser->setHand(this->hand);
    qDebug() << "hand set";
    int tromf = this->tromfChooser->chooseTromf();
    qDebug() << "chosen tromf: " << tromf;
	if(this->hand.contains(tromf)){
		return tromf;
	}
	return pickMin(hand);
}

int MinimaxPlayer::bid(){
    int bids=0;
    int fatty=0;
    int tromf=tromfCount();
    int esa=0;
    QList<bool> trhamHlasku;
    trhamHlasku << false << false << false << false;
    QList<bool> mamHlasku(trhamHlasku);
    foreach(int c,hand){
        if(Card::isFatty(c))fatty++;
        if(Card::value(c)=="eso")esa++;
        if(Card::value(c)=="hornik" || Card::value(c)=="kral"){
            if(trhamHlasku[c/8])mamHlasku[c/8]=true;
            else trhamHlasku[c/8]=true;
        }
    }
    int bodyZaHlasky=0;
    for(int i=0;i<4;i++){
        if(mamHlasku[i]){
            bodyZaHlasky+=20;
            if(i==stav->hra.tromf/8)bodyZaHlasky+=20;
        }
        if(!trhamHlasku[i]){
            bodyZaHlasky-=10;
            if(i==stav->hra.tromf/8)bodyZaHlasky-=10;
        }
    }

    if((somForhont()?9:4)*stav->hra.flekNaHru <= bodyZaHlasky/5+fatty+tromf*tromf*tromf/6+2*esa)bids|=4;

    if(hand.contains(stav->hra.tromf7())){
        //ak mam sedmu, zahlasim ju len ak mam este 2 dalsie tromfy
        if(stav->hra.flekNaSedmu==0 && this->chcemHratSedmu())bids|=2;
        //ak mam sedmu a hlasil ju niekto iny, flekujem do nemoty
        if(stav->hra.flekNaSedmu>=1 && (int)log2(stav->hra.flekNaSedmu)%2==0)bids|=2;
        //inak flekujem rozumne (toto je pripad, ked ju hram asi ja...ak nie, tak uz davno som dal flek)
        // na RE potrebujem aspon 5 tromfov
        // na BOTY aspon 7 tromfov
        if(stav->hra.flekNaSedmu>=2 && (int)log2(stav->hra.flekNaSedmu)+4<=tromf)bids|=2;
    }else{
        //sedmu fleknem, ak mam aspon 4 tromfy
        //na tutti treba 5 tromfov
        if(stav->hra.flekNaSedmu>=1 && (int)log2(stav->hra.flekNaSedmu)+8<=2*tromf)bids|=2;
    }
    return bids;
}

int MinimaxPlayer::pickSmart(QList<int> legal){
    if(legal.count()==1)return legal[0];

    if(stav->hra.farba){
        //ked hram sedmu, nepustim ju len tak
        if((stav->hra.sedma && somForhont()) || (stav->hra.sedmaProti && !somForhont())){
            if(legal.contains(stav->hra.tromf7()))
                legal.removeAll(stav->hra.tromf7());
            if(legal.count()==1)return legal[0];
        }

        //zratam netromfove karty, ked vychadzam, tak ak mozem, tak nie tromfom
        int countNoTromf = 0;
        foreach(int c,legal)
            if(!Card::isTromf(c,stav->hra))
                countNoTromf ++;
        if(stav->kopa.count()==0){
            if(countNoTromf>0)
                foreach(int c,legal)
                    if(Card::isTromf(c,stav->hra))
                        legal.removeAll(c);
        }
        return pickMin(legal);
    }else return pickMin(legal);
}

int MinimaxPlayer::pickMin(QList<int> legal){
	int min = 7;
	foreach(int c,legal){
		if(c%8<=min%8)min=c;
	}
	return min;
}

int MinimaxPlayer::pickTalon(QList<int> legal){
	int min1 = pickMin(legal);
	int min2 = 7;
	foreach(int c,legal){
		if(c!=min1 && c%8<=min2%8)min2=c;
	}
	return min2*32 + min1;
}

bool MinimaxPlayer::chcemHratSedmu(){
    int pocetKarietFarby[4] = {0,0,0,0};
    foreach(int c,hand){
        pocetKarietFarby[c/8]++;
    }
    if(!hand.contains(stav->hra.tromf7()))
        return false;
    // ak mam3 a menej tromfov, nehram sedmu
    if(pocetKarietFarby[stav->hra.tromf7()/8]<4)
        return false;
    // ak mam 5 a viac tromfov, hram sedmu
    if(pocetKarietFarby[stav->hra.tromf7()/8]>4)
        return true;
    // ak mam 4 tromfy, musim mat z kazdej inej farby aspon 1 kartu
    for(int farba=0;farba<4;farba++){
        if(Card::isTromf(farba*8,stav->hra))continue;
        if(pocetKarietFarby[farba]==0)
            return false;
    }
    return true;
}
