#ifndef MINIMAXPLAYER_H
#define MINIMAXPLAYER_H

class MinimaxPlayer;

#include <QList>
#include "../player.h"
#include "../card.h"
#include "../stav.h"
#include "tromfchooser.h"
#include "minimax/mystav.h"
#include "minimax/rozdania.h"
#include "../datasets.h"

class MinimaxPlayer : public Player
{
public:
    MinimaxPlayer();
	~MinimaxPlayer();
	void init();
    bool isMaximizing(MyStav ms);
    int minimax(MyStav ms,bool firstLevel,int alpha);
    int processRewards();
	int play();
	int talon();
	int bid();
    int tromf();
    int pickSmart(QList<int> legal);
    int pickMin(QList<int> legal);
	int pickTalon(QList<int> legal);
    bool chcemHratSedmu();
	Rozdania rozdania;
	int myLastCardInHistory;
	QList<int> states;
	qreal rewards[32];
	bool fail; //this flag is true, if the searching would take too much time
    int kolkoSaStihlo;
    int cutoffLevel;
	TromfChooser* tromfChooser;
//    Datasets evals; //temp variable only for debugging of evaluator

};

#endif // MINIMAXPLAYER_H
