#include "minplayer.h"

MinPlayer::MinPlayer()
{
	type = "minimalista";
	name = "Minimalista";
}

int MinPlayer::play(){
	return pickMin(getLegalList());
}

int MinPlayer::talon(){
	QList<int> legal;
	foreach(int c,hand){
		if(Card::value(c)!="10" && Card::value(c)!="eso" && c!=stav->hra.tromf)
			legal.push_back(c);
	}
	return pickMinTwo(legal);
}

int MinPlayer::bid(){
	if(stav->hra.flekNaHru==1)return 4;
	else return 0;
}

int MinPlayer::tromf(){
	return pickMin(hand);
}

int MinPlayer::pickMin(QList<int> legal){
	int min = 7;
	foreach(int c,legal){
		if(c%8<=min%8)min=c;
	}
	return min;
}

int MinPlayer::pickMinTwo(QList<int> legal){
	int min1 = pickMin(legal);
	int min2 = 7;
	foreach(int c,legal){
		if(c!=min1 && c%8<=min2%8)min2=c;
	}
	return min2*32 + min1;
}
