#include <cmath>
#include "smartplayer.h"

SmartPlayer::SmartPlayer()
{
	type = "smart";
	name = "Smart player";
}

int SmartPlayer::play(){
	return pickSmart(getLegalList());
}

int SmartPlayer::talon(){
	QList<int> legal;
	int pocetKarietFarby[4] = {0,0,0,0};
	foreach(int c,hand){
		pocetKarietFarby[c/8]++;
		if(Card::value(c)!="10" && Card::value(c)!="eso" && c!=stav->hra.tromf){
			legal.push_back(c);
		}
	}
	int esteDoTalonu = 2;
	QList<int> vyber;
	for(int farba=0;farba<4;farba++){
		if(Card::isTromf(farba*8,stav->hra))continue;
		//ak mam eso
		if(hand.contains(farba*8+7)){
			//ak mam aj 10, tak tuto farbu vobec nezhadzujem
			if(hand.contains(farba*8+3))
				continue;
			//ak mam aj hlasku, tiez nezhadzujem tuto farbu
			if(hand.contains(farba*8+5) && hand.contains(farba*8+6))
				continue;
			if(pocetKarietFarby[farba]==2)
				//do talonu dam tu jedinu kartu z farby, ktora nie je eso, takze mi ostane na ruke jedno eso
				for(int c=farba*8;c<farba*8+7;c++)
					if(hand.contains(c)){
						vyber.append(c);
						legal.removeOne(c);
					}
		}
	}

	for(int farba=0;farba<4;farba++){
		if(Card::isTromf(farba*8,stav->hra))continue;
		if(!hand.contains(farba*8+3) && !hand.contains(farba*8+7) &&
		   !this->chcemHratSedmu() &&
		   !(hand.contains(farba*8+5) && hand.contains(farba*8+6))) {
				if(esteDoTalonu >= pocetKarietFarby[farba])
					for(int c=farba*8;c<farba*8+7;c++)
						if(hand.contains(c)){
							vyber.append(c);
							legal.removeOne(c);
						}
		}
	}

	while(esteDoTalonu>0){
		int min = 9999;
		foreach(int c,legal){
			if(c<min && !Card::isTromf(c,stav->hra)){
				min = c;
			}
		}
		if(min!=9999){
			vyber.append(min);
			legal.removeOne(min);
			esteDoTalonu--;
		} else {
			min = pickMin(legal);
			vyber.append(min);
			legal.removeOne(min);
			esteDoTalonu--;
		}
	}

    return 32*vyber[0]+vyber[1];
}

int SmartPlayer::bid(){
	int bids=0;
	int fatty=0;
	int tromf=tromfCount();
	int esa=0;
	QList<bool> trhamHlasku;
	trhamHlasku << false << false << false << false;
	QList<bool> mamHlasku(trhamHlasku);
	foreach(int c,hand){
		if(Card::isFatty(c))fatty++;
		if(Card::value(c)=="eso")esa++;
		if(Card::value(c)=="hornik" || Card::value(c)=="kral"){
			if(trhamHlasku[c/8])mamHlasku[c/8]=true;
			else trhamHlasku[c/8]=true;
		}
	}
	int bodyZaHlasky=0;
    for(int i=0;i<4;i++){
		if(mamHlasku[i]){
			bodyZaHlasky+=20;
			if(i==stav->hra.tromf/8)bodyZaHlasky+=20;
		}
        if(!trhamHlasku[i]){
            bodyZaHlasky-=10;
            if(i==stav->hra.tromf/8)bodyZaHlasky-=10;
        }
    }



    if((somForhont()?9:4)*stav->hra.flekNaHru <= bodyZaHlasky/5+fatty+tromf*tromf*tromf/6+2*esa)bids|=4;

	if(hand.contains(stav->hra.tromf7())){
		//ak mam sedmu, zahlasim ju len ak mam este 2 dalsie tromfy
		if(stav->hra.flekNaSedmu==0 && this->chcemHratSedmu())bids|=2;
		//ak mam sedmu a hlasil ju niekto iny, flekujem do nemoty
		if(stav->hra.flekNaSedmu>=1 && (int)log2(stav->hra.flekNaSedmu)%2==0)bids|=2;
		//inak flekujem rozumne (toto je pripad, ked ju hram asi ja...ak nie, tak uz davno som dal flek)
		// na RE potrebujem aspon 5 tromfov
		// na BOTY aspon 7 tromfov
		if(stav->hra.flekNaSedmu>=2 && (int)log2(stav->hra.flekNaSedmu)+4<=tromf)bids|=2;
	}else{
        //sedmu fleknem, ak mam aspon 4 tromfy
		//na tutti treba 5 tromfov
        if(stav->hra.flekNaSedmu>=1 && (int)log2(stav->hra.flekNaSedmu)+8<=2*tromf)bids|=2;
	}
	return bids;
}

int SmartPlayer::tromf(){
	return pickMax(hand);
}

int SmartPlayer::pickSmart(QList<int> legal){
	if(legal.count()==1)return legal[0];

	if(stav->hra.farba){
		//ked hram sedmu, nepustim ju len tak
		if((stav->hra.sedma && somForhont()) || (stav->hra.sedmaProti && !somForhont())){
			if(legal.contains(stav->hra.tromf7()))
				legal.removeAll(stav->hra.tromf7());
			if(legal.count()==1)return legal[0];
		}

		//zratam netromfove karty, ked vychadzam, tak ak mozem, tak nie tromfom
		int countNoTromf = 0;
		foreach(int c,legal)
			if(!Card::isTromf(c,stav->hra))
				countNoTromf ++;
		if(stav->kopa.count()==0){
			if(countNoTromf>0)
				foreach(int c,legal)
					if(Card::isTromf(c,stav->hra))
						legal.removeAll(c);
		}
		return pickMin(legal);
	}else return pickMin(legal);
}

int SmartPlayer::pickMin(QList<int> legal){
	int min = 7;
	foreach(int c,legal){
		if(c%8<=min%8)min=c;
	}
	return min;
}

int SmartPlayer::pickMinTwo(QList<int> legal){
	int min1 = pickMin(legal);
	int min2 = 7;
	foreach(int c,legal){
		if(c!=min1 && c%8<=min2%8)min2=c;
	}
	return min2*32 + min1;
}

int SmartPlayer::pickMax(QList<int> legal){
	int Max = 0;
	foreach(int c,legal){
		if(c%8>=Max%8)Max=c;
	}
	return Max;
}

int SmartPlayer::pickMaxTwo(QList<int> legal){
	int Max1 = pickMax(legal);
	int Max2 = 0;
	foreach(int c,legal){
		if(c!=Max1 && c%8>=Max2%8)Max2=c;
	}
	return Max2*32 + Max1;
}

bool SmartPlayer::chcemHratSedmu(){
	int pocetKarietFarby[4] = {0,0,0,0};
	foreach(int c,hand){
		pocetKarietFarby[c/8]++;
	}
	if(!hand.contains(stav->hra.tromf7()))
		return false;
	// ak mam3 a menej tromfov, nehram sedmu
	if(pocetKarietFarby[stav->hra.tromf7()/8]<4)
		return false;
	// ak mam 5 a viac tromfov, hram sedmu
	if(pocetKarietFarby[stav->hra.tromf7()/8]>4)
		return true;
	// ak mam 4 tromfy, musim mat z kazdej inej farby aspon 1 kartu
	for(int farba=0;farba<4;farba++){
		if(Card::isTromf(farba*8,stav->hra))continue;
		if(pocetKarietFarby[farba]==0)
			return false;
	}
	return true;
}
