#ifndef GAMESIMULATOR_CPP
#define GAMESIMULATOR_CPP

#include<cmath>
#include "gamesimulator.h"

GameSimulator::GameSimulator(){
  profiler = new Profiler();
  rg.setSeed(-1);
  stav = new Stav();
  for(int i=0;i<3;i++){
	  p[i] = new SmartPlayer();
	  p[i]->id = i;
	  p[i]->quickGame = true;
	  p[i]->stav = stav;
  }
}

GameSimulator::~GameSimulator(){
	delete profiler;
	for(int i=0;i<3;i++)
		delete p[i];
	delete stav;
}

unsigned int GameSimulator::getCardMask(int c){
	return (1 << (31-c));
}

qreal GameSimulator::expectedResult(unsigned int rozdanie, int tromf, int timeLimit){
	profiler->start(QString::number(rozdanie)+Card::title(tromf));
	int sum = 0;
	int count = 0;
//	(*out) << "----------------\n";
	while(profiler->getTime(QString::number(rozdanie)+Card::title(tromf)) < timeLimit){
		count++;
		stav->newGame();
		stav->forhont = 0;
		stav->hra.farba = true;
		stav->hra.tromf = tromf;
		rozdaj(rozdanie);
		talon();
		stav->id = 0;
		bid(p[stav->id]->bid());
		stav->vysid = 0;
		stav->id = 0;
		stav->kolo = 0;
		stav->kopa.clear();
		while(stav->kolo<10){
			if(stav->kopa.count()<3){
				int k = p[stav->id]->play();
//				(*out) << stav->id << ": " << p[stav->id]->message << endl;
				if(Card::value(k)=="hornik" && p[stav->id]->hand.contains(k+1)){
					int hlaska = 20;
					if(Card::color(k)==Card::color(stav->hra.tromf))
						hlaska = 40;
					p[stav->id]->body += hlaska;
					p[stav->id]->hlasky++;
					stav->hlaska(hlaska);
				}
				stav->cHist.push_back(k);
				stav->kopa.push_back(k);
				p[stav->id]->removeCard(k);
				stav->dalsi();
			} else {
				int winner = stav->trick();
				foreach(int c,stav->kopa){
					if(Card::value(c)=="10" || Card::value(c)=="eso")
						p[winner]->body += 10;
				}
				if(stav->kolo==9)p[winner]->body += 10;
				stav->id=winner;
				stav->kolo++;
				stav->pHist.push_back(winner);
				stav->vysid = winner;
				stav->kopa.clear();
			}
		}
		int res = stav->results(true);
//		(*out) << "results: " << QString::number(res) << "\n";
//		for(int i=0;i<stav->res.size();i++){
//			(*out) << stav->res[i].first << " " << stav->res[i].second << "\n";
//		}
//		(*out) << "----------------\n";
		sum += res;
		stav->hra.tromf=-1;
	}
	profiler->reset();
//	(*out) << "stihlo sa " << count << " hier\n";
	qDebug() << "stihlo sa " << count << " hier";
	if(count==0)count=1;
	return (qreal)sum/(qreal)count;
}

void GameSimulator::rozdaj(unsigned int rozdanie){
	for(int i=0;i<3;i++){
		p[i]->hand.clear();
	}
	QList<int> deck;
	for(int i=0;i<32;i++){
		if(rozdanie & getCardMask(i)){
			p[0]->hand.append(i);
			continue;
		}
		deck.append(i);
	}
	if(deck.size()!=25)
		qDebug() << "Deck size bug: " << deck.size();
	int swapCount = 1000 + rg.rand(1000);
	for(int i=0;i<swapCount;i++)
		deck.swap(rg.rand(25),rg.rand(25));
	int i=0;
	for(;i<5;i++)p[0]->hand.append(deck[i]);
	for(;i<15;i++)p[1]->hand.append(deck[i]);
	for(;i<25;i++)p[2]->hand.append(deck[i]);
}

void GameSimulator::talon(){
	int talon = p[0]->talon();
	int tal1 = talon/32;
	int tal2 = talon%32;
	p[0]->talonCards[0] = tal1;
	p[0]->talonCards[1] = tal2;
	p[0]->removeCard(tal1);
	p[0]->removeCard(tal2);
}

void GameSimulator::bid(int res){
	bool ideForhont = (stav->id == stav->forhont);
	bool bidd = false; // if the state of bid has changed
  
  
	if(res&4 && stav->hra.flekNaHru<128){ //hra
		if(stav->hra.flekNaHru == 0){
			if(ideForhont){
				stav->hra.flekNaHru = 1;
				bidd=true;
			}
			else qCritical() << "Opponent " << stav->id << " hlasi hru skor ako forhont!";
		} else {
			if(ideForhont ^ ((int)log2(stav->hra.flekNaHru)%2==0)){
				stav->hra.flekNaHru *= 2;
				bidd=true;
			}
		}
	}
  
  if(res&2 && stav->hra.flekNaSedmu<128){ //sedma
    if(stav->hra.sedma){
      if(ideForhont ^ ((int)log2(stav->hra.flekNaSedmu)%2==0)){
	stav->hra.flekNaSedmu *= 2;
	bidd=true;
      }
    }else if(stav->hra.sedmaProti){
      if(ideForhont ^ ((int)log2(stav->hra.flekNaSedmu)%2==1)){
	stav->hra.flekNaSedmu *= 2;
	bidd=true;
      }
    }else{
      if(ideForhont)stav->hra.sedma = true;
      else stav->hra.sedmaProti = true;
      stav->hra.flekNaSedmu = 1;
      bidd=true;
    }
  }
  
  if(res&1 && stav->hra.flekNaStovku<128){ //stovka
    if(stav->hra.stovka){
      if(ideForhont ^ ((int)log2(stav->hra.flekNaStovku)%2==0)){
	stav->hra.flekNaStovku *= 2;
	bidd=true;
      }
    }else if(stav->hra.stovkaProti){
      if(ideForhont ^ ((int)log2(stav->hra.flekNaStovku)%2==1)){
	stav->hra.flekNaStovku *= 2;
	bidd=true;
      }
    }else{
      if(ideForhont)stav->hra.stovka = true;
      else stav->hra.stovkaProti = true;
      stav->hra.flekNaStovku = 1;
      bidd=true;
    }
  }
  bool endBidding = false;
  if(!bidd){
    if(ideForhont)endBidding=true;
    else if(biddingHistory.last()==0)endBidding=true;
    biddingHistory.append(0);
  }else biddingHistory.append(res);
  if(!endBidding)
    bid(p[stav->id]->bid());
  biddingHistory.clear();
}
#endif
