#ifndef GAMESIMULATOR_H
#define GAMESIMULATOR_H

#include <QString>
#include "../profiler.h"
#include "../card.h"
#include "../stav.h"
#include "../player.h"
#include "../players/smartplayer.h"

class GameSimulator{
  public:
    GameSimulator();
    ~GameSimulator();
    unsigned int getCardMask(int c);
    /**
    * Vrati ocakavany result pri danom rozdani pri danom zvolenom tromfe.
    * Nahodne rozda zvysne karty a odohra hru.
    *
    */
    qreal expectedResult(unsigned int rozdanie, int tromf, int timeLimit);
    /**
    * Rozda karty nahodne hracom tak, ze pouzitych 7 sa tam nenachadza.
    *
    */
    void rozdaj(unsigned int rozdanie);
    void talon();
    /**
    * Manazuje bidding.
    * @param res response from player
    *
    */
    void bid(int res);
    Profiler* profiler;
    Stav* stav;
    Player* p[3];
    RandomGeneratorIPSC rg;
    QList<int> biddingHistory;
	QTextStream* out;
};

#endif
