#include "profiler.h"

Profiler::Profiler()
{
}

long long Profiler::getTime(QString name){
	long long time = QDateTime::currentDateTime().toTime_t()*1000 + QTime::currentTime().msec();
	if(name=="")
		return time;
	if(timers.count(name)==0){
		qDebug() << name << " timer has not started";
		return 0;
	}
	if(timers.count(name)>1)
		qDebug() << "timer stop warning: " << name << " has multiple starts";
	return time - timers.value(name);
}

void Profiler::reset(QString name){
	if(name==""){
		counts.clear();
		timers.clear();
		totals.clear();
	}else{
		if(totals.count(name)==0 && timers.count(name)==0){
			qDebug() << name << " cant be reset - it has no entry in totals neither in timers";
		}else{
			if(totals.count(name)==0)
				stop(name);
			totals[name]=0;
		}
	}
}

void Profiler::start(QString name){
	timers.insert(name,getTime());
}

void Profiler::stop(QString name){
	long long time = getTime();
	if(timers.count(name)==0){
		qDebug() << name << " timer has not started";
		return;
	}
	if(timers.count(name)>1)
		qDebug() << "timer stop warning: " << name << " has multiple starts";

	counts.insert(name,counts.value(name,0) + 1);
	totals.insert(name,totals.value(name,0) + time-timers.value(name));
	//this is weird - removing the timer has influence on qrand
	//(check it by print a qrand() before and after this)
        //this comment is deprecated due to custom random generator
	timers.remove(name);
}
