#ifndef PROFILER_H
#define PROFILER_H

#include <QDebug>
#include <QString>
#include <QMap>
#include <QTime>
#include <QDateTime>

class Profiler
{
public:
    Profiler();
	/**
	  * If name provided, returns the time in ms of timer with given name.
	  * Otherwise returns the current time in ms.
	  *
	  */
	long long getTime(QString name="");
	/**
	  * Initializes arrays.
	  * If provided with name, it only resets the timer with that name.
	  *
	  */
	void reset(QString name="");
	void start(QString name);
	void stop(QString name);
	QMap<QString, qreal> totals;
	QMap<QString, int> counts;
	QMap<QString, long long> timers;
};

#endif // PROFILER_H
