#ifndef QUICKGAMEDIALOG_H
#define QUICKGAMEDIALOG_H

class QuickGameDialog;

#include <QDialog>
#include "game.h"
#include "quickgamethread.h"

namespace Ui {
    class QuickGameDialog;
}

class QuickGameDialog : public QDialog {
    Q_OBJECT
public:
	QuickGameDialog(Game* g,QWidget *parent = 0);
    ~QuickGameDialog();
public slots:
	/**
	  *Updates the ui when heavy duty is on.
	  *-1 means the progress bar not to be updated
	  *
	  */
	void progress(int step=-1);
	void show();


protected:
    void changeEvent(QEvent *e);
	void closeEvent(QCloseEvent *event);

protected slots:
	void reject();

private:
    Ui::QuickGameDialog *ui;
	Game* game;
	QuickGameThread* thread;

private slots:
	void on_pushButton_2_clicked();
	void on_checkBox_stateChanged(int state);
	void on_pushButton_clicked();
    void on_checkBox_2_stateChanged(int );
};

#endif // QUICKGAMEDIALOG_H
