#ifndef RANDOMGENERATOR_CPP
#define RANDOMGENERATOR_CPP

#include<QTime>
#include<QDebug>
#include "randomgenerator.h"

RandomGenerator::RandomGenerator(int seed){
  setSeed(seed);
}

RandomGenerator::~RandomGenerator(){
}

void RandomGenerator::setSeed(int seed){
  if(seed==-1)base = QCryptographicHash::hash(QByteArray().append(QTime::currentTime().toString()),QCryptographicHash::Md5);
  else base = QCryptographicHash::hash(QByteArray::number(seed),QCryptographicHash::Md5);
}

int RandomGenerator::rand(int max){
  base = QCryptographicHash::hash(base,QCryptographicHash::Md5);
  int rand=0;
  int multiplicator=1;
  for(int i=0;i<4;i++){
    rand += base.at(i)*multiplicator;
    multiplicator *= 256;
  }
  return ((rand % max)+max)%max;
}

#endif
