#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(Game* g, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    game = g;
    ui->setupUi(this);
	quick = new QuickGameDialog(game);
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsDialog::show(){
    settings = new QSettings("marias.ini", QSettings::IniFormat);
    ui->spinBox->setValue(settings->value("graphics/delay",100).toInt());
	ui->lineEdit_4->setText(settings->value("shuffling/seed",47).toString());
	ui->checkBox->setChecked(settings->value("shuffling/random",1)==1);
	for(int i=0;i<ui->comboBox->count();i++){
		if(ui->comboBox->itemText(i) == settings->value("players/left","RandomPlayer"))
			ui->comboBox->setCurrentIndex(i);
	}
	for(int i=0;i<ui->comboBox_2->count();i++){
		if(ui->comboBox_2->itemText(i) == settings->value("players/right","RandomPlayer"))
			ui->comboBox_2->setCurrentIndex(i);
	}
	for(int i=0;i<ui->comboBox_3->count();i++){
		if(ui->comboBox_3->itemText(i) == settings->value("players/front","HumanPlayer"))
			ui->comboBox_3->setCurrentIndex(i);
	}
	ui->lineEdit_3->setText(game->players[0]->name);
	ui->lineEdit_2->setText(game->players[2]->name);
	ui->lineEdit->setText(game->players[1]->name);
    QDialog::show();
}

void SettingsDialog::accept(){
	settings->setValue("graphics/delay",ui->spinBox->value());
	settings->setValue("shuffling/random",ui->checkBox->checkState()==Qt::Checked?1:0);
	settings->setValue("shuffling/seed",ui->lineEdit_4->text());
	if(ui->checkBox->checkState()!=Qt::Checked)
		game->rg.setSeed(ui->lineEdit_4->text().toInt());
	if(settings->value("players/left","RandomPlayer")!=ui->comboBox->currentText()){
		game->changePlayer(1,ui->comboBox->currentText());
		settings->setValue("players/left",ui->comboBox->currentText());
	}
	if(settings->value("players/right","RandomPlayer")!=ui->comboBox_2->currentText()){
		game->changePlayer(2,ui->comboBox_2->currentText());
		settings->setValue("players/right",ui->comboBox_2->currentText());
	}
	if(settings->value("players/front","HumanPlayer")!=ui->comboBox_3->currentText()){
		game->changePlayer(0,ui->comboBox_3->currentText());
		settings->setValue("players/front",ui->comboBox_3->currentText());
	}
	game->players[0]->name = ui->lineEdit_3->text();
	settings->setValue("players/front_name",game->players[0]->name);
	game->players[1]->name = ui->lineEdit->text();
	settings->setValue("players/left_name",game->players[1]->name);
	game->players[2]->name = ui->lineEdit_2->text();
	settings->setValue("players/right_name",game->players[2]->name);
	close();
	DeskView::draw();
}

void SettingsDialog::checkForQuickGame(){
	if(ui->comboBox->currentText()!="HumanPlayer" && ui->comboBox_2->currentText()!="HumanPlayer" && ui->comboBox_3->currentText()!="HumanPlayer"){
		ui->pushButton->setEnabled(true);
	}else{
		ui->pushButton->setEnabled(false);
	}
}

void SettingsDialog::on_comboBox_currentIndexChanged(int index)
{
	ui->lineEdit->setText(ui->comboBox->currentText());
	checkForQuickGame();
}

void SettingsDialog::on_comboBox_2_currentIndexChanged(int index)
{
	ui->lineEdit_2->setText(ui->comboBox_2->currentText());
	checkForQuickGame();
}

void SettingsDialog::on_comboBox_3_currentIndexChanged(int index)
{
	ui->lineEdit_3->setText(ui->comboBox_3->currentText());
	checkForQuickGame();
}

void SettingsDialog::on_pushButton_clicked()
{
	DeskView::cleanGraphics(true);
	qDebug() << "quickGame dialog";
	accept();
	game->init();
	game->quickGame = true;
	close();
	quick->show();

}

void SettingsDialog::on_checkBox_stateChanged(int state)
{
	ui->lineEdit_4->setEnabled(state==Qt::Unchecked);
	ui->lineEdit_4->setVisible(state==Qt::Unchecked);
	ui->label_7->setEnabled(state==Qt::Unchecked);
	ui->label_7->setVisible(state==Qt::Unchecked);
}
