#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

class SettingsDialog;

#include <QDialog>
#include <QSettings>
#include "game.h"
#include "playerfactory.h"
#include "quickgamedialog.h"

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog {
    Q_OBJECT
public:
    SettingsDialog(Game* g, QWidget *parent = 0);
    ~SettingsDialog();
public slots:
    void show();
    void accept();

protected:
    void changeEvent(QEvent *e);

private:
	void checkForQuickGame();
    Ui::SettingsDialog *ui;
    QSettings* settings;
    Game* game;
	QuickGameDialog* quick;

private slots:
	void on_checkBox_stateChanged(int state);
	void on_pushButton_clicked();
	void on_comboBox_3_currentIndexChanged(int index);
	void on_comboBox_2_currentIndexChanged(int index);
	void on_comboBox_currentIndexChanged(int index);
};

#endif // SETTINGSDIALOG_H
