#include "stav.h"

Stav::Stav()
{
    forhont = -1;
}

void Stav::newGame(){
	hra = Hra();
	kolo=-5;
	forhont = (forhont+1)%3;
	kopa.clear();
	cHist.clear();
	pHist.clear();
	res.clear();
}

int Stav::dalsi(){
	id = (id+1)%3;
	return id;
}

int Stav::veduca(int kolo){
	if(cHist.count() <= kolo*3){
		qDebug() << "Stav::veduca: kolo " << kolo << " este nezacalo";
		return -1;
	}
	if(cHist.count() == kolo*3+1)
		return cHist.last();
	if(cHist.count() == kolo*3+2)
		return Card::stronger(cHist[kolo*3],cHist[kolo*3+1],hra);
	if(pHist.count()>=kolo && kolo>0)
		return cHist[kolo*3+(3+pHist[kolo]-pHist[kolo-1])%3];
	return cHist[kolo*3 + Card::stich(cHist[kolo*3],cHist[kolo*3+1],cHist[kolo*3+2],hra)];
}

QString Stav::validate(){
	if(kopa.count()<0 || kopa.count()>3)return QObject::tr("Na kope je zly pocet kariet: %1").arg(kopa.count());
	for(int c=0;c<32;c++){
		if(cHist.count(c)>1)
			return QObject::tr("Duplicitna karta v historii: %1").arg(c);
	}
	if(kopa.count()>cHist.count())
		return QObject::tr("Na kope je viac kariet ako v historii");
	for(int i=1;i<=kopa.count();i++)
		if(cHist[cHist.count()-i] != kopa[kopa.count()-i])
			return QObject::tr("Karty na kope nesedia s kartami v historii");
	return "";
}

int Stav::trick(){
	if(kopa.count()!=3){
		qDebug() << "Stav::trick(): Kopa neni plna";
		return -1;
	}
	if(pHist.isEmpty() && id!=forhont){
		qDebug() << "Stav::trick(): Nesedi id (prvy stich)";
		return -1;
	}
	if(!pHist.isEmpty() && id!=pHist.last()){
		qDebug() << "Stav::trick(): Nesedi id s pHist";
		return -1;
	}
	if(id!=vysid){
		qDebug() << "Stav::trick(): Nesedi id s vysid";
		return -1;
	}
	int c=cHist[cHist.count()-3];
	int d=cHist[cHist.count()-2];
	int e=cHist[cHist.count()-1];
	int p=-1; //player that won the trick
	if(!Card::stronger(d,c,hra) && !Card::stronger(e,c,hra))
		p=vysid;
	else if(Card::stronger(d,c,hra) && !Card::stronger(e,d,hra))
		p=(vysid+1)%3;
	else p=(vysid+2)%3;

	int stichPoints=0;
	if(Card::isFatty(c))stichPoints+=10;
	if(Card::isFatty(d))stichPoints+=10;
	if(Card::isFatty(e))stichPoints+=10;
	if(kolo==9)stichPoints+=10;

	if(p==forhont)
		hra.forhontPoints += stichPoints;
	else hra.oppPoints +=stichPoints;

	return p;
}

void Stav::hlaska(int points){
	if(id==forhont){
		hra.forhontHlasky++;
		hra.forhontPoints+=points;
	}else{
		hra.oppHlasky++;
		hra.oppPoints+=points;
	}
}

int Stav::hraResults(bool storeData){
	int outcome=0;

	if(hra.forhontPoints>hra.oppPoints){
		outcome = 1;
		if(storeData)res.push_back(ResRow(QObject::tr("Vyhrana hra"),"+1",false));
	}else{
		outcome = -1;
		if(storeData)res.push_back(ResRow(QObject::tr("Prehrana hra"),"-1",false));
	}

	if(!hra.stovka && hra.forhontPoints>=100){
		outcome <<= (hra.forhontPoints-90)/10;
		if(storeData)res.push_back(ResRow(QObject::tr("Ticha stovka%1").arg(hra.forhontPoints>100?(" ("+QString::number(hra.forhontPoints)+")"):""),"*"+QString::number(1<<((hra.forhontPoints-90)/10)),false));
	}
	if(!hra.stovkaProti && hra.oppPoints>=100){
		outcome <<= (hra.oppPoints-90)/10;
		if(storeData)res.push_back(ResRow(QObject::tr("Ticha stovka proti%1").arg(hra.oppPoints>100?(" ("+QString::number(hra.oppPoints)+")"):""),"*"+QString::number(1<<((hra.oppPoints-90)/10)),false));
	}
	outcome *= hra.flekNaHru;
	if(storeData){
		if(hra.flekNaHru>1)
			res.push_back(ResRow(QObject::tr("%1 na hru").arg(GlobalStrings::flek(hra.flekNaHru)),"*"+QString::number(hra.flekNaHru),false));
		if(res.count()>1)
			res.push_back(ResRow(QObject::tr("Hra spolu"),(outcome>=0?"+":"") + QString::number(outcome),true));
		else res.last().third = true;
	}
	return outcome;
}

int Stav::sedmaResults(bool storeData){
	if(pHist.count()<10)return 0;
	int outcome=0;
	bool sedmaVPoslednomStichu = cHist.indexOf(hra.tromf7())>26;
	bool uhranaSedma = (veduca(9)==hra.tromf7());
	bool zabitaSedma = sedmaVPoslednomStichu && !uhranaSedma;
	bool sedmuDalForhont = cHist[(3+forhont-pHist[8])%3 + 27]==hra.tromf7();

	if(!hra.sedma && !hra.sedmaProti && sedmaVPoslednomStichu){
		//nieco tiche
		if(storeData){
			if(uhranaSedma && sedmuDalForhont)
				res.push_back(ResRow(QObject::tr("Ticha sedma"),"+1",true));
			if(uhranaSedma && !sedmuDalForhont)
				res.push_back(ResRow(QObject::tr("Ticha sedma proti"),"-1",true));
			if(zabitaSedma && sedmuDalForhont)
				res.push_back(ResRow(QObject::tr("Ticha zabita sedma"),"-1",true));
			if(zabitaSedma && !sedmuDalForhont)
				res.push_back(ResRow(QObject::tr("Ticha zabita sedma proti"),"+1",true));
		}
		if(zabitaSedma ^ sedmuDalForhont)outcome=1;
		else outcome = -1;
	}
	if(hra.sedma){
		if(uhranaSedma && sedmuDalForhont){
			outcome=2;
			if(storeData)res.push_back(ResRow(QObject::tr("Vyhrana sedma"),"+2",false));
		}else{
			outcome=-2;
			if(storeData)res.push_back(ResRow(QObject::tr("Prehrana sedma"),"-2",false));
		}
	}
	if(hra.sedmaProti){
		if(uhranaSedma && !sedmuDalForhont){
			outcome=-2;
			if(storeData)res.push_back(ResRow(QObject::tr("Vyhrana sedma proti"),"-2",false));
		}else{
			outcome=2;
			if(storeData)res.push_back(ResRow(QObject::tr("Prehrana sedma proti"),"+2",false));
		}
	}
	if(hra.flekNaSedmu>1)
			outcome *= hra.flekNaSedmu;
	if(storeData){
		if(hra.flekNaSedmu>1){
			res.push_back(ResRow(QObject::tr("%1 na sedmu").arg(GlobalStrings::flek(hra.flekNaSedmu)),"*"+QString::number(hra.flekNaSedmu),false));
			res.push_back(ResRow(QObject::tr("Sedma spolu"),(outcome>=0?"+":"") + QString::number(outcome),true));
		}else res.last().third=true;
	}
	return outcome;
}


int Stav::stovkaResults(bool storeData){
	int outcome=0;

	int bodySJednouHlaskou=0;
	if(hra.stovka){
		bodySJednouHlaskou = hra.forhontPoints;
		if(hra.forhontHlasky>0)bodySJednouHlaskou -= 20*(hra.forhontHlasky - 1);
//		qDebug() << "forhontPoints: " << QString::number(hra.forhontPoints);
//		qDebug() << "forhontHlasky: " << QString::number(hra.forhontHlasky);
//		qDebug() << "body s jednou hlaskou: " << QString::number(bodySJednouHlaskou);
		if(bodySJednouHlaskou>=100){
			outcome = 4 << ((hra.forhontPoints-100)/10);
			if(storeData)res.push_back(ResRow(QObject::tr("Vyhrana stovka (%1)").arg(QString::number(bodySJednouHlaskou)),"+"+QString::number(outcome),false));
		}else{
			outcome = -4 << ((90-bodySJednouHlaskou)/10);
			if(storeData)res.push_back(ResRow(QObject::tr("Prehrana stovka (%1)").arg(QString::number(bodySJednouHlaskou)),QString::number(outcome),false));
		}
	}
	if(hra.stovkaProti){
		bodySJednouHlaskou = hra.oppPoints;
		if(hra.oppHlasky>0)bodySJednouHlaskou -= 20*(hra.oppHlasky-1);
		if(bodySJednouHlaskou>=100){
			outcome = -4 << ((hra.oppPoints-100)/10);
			if(storeData)res.push_back(ResRow(QObject::tr("Vyhrana stovka proti (%1)").arg(QString::number(bodySJednouHlaskou)),QString::number(outcome),false));
		}else{
			outcome = 4 << ((90-bodySJednouHlaskou)/10);
			if(storeData)res.push_back(ResRow(QObject::tr("Prehrana stovka proti (%1)").arg(QString::number(bodySJednouHlaskou)),"+"+QString::number(outcome),false));
		}
	}
	outcome *= hra.flekNaStovku;
	if(storeData){
		if(hra.flekNaStovku>1){
			res.push_back(ResRow(QObject::tr("%1 na stovku").arg(GlobalStrings::flek(hra.flekNaStovku)),"*"+QString::number(hra.flekNaStovku),false));
			res.push_back(ResRow(QObject::tr("Stovka spolu"),(outcome>=0?"+":"") + QString::number(outcome),true));
		}
		res.last().third=true;
	}
	return outcome;
}

int Stav::results(bool storeData){
	if(storeData)res.clear();
	int outcome=0;
	if(hra.farba){
		outcome = hraResults(storeData)+sedmaResults(storeData)+stovkaResults(storeData);
		if(Card::color(hra.tromf)=="cerven"){
			if(storeData)res.push_back(ResRow(QObject::tr("Medzisucet"),(outcome>=0?"+":"")+QString::number(outcome),false));
			if(storeData)res.push_back(ResRow(QObject::tr("Cerveny tromf"),"*2",false));
			outcome *= 2;
		}
	}
	if(storeData)res.push_back(ResRow(QObject::tr("Spolu"),(outcome>=0?"+":"")+QString::number(outcome),false));
	return outcome;
}
