#ifndef STAV_H
#define STAV_H

/**
  *Class Hra describes goals during the game.
  *
  */
class Hra;

/**
  *Class Stav keeps informations on game state. Also keeps information on game goals in instance of Hra.
  *
  */
class Stav;
// has size less than 250 B

#include <QList>
#include <QPair>
#include "QTriple.h"
#include "card.h"
#include "globalstrings.h"

class Hra
{
public:
	Hra(){
		farba=true;
		tromf=-1;
		flekNaHru=0;

		sedma=false;
		sedmaProti=false;
		flekNaSedmu=0;

		stovka=false;
		stovkaProti=false;
		flekNaStovku=0;

		durch=false;
		betl=false;
		zlaFarbaPid=0;
		flekNaDurch=0;
		flekNaBetl=0;

		forhontPoints=0;
		oppPoints=0;
		forhontHlasky=0;
		oppHlasky=0;
	}

    int tromf7() const{
		return 8*(tromf/8);
	}

	bool farba;

	int tromf;
	int flekNaHru;

	bool sedma;
	bool sedmaProti;
	int flekNaSedmu;

	bool stovka;
	bool stovkaProti;
	int flekNaStovku;

	bool durch;
	bool betl;
	int zlaFarbaPid;
	int flekNaDurch;
	int flekNaBetl;

	int forhontPoints;
	int oppPoints;
	int forhontHlasky;
	int oppHlasky;
};

class Stav
{
public:
    Stav();
	/**
	  *Resetting some things, so new game can begin
	  *
	  */
	void newGame();
	/**
	  *Next player's turn. (dalsi=next)
	  *
	  */
	int dalsi();
	/**
	  *Checks card history for strongest card in round kolo (veduca=leading, kolo=round)
	  *
	  */
	int veduca(int kolo);
	/**
	  *Checks if this state is valid
	  *
	  */
	QString validate();
	/**
	  *Returns id of player that takes the trick. Also modifies the state.
	  *
	  */
	int trick();
	/**
	  *The current players has a marriage call (hlaska)
	  *
	  */
	void hlaska(int points);
	/**
	  *Returns money for hra (including fleking and quiet hundred)
	  *
	  */
	int hraResults(bool storeData=false);
	int sedmaResults(bool storeData=false);
	int stovkaResults(bool storeData=false);
	int results(bool storeData=false);

	//id of player, who's turn it is now. Id is to list of players Game instance stores.
	int id;
	//id of player who played first this round
	int vysid;
	//id of forhont
	int forhont;
	/**
	  *round id: (round=kolo)
	  *-6: intro
	  *-5: from new game to start 1. round of card dealing
	  *-4:during 1.round of card dealing, waiting to select the tromf
	  *-3:tromf is already selected, during 2.round of card dealing to start of fixing hand
	  *-2:hand is fixed, waiting to select the talon
	  *-1:during animation of second card to talon, during bidding, until end of bidding
	  *0..9:game rounds (new round is at selecting third card)
	  *10:results
	  *
	  */
	int kolo; //hra je 0 az 9, 10 je koniec, -1 je talon, -2 je volba tromfa
	Hra hra;

	//kopa has 0-2 cards
	QList<int> kopa;
	//cHist contains card history. Kopa is suffix of cHist.
	QList<int> cHist;
	//pHist[i] is player that won i-th stich
	QList<int> pHist;
	//results
	typedef QTriple<QString,QString,bool> ResRow;
	QList<ResRow> res;
};

#endif // STAV_H
