#include <LEDA/graph/graph_alg.h>
#include <LEDA/graph.h>
#include <LEDA/array2.h>
#include <LEDA/array.h>
#include <LEDA/geo/polygon.h>

using namespace leda;

float PI = 3.14159; 
float ODCHYLKA = 0.002;   //odchylka pri geometrickom ratani ci bod patri usecke
float ODCHYLKA2 = 0.002;  //odchylka pri ratani ci 2 priesecniky su totozne

int POC_RANDOM = 5;  //nie je implementovane !!!!
int MAX_POKUSOV = 30; // maximalny  pocet pokusov na zistovanie umiestnenia bodu vnutry vybretej oblasti        
int MAX_SKUSANIA = 20;//maximalny pocet pokusov ci je bod dnu polygonu
int MAX_POCET_SUSEDOV = 2;   //pocet susedov pri lucovej heuristike ktorych kontroluje   // maxim je 3,opt pre rychlost 2
int MAX_ROVNAKYCH = 10;  //konstanta r, pocet oblasti v ktorych skusam :) ked maju rovnaku metriku 


int HRANA_1=3;
int HRANA_2=2;
int HRANA_3=1;


void RANDOM(graph& G,node_array<double>& xpos,node_array<double>& ypos,double xleft, double xright,double ybottom, 
	    double ytop)
// zlozitost O(V)
{
  node v;
  v=G.first_node();
  while (v!=nil)
  {
    xpos[v]=(double(rand()%(int(xright-xleft)*100))/100+xleft);
    ypos[v]=(double(rand()%(int(ytop-ybottom)*100))/100+ybottom); 
  
    v=G.succ_node(v);
  }
}

void CIRCLE(graph& G,node_array<double>& xpos,node_array<double>& ypos,node_array<int>& typ,
            double xleft, double xright,double ybottom,double ytop,int metoda)
// zlozitost O(V)
{
  float stred_x,stred_y,polomer;
  float uhol,uhol2=0;
  
  stred_x=(xleft+xright)/2;
  stred_y=(ybottom+ytop)/2;
  
  polomer=(xright-xleft)/2-20;
  if ((ytop-ybottom)/2-20<polomer) polomer=(ytop-ybottom)/2-20;
  
  uhol=2*PI/G.number_of_nodes();
//  printf("%f\n",polomer);

  node v;

  if (metoda==0)
  {
    v=G.first_node();
    while (v!=nil)
    {
      xpos[v]=polomer*sin(uhol2)+stred_x;
      ypos[v]=polomer*cos(uhol2)+stred_y;          
      uhol2=uhol2+uhol;
      v=G.succ_node(v);
    }    
  }

  if (metoda==1)
  {
    v=G.first_node();
    while (v!=nil)
    {
      if (typ[v]==1) 
      {
        xpos[v]=polomer*sin(uhol2)+stred_x;
        ypos[v]=polomer*cos(uhol2)+stred_y;          
        uhol2=uhol2+uhol;
      }	
      v=G.succ_node(v);
    }    
    v=G.first_node();
    while (v!=nil)
    {
      if (typ[v]==2) 
      {
        xpos[v]=polomer*sin(uhol2)+stred_x;
        ypos[v]=polomer*cos(uhol2)+stred_y;          
        uhol2=uhol2+uhol;
      }	
      v=G.succ_node(v);
    }    
  }
  
  if (metoda==2)
  {
    int i=0;
    node_array<int> bol(G);
    while (i<G.number_of_nodes())
    {
      v=G.choose_node();
      if (bol[v]==0)
      {
        bol[v]=1;
	i++;
        xpos[v]=polomer*sin(uhol2)+stred_x;
        ypos[v]=polomer*cos(uhol2)+stred_y;          
        uhol2=uhol2+uhol;      
      }
    }
  }
  
}

void PLANAR_NAK(graph& G,node_array<double>& xpos,node_array<double>& ypos,node_array<int>& typ,
            double xleft, double xright,double ybottom,double ytop)
//zlozitost O(V*V) 
{
  node_array<int> planx(G);
  node_array<int> plany(G);

  graph G1;
  
  G1=G;
  
  G.make_directed();

  /*int max=*/STRAIGHT_LINE_EMBEDDING(G,planx,plany);
  
  G1.make_directed();

   node v;
   v=G.first_node();
   while (v!=nil)
   {
   /*
     xpos[v]=((xright-xleft-60)*planx[v]/max)+xleft+30;
     ypos[v]=((ytop-ybottom-60)*plany[v]/max)+ybottom+30;    
   */
     xpos[v]=planx[v]; ypos[v]=plany[v];
     v=G.succ_node(v);
   }
   
}


void NASKALUJ(graph &G,node_array<double>& xpos,node_array<double>& ypos,
            double xleft, double xright,double ybottom,double ytop)
{
   xleft+=30;
   xright-=20;
   ybottom+=20;
   ytop-=20;


   double maxx,maxy,minx,miny;

   node v;
   v=G.first_node();
   
   maxx=xpos[v];
   maxy=ypos[v];
   minx=xpos[v];
   miny=ypos[v];
   
   while (v!=nil)
   {
     if (xpos[v]>maxx) maxx=xpos[v]; 
     if (ypos[v]>maxy) maxy=ypos[v]; 
     if (xpos[v]<minx) minx=xpos[v]; 
     if (ypos[v]<miny) miny=ypos[v];    
     v=G.succ_node(v);
   }

   v=G.first_node();
   double nasx,nasy;
   
   if ((maxx-minx)!=0) nasx=(xright-xleft)/(maxx-minx); else nasx=1;
   if ((maxy-miny)!=0) nasy=(ytop-ybottom)/(maxy-miny); else nasy=1;
   
   while (v!=nil)
   {
     xpos[v]=(xpos[v]-minx)*nasx+15;
     ypos[v]=(ypos[v]-miny)*nasy;

     v=G.succ_node(v);
   }
}


node VYBER_VRCHOL(graph& G,list<node>& vrcholy, node_array<int>& typ,node_array<int>& deg_all,node_array<int>& deg_my,
     int priorita,int minimax)
{
  node max_v,min_v;
  int max1=-1,max2=-1,max3=-1,max4=-1;  
  int min1=1001,min2=MAXINT,min3=MAXINT,min4=MAXINT;  

  if (priorita==0) priorita=7;

  int ter1,ter2,ter3,ter4;
  
  int mer1=-1,mer2=-1,mer3=-1,mer4=-1;
  
  node v,v1,v2;
  edge e;
    list<edge> hrany;
  int i,hid;
  
  for (i=1;i<=vrcholy.size();i++)
  {
    v=vrcholy.contents(vrcholy.get_item(i-1));  
    hid=0;
    if (G.is_hidden(v)) 
    {
      hid=1;
      G.restore_node(v);    
      
      hrany=G.hidden_edges();
      while (hrany.size()>0)
      {
        e=hrany.pop();
	v1=G.source(e); v2=G.target(e);	
	if ((!G.is_hidden(v1))&&(!G.is_hidden(v2))) 
	{
	  G.restore_edge(e);       
	}
      }      
    }   
    ter3=G.degree(v);
    if (hid==1) G.hide_node(v); 

    ter1=(rand()%int(1000));
    ter2=deg_all[v];
    ter4=deg_my[v];
    
//    printf("%d %d %d %d\n",ter1,ter2,ter3,ter4);
    
    // teraz podla parametra musim vybrat ten spravny vrchol !!!
    if (priorita==1)
    {   mer1=ter2; mer2=ter3; mer3=ter4; mer4=ter1; }
    if (priorita==2)
    {   mer1=ter2; mer2=ter4; mer3=ter3; mer4=ter1; }
    if (priorita==3)
    {   mer1=ter3; mer2=ter2; mer3=ter4; mer4=ter1; }
    if (priorita==4)
    {   mer1=ter3; mer2=ter4; mer3=ter2; mer4=ter1; }
    if (priorita==5)
    {   mer1=ter4; mer2=ter2; mer3=ter3; mer4=ter1; }
    if (priorita==6)
    {   mer1=ter4; mer2=ter3; mer3=ter2; mer4=ter1; }
    if (priorita==7)
    {   mer1=ter1; mer2=ter2; mer3=ter3; mer4=ter4; }
    
    if ((mer1>max1)||((mer1==max1)&&(mer2>max2))||((mer1==max1)&&(mer2==max2)&&(mer3>max3))||
    ((mer1==max1)&&(mer2==max2)&&(mer3==max3)&&(mer4>max4)))
    {
      max1=mer1; max2=mer2; max3=mer3; max4=mer4;      
      max_v=v;
    }      
    
    if ((mer1<min1)||((mer1==min1)&&(mer2<min2))||((mer1==min1)&&(mer2==min2)&&(mer3<min3))||
    ((mer1==min1)&&(mer2==min2)&&(mer3==min3)&&(mer4<min4)))
    {
      min1=mer1; min2=mer2; min3=mer3; min4=mer4;      
      min_v=v;
    }      
  }
 
  if (minimax==2)
  {
//    printf("\n%d %d %d %d %d\n\n",priorita,max1,max2,max3,max4);
    vrcholy.remove(max_v);
    return(max_v);
  } else
  {
//    printf("\n%d %d %d %d %d\n\n",priorita,min1,min2,min3,min4);
    vrcholy.remove(min_v);
    return(min_v);      
  }
}



int crossing2(graph& G,node_array<double>& xpos,node_array<double>& ypos)
{
  int cross=0;
      
  int i=G.number_of_nodes();  
  if (i==0) return(0);
	       
  int i2,i3;
  i=0;i2=0;i3=0;
		             
  edge e1;
  node n1zac,n1kon;
  point p1zac,p1kon;
  list<segment> hrany;
  list<point> priesecniky;
  
  //prida tam vsetky hrany !!!
  hrany.clear();
  priesecniky.clear();  
  
  e1=G.first_edge();
  while(e1!=nil)
  {
      n1zac=G.source(e1); n1kon=G.target(e1);    
   
    if ((!G.is_hidden(n1zac))&&(!G.is_hidden(n1kon))) 
    {
      p1zac=point(xpos[n1zac],ypos[n1zac]);
      p1kon=point(xpos[n1kon],ypos[n1kon]);
      hrany.append(segment(p1zac,p1kon));              
    }  
    e1=G.succ_edge(e1);
  }
 						        
  SEGMENT_INTERSECTION(hrany,priesecniky);   //vypocita priesecniky !!!
							  
  priesecniky.merge_sort();
														  	      
  point priesecnik;
  cross=0;
			     
  while (priesecniky.length()>0) 
  {
    priesecnik=priesecniky.pop();
        
    e1=G.first_edge();
    while(e1!=nil)
    {
      n1zac=G.source(e1); n1kon=G.target(e1);    
      p1zac=point(xpos[n1zac],ypos[n1zac]);
      p1kon=point(xpos[n1kon],ypos[n1kon]);
    
      if (  (   (p1zac.xcoord()==priesecnik.xcoord()) &&  (p1zac.ycoord()==priesecnik.ycoord()) ) ||
         (  (p1kon.xcoord()==priesecnik.xcoord()) &&  (p1kon.ycoord()==priesecnik.ycoord()) ) )		   
	    { cross=cross;} else if (segment(p1zac,p1kon).distance(priesecnik)<=ODCHYLKA)  cross+=1;      																			          e1=G.succ_edge(e1);	
    }    
  }
  return(cross/2);							  
}

int cross_num(double pos_x,double pos_y,array<double> &xcoord,array<double> &ycoord,array<int> &susedia,
              list<segment> &hrany,array<int> &typ_hrany,array<int> &typ_suseda,int &moj_typ)
{
  int cross=0;

  list<point> priesecniky;
  priesecniky.clear();  
  point priesecnik;
  
  list<segment> suses;
  list<segment> vsetko;
  vsetko.clear(); suses.clear();

  int i,i2,i3;
  
  for (i=1;i<=hrany.size();i++) vsetko.append(hrany.contents(hrany.get_item(i-1)));    
  
  for (i=1;i<=susedia.size();i++)
  {
               vsetko.append(segment(point(xcoord[susedia[i]],ycoord[susedia[i]]),point(pos_x,pos_y)));    
	       suses.append(segment(point(xcoord[susedia[i]],ycoord[susedia[i]]),point(pos_x,pos_y)));      
  }
 
  SEGMENT_INTERSECTION(vsetko,priesecniky);   //vypocita priesecniky !!!
 
  segment pom1,pom2; 
 
//  printf("pries : %d hrany: %d sused : %d vsetky : %d\n",priesecniky.size(),hrany.size(),suses.size(),vsetko.size());
  while (priesecniky.length()>0) 
  {
    priesecnik=priesecniky.pop();
         
    //zistim ci je priesecnik jeden z vrcholov
    i2=0;
    for (i=1;i<=xcoord.size();i++)
      if (point(xcoord[i],ycoord[i]).distance(priesecnik)<=ODCHYLKA) i2=1;
    if (point(pos_x,pos_y).distance(priesecnik)<=ODCHYLKA) i2=1;
    
    if (i2==0)   //lezi na hrane !!!
    {
        for (i3=1;i3<=hrany.size();i3++) 
	{
   	  pom1=hrany.contents(hrany.get_item(i3-1));            
	  if (pom1.distance(priesecnik)<=ODCHYLKA) 
	  {cross+=typ_hrany[i3];
//	  printf("kkk\n");
	  }
	}
	for (i3=1;i3<=suses.size();i3++)
	{
	  pom1=suses.contents(suses.get_item(i3-1));            
	  if (pom1.distance(priesecnik)<=ODCHYLKA)
	  {
	    if ((typ_suseda[i3]==1)&&(moj_typ==1)) cross+=HRANA_1;
	    if ((typ_suseda[i3]==2)&&(moj_typ==2)) cross+=HRANA_2;
	    if (typ_suseda[i3]!=moj_typ) cross+=HRANA_3;
	  
	  } 
	}
	
     // printf("xxx %f %f \n",priesecnik.xcoord(),priesecnik.ycoord());

    }
  } 

  return(cross);
}

point vrat_bod(polygon& P)
{
//  printf("dnu\n");
  float minx=0,miny=0,maxx=0,maxy=0;
  
  int i;
  
  list<point> body;
  
  body=P.vertices();
  
  if (body.size()<=2) return(body.contents(body.get_item(0)));
  
  for (i=1;i<=body.size();i++)
  {
    point pom=body.contents(body.get_item(i-1));
    
    if (i==1)
    {
      maxx=pom.xcoord();
      minx=pom.xcoord();
      maxy=pom.ycoord();
      miny=pom.ycoord();            
    }
   
    if (pom.xcoord()>maxx) maxx=pom.xcoord();
    if (pom.xcoord()<minx) minx=pom.xcoord();
    if (pom.ycoord()>maxy) maxy=pom.ycoord();
    if (pom.ycoord()<miny) miny=pom.ycoord();
  } 

  maxx+=0.02; maxy+=0.02;
  minx-=0.02; miny-=0.02; 
  
  point bod; i=0;
  
//  printf("%f %f\n",maxx-minx,maxy-miny);
  while ((i==0)||(!P.inside(bod)))
  {
//   printf("ah\n");
   
   float sk_x=float(rand()%(int((maxx-minx)*1000)))/1000+minx;
   float sk_y=float(rand()%(int((maxy-miny)*1000)))/1000+miny;
//    printf("ah3\n");
   
    point bod2(sk_x,sk_y); 
//    printf("ah2\n");
    bod=bod2; i++;
    if (i==1000) break;
  }
  
//  printf("dnu2\n");  
  return(bod);
}

float vzd_od_vrchol(double pos_x,double pos_y,array<double> &xcoord,array<double> &ycoord)
{
  float dist,minimum=10000;  
  int i;
  
  for (i=1;i<=xcoord.size();i++)
  { 
    point bod1(pos_x,pos_y);
    point bod2(xcoord[i],ycoord[i]);    
    dist=bod1.distance(bod2);
    
    if ((dist<minimum)||(i==1))minimum=dist;  
  }
  
//  printf("%f \n",minimum);
  return(minimum);
}

int WEAKLY_SIMPLE(list<point>& body)
{
  list <segment> hrany;
  int i;
  
  point zac,bod,bod2;
  for (i=0;i<body.size();i++)
  {
    if (i==0)
    {
      bod=body.contents(body.get_item(i));
      zac=bod;        
    } else
    {
      bod2=bod;
      bod=body.contents(body.get_item(i));
      hrany.push(segment(bod2,bod));    
    }            
  }
  hrany.push(segment(bod,zac));    
 
  list<point> prie;
  SEGMENT_INTERSECTION(hrany,prie);
 
  return(prie.size());
}


void HEURISTIKA_1(graph &G,list<node> fixed,node& vrch,node_array<double>& xpos,node_array<double>& ypos,
            double xleft, double xright,double ybottom,double ytop,double &pos_x,double &pos_y,node_array<int>& typ)
{

//  printf("vosiel \n");
  pos_x=50;
  pos_y=50;
  
 // skopcim graf do tychto poli 
 
  array<double> xcoord;    //x-ove surednice vrcholov
  array<double> ycoord;   // y-nove suradnice vrcholov
  array<int>typ_vrchola;
  array<int>typ_hrany;
  int pocet_vrcholov=0;  // pocet vrcholov
  int pocet_hran=0;     //pocet hran
  int pocet_susedov=0;   //pocet susedov doplnovaneho vrchola
  array<int> susedia;   //susedia doplnovaneho vrchola
  array<int> typ_suseda; //jeho typ

  int i=0,i2=0,i3=0;
  node v,v1;

  i=0;
  v=G.first_node();
  while(v!=nil)
  {
    i++; 
    //tu pridam vrchol
    i3=xcoord.size();
    xcoord.resize(1,i3+1);
    ycoord.resize(1,i3+1);    
    typ_vrchola.resize(1,i3+1);
    xcoord[i3+1]=xpos[v];          
    ycoord[i3+1]=ypos[v]; 
    typ_vrchola[i3+1]=typ[v];                     
    
    v=G.succ_node(v);
  }
  pocet_vrcholov=i;
  

  //zistim susedov
  edge e1;
  node n1zac,n1kon;
  point p1zac,p1kon;
  list<edge> skryte;
  skryte=G.hidden_edges();

  while (skryte.size()>0)
  {
    e1=skryte.pop();
    
      n1zac=G.source(e1); n1kon=G.target(e1);    
      p1zac=point(xpos[n1zac],ypos[n1zac]);
      p1kon=point(xpos[n1kon],ypos[n1kon]);
      i2=0;
    
    if ((n1zac==vrch)&&(!G.is_hidden(n1kon))) 
    {
       pocet_susedov++;            
       for (i=1;i<=pocet_vrcholov;i++) if ((xcoord[i]==p1kon.xcoord())&&(ycoord[i]==p1kon.ycoord()))
       {
         i2=i;
       }       
    }
    if ((n1kon==vrch)&&(!G.is_hidden(n1zac)))
    {
      pocet_susedov++;                
       for (i=1;i<=pocet_vrcholov;i++) if ((xcoord[i]==p1zac.xcoord())&&(ycoord[i]==p1zac.ycoord()))
       {
         i2=i;
       }       
    }
    if (i2>0)
    {
      i3=susedia.size();
      susedia.resize(1,i3+1);
      susedia[i3+1]=i2;    
      typ_suseda.resize(1,i3+1);
      typ_suseda[i3+1]=typ_vrchola[i2];
    }    
  }
  
//  printf("pocet susedov : %d \n",pocet_susedov);
 // for (i=1;i<=pocet_susedov;i++) printf("sus %d %d ",i,susedia[i]);
  //koniec zistovania susedov

  //najprv ho splanarnim !!!
  
  // vypocitam priesecniky -> 
		             
  list<segment> hrany;
  list<point> priesecniky;
  list<point> priesec;
  
  //prida tam vsetky hrany !!!
  hrany.clear();
  priesecniky.clear(); priesec.clear();  

  e1=G.first_edge();
  while(e1!=nil)
  {
    n1zac=G.source(e1); n1kon=G.target(e1);       
    if ((fixed.rank(n1zac)!=0)&&(fixed.rank(n1kon)!=0))
    {    
      p1zac=point(xpos[n1zac],ypos[n1zac]);
      p1kon=point(xpos[n1kon],ypos[n1kon]);
      hrany.append(segment(p1zac,p1kon));              
    }
    e1=G.succ_edge(e1);
  }

//  printf("ratam1\n"); 						        
  SEGMENT_INTERSECTION(hrany,priesecniky);   //vypocita priesecniky !!!
//  printf("ratam2\n"); 						        
							  														  	      
  point priesecnik;  
  list<edge> hrany_pries;
   
  hrany_pries.clear();
  while (priesecniky.length()>0) 
  {
    priesecnik=priesecniky.pop();
            
    e1=G.first_edge();
    while(e1!=nil)
    {
      n1zac=G.source(e1); n1kon=G.target(e1);    
      p1zac=point(xpos[n1zac],ypos[n1zac]);
      p1kon=point(xpos[n1kon],ypos[n1kon]);
    
      if (  (   (p1zac.xcoord()==priesecnik.xcoord()) &&  (p1zac.ycoord()==priesecnik.ycoord()) ) ||
         (  (p1kon.xcoord()==priesecnik.xcoord()) &&  (p1kon.ycoord()==priesecnik.ycoord()) ) )		   
	    {  } else if (segment(p1zac,p1kon).distance(priesecnik)<=ODCHYLKA)
	    {  
	      hrany_pries.push(e1);      																			          
	      priesec.push(priesecnik);	    
	    }
      e1=G.succ_edge(e1);	
    }    

  }
    
  
  i=(pocet_vrcholov+1)+(hrany_pries.size()/2)+8;
//  printf("i-cko %d \n",i);
  bool hrana[i][i];
//  printf("dodeklarovane 1\n");
  
//  int hrana2[i][i];
//  printf("dodeklarovane 2\n");
  
  int vzd[pocet_susedov+1][i];  // ci je hrana medzi vrcholmi
//  printf("dodeklarovane 3\n");
    
  for (i2=1;i2<i;i2++) for (i3=1;i3<i;i3++) hrana[i2][i3]=0;
  for (i2=1;i2<=pocet_susedov;i2++) for (i3=1;i3<i;i3++) vzd[i2][i3]=MAXINT;
    
  
  list<node> pomoc;
  v=G.first_node();
  i=0;
  while(v!=nil)
  {
    i++; 
    i2=0;    
    v1=G.first_node();
    while(v1!=nil)
    {   
      i2++;
     // if ((i<i2))  //tu pridam hranu
      {
        pomoc=G.adj_nodes(v); //if(i==1) printf("bbb %d \n",pomoc.size());
        if (pomoc.rank(v1)>0)
	{
	  hrana[i][i2]=1;
	  hrana[i2][i]=1;		
	  pocet_hran++;	
	}
      }            
      v1=G.succ_node(v1);
    }
    v=G.succ_node(v);
  }                

//  printf("blikam\n");
 
  list<segment> hranas;
  hranas.clear();
  i3=0;

  for (i=1;i<=pocet_vrcholov;i++) for (i2=1;i2<=pocet_vrcholov;i2++) if ((i<i2)&&(hrana[i][i2]==1))
  {
    i3++;
    typ_hrany.resize(1,i3);
    if ((typ_vrchola[i]==1)&&(typ_vrchola[i2]==1)) typ_hrany[i3]=HRANA_1;
    if ((typ_vrchola[i]==2)&&(typ_vrchola[i2]==2)) typ_hrany[i3]=HRANA_2;
    if ((typ_vrchola[i]!=typ_vrchola[i2])) typ_hrany[i3]=HRANA_3;
    hranas.append(segment(point(xcoord[i],ycoord[i]),point(xcoord[i2],ycoord[i2])));   
  }
  
  i3=0;
  int i4=0,i5=0;
  
  list<point> priesec2;
  priesec2=priesec;    
  i5=pocet_vrcholov;
  
//  printf("nove1\n");
  
  while (hrany_pries.size()>0)   //pridam nove vrcholy 
  {
    i3++;
    e1=hrany_pries.pop();    
    point bod;
    bod=priesec.pop();
    if (i3 % 2 ==1)    //novy vrchol
    {
      pocet_vrcholov++;
      i2=xcoord.size();
      xcoord.resize(1,i2+1);
      ycoord.resize(1,i2+1);     
      xcoord[i2+1]=bod.xcoord();
      ycoord[i2+1]=bod.ycoord();    
    }    
  } 


  //obmenim hrany -> pre kazdy presecnik pozrem hrany ktore tam lezia
  i3=0;
  point pom_pr;
  
//  printf("nove2\n");
  priesec2.unique();
  
  while (priesec2.size()>0)
  {
    i3++;
    i4=0;
    priesecnik=priesec2.pop();
    
    for (i=1;i<=pocet_vrcholov;i++) for (i2=i+1;i2<=pocet_vrcholov;i2++) if (hrana[i][i2]==1)
    {
    
      if (((xcoord[i]==priesecnik.xcoord()) &&  (ycoord[i]==priesecnik.ycoord()) ) ||
         (  (xcoord[i2]==priesecnik.xcoord()) &&  (ycoord[i2]==priesecnik.ycoord()) ) )		   
	    {  } else if (segment(point(xcoord[i],ycoord[i]),point(xcoord[i2],ycoord[i2])).distance(priesecnik)<=ODCHYLKA)
	    
	{   //priesecnik tam lezi
	  hrana[i][i2]=0;
	  hrana[i2][i]=0;   //zrusi staru
	
	  hrana[i][i5+i3]=1;
	  hrana[i2][i5+i3]=1;
	  hrana[i5+i3][i]=1;
	  hrana[i5+i3][i2]=1;	  			
	}               
    }
  
  }
  
  //tu pridam 4 fiktivne vrcholy...
//  printf("nove3\n");

  int hr_vl=1,hr_pr=1,hr_hor=1,hr_dol=1;
  float max_hor,max_dol,max_vl,max_pr;
  max_hor=ybottom;max_dol=ytop,max_vl=xright,max_pr=xleft;
//  printf("nove4 %d\n",pocet_vrcholov);

  for (i=1;i<=pocet_vrcholov;i++)
  {
    if (xcoord[i]>max_pr)
    {
      max_pr=xcoord[i];
      hr_pr=i;
    }
    if (xcoord[i]<max_vl)
    {
      max_vl=xcoord[i];
      hr_vl=i;
    }
    if (ycoord[i]<max_dol)
    {
      max_dol=ycoord[i];
      hr_dol=i;
    }
    if (ycoord[i]>max_hor)
    {
      max_hor=ycoord[i];
      hr_hor=i;
    }    
  }

//  printf("hor %d dol %d lef %d rig %d \n",hr_hor,hr_dol,hr_vl,hr_pr);

//  printf("nove6\n");

  pocet_vrcholov+=4;
  i3=xcoord.size();
  xcoord.resize(1,i3+4);
  ycoord.resize(1,i3+4);
  xcoord[i3+1]=xleft;          
  ycoord[i3+1]=ytop;                      
  xcoord[i3+2]=xleft;          
  ycoord[i3+2]=ybottom;                      
  xcoord[i3+3]=xright;          
  ycoord[i3+3]=ybottom;                      
  xcoord[i3+4]=xright;          
  ycoord[i3+4]=ytop;          
  hrana[i3+1][i3+2]=1;  hrana[i3+2][i3+1]=1;
  hrana[i3+2][i3+3]=1;  hrana[i3+3][i3+2]=1;
  hrana[i3+3][i3+4]=1;  hrana[i3+4][i3+3]=1;
  hrana[i3+4][i3+1]=1;  hrana[i3+1][i3+4]=1;                
  
  hrana[i3+1][hr_hor]=1; hrana[hr_hor][i3+1]=1; hrana[i3+1][hr_vl]=1; hrana[hr_vl][i3+1]=1;
  hrana[i3+2][hr_dol]=1; hrana[hr_dol][i3+2]=1; hrana[i3+2][hr_vl]=1; hrana[hr_vl][i3+2]=1;
  hrana[i3+3][hr_dol]=1; hrana[hr_dol][i3+3]=1; hrana[i3+3][hr_pr]=1; hrana[hr_pr][i3+3]=1;
  hrana[i3+4][hr_hor]=1; hrana[hr_hor][i3+4]=1; hrana[i3+4][hr_pr]=1; hrana[hr_pr][i3+4]=1;

//  printf("nove7\n");

  
  //koniec fiktivnych vrcholov

  //kontrola spravnosti vrcholov a hran
/*
  printf("Pocet vrcholov : %d \n",pocet_vrcholov);
  for (i=1;i<=pocet_vrcholov;i++)
  {  
    printf("vrch %d : %f %f \n",i,xcoord[i],ycoord[i]);    
  }
  
  printf("Pocet hran : %d \n",pocet_hran);  
  i3=0;
  for (i=1;i<=pocet_vrcholov;i++)
    for (i2=i+1;i2<=pocet_vrcholov;i2++)
      if (hrana[i][i2]==1)
      {
        i3++;
        printf("hrana %d spaja %d %d \n",i3,i,i2);
      }
*/
  //tu vypocitam vzdialenosti medzi vrcholmi   

/*     floyd warshal - O(n^12)
  for (i=1;i<=pocet_vrcholov;i++)
    for (i2=1;i2<=pocet_vrcholov;i2++) if (hrana[i][i2]==1) vzd[i][i2]=1; else if (i==i2) vzd[i][i2]=0; 
       else vzd[i][i2]=MAXINT/3;
  
  for (i=1;i<=pocet_vrcholov;i++)
    for (i2=1;i2<=pocet_vrcholov;i2++)
      for (i3=1;i3<=pocet_vrcholov;i3++)
        if (vzd[i2][i3]>vzd[i2][i]+vzd[i][i3])
	{
	  vzd[i2][i3]=vzd[i2][i]+vzd[i][i3];
	  vzd[i3][i2]=vzd[i2][i3];	
	}
  printf("vzdial \n");
  
  for (i=1;i<=pocet_vrcholov;i++)
  { 
    for (i2=1;i2<=pocet_vrcholov;i2++)
    printf("%d %d %d   ",i,i2,vzd[i][i2]);
    printf("\n");
  
  }
  printf("end vzd\n");
*/
//vypocitam to iste dijkstrom   O(n^9)

  for (i=1;i<=pocet_susedov;i++)
  {
    i3=susedia[i];
    for (i2=1;i2<=pocet_vrcholov;i2++) if (hrana[i3][i2]==1) vzd[i][i2]=1; else if (i3==i2) vzd[i][i2]=0; 
       else vzd[i][i2]=MAXINT/3;
  }

//  printf("nove8\n");

     
  list<int> spravene;
  for (i=1;i<=pocet_susedov;i++)
  {
//    printf("%d %d\n",i,pocet_susedov);
    i3=susedia[i];
    spravene.clear();
    spravene.push(i3);
    while (spravene.size()<pocet_vrcholov)
    {
      int minim=MAXINT/2,kt=0;
      for (i2=1;i2<=pocet_vrcholov;i2++) if ((vzd[i][i2]<minim)&&(spravene.search(i2)==nil))
      {
        kt=i2;
	minim=vzd[i][i2];            
      }
      
      spravene.push(kt);
      
      for (i2=1;i2<=pocet_vrcholov;i2++) if ((spravene.search(i2)==nil)&&(hrana[kt][i2]==1))
      {
        if (vzd[i][i2]>vzd[i][kt]+1)  vzd[i][i2]=vzd[i][kt]+1;                  
      }  
    }
  }       
  
//  printf("nove9\n");
  
/*
  for (i=1;i<=pocet_vrcholov;i++)
  { 
    for (i2=1;i2<=pocet_vrcholov;i2++)
    printf("%d %d %d   ",i,i2,vzd[i][i2]);    
    printf("\n");  
  }
  printf("end vzd\n");
*/                
  
  //koniec tu vypocitam vzdialenosti medzi vrcholmi   

  //teraz mam graf splanarneny, treba vypocitat FACES
  

  
//  for (i2=1;i2<=pocet_vrcholov;i2++) for (i3=1;i3<=pocet_vrcholov;i3++) hrana2[i2][i3]=hrana[i2][i3];


//  printf("ucha\n");
  
  int zmena=1;
  while (zmena==1)   //odstranim ucha
  {
    zmena=0;
    for (i2=1;i2<=pocet_vrcholov;i2++) 
    {
      int poc_sus=0,sused=0;        
      for (i3=1;i3<=pocet_vrcholov;i3++) if (hrana[i2][i3]==1)
      {
        poc_sus++;
	sused=i3;  
      }
      if (poc_sus==1)
      {
//        printf("blak");
        zmena=1;
        hrana[i2][sused]=0;
        hrana[sused][i2]=0;    
      }   
    }
  }        
  
  segment ratam,ratam2;
  int pocet_faces=0;
  array<polygon> faces;
  polygon face;
  list<point> body_face;
  list<int> body_facu;
  
  array<int> vzdialenosti;

  body_face.clear();
  body_facu.clear();

//  int i6,i7;
    
//  for (i6=1;i6<=pocet_vrcholov;i6++) for (i7=1;i7<=pocet_vrcholov;i7++) hrana3[i6][i7]=hrana2[i6][i7];
  
  int min_vzdialenost=MAXINT;
  int min_vzdial=MAXINT;

//  printf("blik\n");
//  printf("skuska \n ");


  int min_v_pos=0;

  i=0;
  while (i<pocet_vrcholov)
  {
  i2=0; i++;
  while (i2<pocet_vrcholov)
  {
  i2++;
  while (hrana[i][i2]==1)    //nasiel som hranu
  {
//    printf("%d pocet vrch \n",pocet_vrcholov);
//    printf("next face %d %d %d\n ",i,i2,hrana[i][i2]);
    body_facu.clear();
    body_face.clear();
    int min_v=i2,zac_v=i;
    while (min_v>-1)
    {

      ratam=segment(xcoord[zac_v],ycoord[zac_v],xcoord[min_v],ycoord[min_v]);
      body_facu.push(zac_v);
      body_face.push(point(xcoord[zac_v],ycoord[zac_v]));
      
      zac_v=min_v;  min_v_pos=min_v;
      float uhol,min_uhol=3*PI;
      segment min_segment;
      
      if (body_facu.rank(min_v)>0)
      {
	 body_facu.push(min_v);
         body_face.push(point(xcoord[min_v],ycoord[min_v]));
         min_v=-1;
      } else      
      {
        min_v=-2;
        for (i3=1;i3<=pocet_vrcholov;i3++) if ((hrana[zac_v][i3]==1))
        {
          ratam2=segment(xcoord[i3],ycoord[i3],xcoord[zac_v],ycoord[zac_v]);
  	  uhol=ratam.angle(ratam2); if (uhol<=ODCHYLKA2) uhol+=2*PI;
          if (uhol<min_uhol)
  	  {
	    min_v=i3;
	    min_uhol=uhol;
	    min_segment=ratam2;		
	  }
        }
      }      
    }

//    printf("masiel %d %d %d\n",min_v,body_facu.size(),body_face.size());
    
    

    //teraz by som mal skonstruovat body facuuuuuu
    list<point> body_face22;
    list<int> body_facu22;
    int kkk1,kkk3;
    point kkk2,kkk4;
    
    if (min_v==-1)
    {
      kkk1=body_facu.Pop();
      kkk2=body_face.Pop();
      
      while (kkk1!=min_v_pos) 
        {  kkk1=body_facu.Pop(); kkk2=body_face.Pop();  
	}
    } else 
    {  kkk1=body_facu.Pop();   kkk2=body_face.Pop(); 
       body_face22.push(kkk2); body_facu22.push(kkk1);    
    }
    
    if ((body_face.size()==0)&&(min_v==-2)) 
    {  hrana[i][i2]=0; 
//       printf("nicim %d %d %d\n",i,i2,hrana[i][i2]); 
       
//       if (hrana[i][i2]==0) printf("okej\n"); else if (hrana[i][i2]==1) printf("chyba\n"); else printf("chyba 2\n");
    }

//    printf("%d velkost \n",body_face.size());

    while (body_face.size()>0)
    {
      kkk3=body_facu.Pop();
      kkk4=body_face.Pop();
      
      hrana[kkk1][kkk3]=0;
      kkk1=kkk3;
      
      body_face22.push(kkk4);    
      body_facu22.push(kkk3);        
    }
//  printf("%d velkost \n",body_face22.size());
         
//  printf("zredukoval\n ",i,i2);
    int chod_dalej=0;
    if (body_face22.size()<3) chod_dalej=1; else
    if (WEAKLY_SIMPLE(body_face22)!=body_face22.size()) chod_dalej=2;
//  printf("%d hran %d priesecnikov \n",body_face22.size(),WEAKLY_SIMPLE(body_face22));
    
    if ((chod_dalej==0)&&(Is_Simple_Polygon(body_face22)))
    {
//    printf("von2\n");
      pocet_faces++;      
    
      int vzdialenost=0,min_vzdial=MAXINT;
      for (i3=1;i3<=pocet_susedov;i3++)
      {
        min_vzdial=MAXINT;
        for (i4=1;i4<=body_facu22.size();i4++) 
        {
          i5=body_facu22.contents(body_facu22.get_item(i4-1));
          if (min_vzdial>(vzd[i3][i5]))
          {
            min_vzdial=vzd[i3][i5]; 
          }
        }
        vzdialenost+=min_vzdial;
        min_vzdial=MAXINT;
      }

      if (min_vzdialenost>=vzdialenost)
      {
        min_vzdialenost=vzdialenost;
        vzdialenosti.resize(1,pocet_faces);
        vzdialenosti[pocet_faces]=vzdialenost;
    
        i4=faces.size();
        faces.resize(1,i4+1);
    
        polygon P(body_face22,3);      
	if (P.inside(point(-1000,-1000))) P=P.complement();
        faces[i4+1]=P;
      } else 
      {  
        pocet_faces--;
      }
    } else ; //printf("von\n");         
  }                    
  }        
  }

//  printf("pocet faces : %d \n",pocet_faces);
//koniec pocitania faces 


//teraz najdem face(s) s minimalnou vzdialenostou

  min_vzdial=min_vzdialenost;//  for (i=1;i<=pocet_faces;i++) if (min_vzdial>vzdialenosti[i]) min_vzdial=vzdialenosti[i]; 
  
//  printf("min_vzd %d \n",min_vzdial);

//  printf("blik2\n");

  
  int min_cr_number=MAXINT;  
  int poc_pokusov=0;
  float skus_x,skus_y;
  float ako_daleko,max_vzd=0;  

//  printf("klik\n");
  int poc_rovnakych=0;  


  for (i=1;i<=pocet_faces;i++) if ((min_vzdial==vzdialenosti[i])&&(poc_rovnakych<MAX_ROVNAKYCH))
  {
    poc_rovnakych++;
    poc_pokusov=0;
//    printf("%d\n ",i);
    while (poc_pokusov<MAX_POKUSOV)
    {      
//      printf("dnu\n");
      point pomocny=vrat_bod(faces[i]);  //(skus_x,skus_y);             
//      printf("von\n");
      skus_x=pomocny.xcoord(); skus_y=pomocny.ycoord();
//      if (faces[i].inside(pomocny))
      {
        poc_pokusov++;
//	printf("kross\n");
	i3=cross_num(skus_x,skus_y,xcoord,ycoord,susedia,hranas,typ_hrany,typ_suseda,typ[vrch]);
	ako_daleko=vzd_od_vrchol(skus_x,skus_y,xcoord,ycoord);
//	printf("kross2\n");
//	printf("%f %f %d\n",skus_x,skus_y,i3);
	if ((i3<min_cr_number)||((i3==min_cr_number)&&(ako_daleko>max_vzd)))
	{
	  min_cr_number=i3; max_vzd=ako_daleko;
	  pos_x=skus_x; pos_y=skus_y;
	}            
      }
    }    
    if (poc_rovnakych==MAX_ROVNAKYCH) break;
  }        
//  printf("Finalne umiestnenie : %f %f\n",pos_x,pos_y);
}

int Prienik(polygon& P1,polygon& P2,polygon& Prien)
{
//  printf("vkladam \n");

  list<point> prienik;
  prienik.clear();
  array<point> body;
  int poc_bodov=0;
  int i,i2;

  list<point> body1;  body1=P1.vertices();
  list<point> body2;  body2=P2.vertices();
  
  list<segment> hrany1;  hrany1=P1.segments();
  list<segment> hrany2;  hrany2=P2.segments();

  while (body1.size()>0)
  {
    point sk=body1.pop();
    if (P2.inside(sk))
    {        
      poc_bodov++;
      body.resize(1,poc_bodov);
      body[poc_bodov]=sk;
    }          
  }  
  while (body2.size()>0)
  {
    point sk=body2.pop();
    if (P1.inside(sk))
    {        
      poc_bodov++;
      body.resize(1,poc_bodov);
      body[poc_bodov]=sk;
    }          
  }  
/*
  for (i=0;i<body.size();i++) 
  {
    point vypis=body[i+1];
    printf("%f %f  ,  ",vypis.xcoord(),vypis.ycoord());    
  }
  printf("\n");
  printf("kkk\n");
*/  
  segment hra1,hra2;
  
  for (i=0;i<hrany1.size();i++)
  {
    hra1=hrany1.contents(hrany1.get_item(i));
    for (i2=0;i2<hrany2.size();i2++)
    {
      hra2=hrany2.contents(hrany2.get_item(i2)); 
      point sk;
      if (hra1.intersection(hra2,sk))
      {
        if ((sk.xcoord()>=-10000)&&(sk.xcoord()<=10000)&&(sk.ycoord()>=-10000)&&(sk.ycoord()<=10000))
	{
          poc_bodov++;
          body.resize(1,poc_bodov);
          body[poc_bodov]=sk;            
	}  
      }        
    }    
  }

  //TERAZ MAM UZ ZOZNAM BODOV, KTORE TVORIA PRIENIK

  if (body.size()<3) return(body.size());
  
  float min=100000;
  int ktory=1;
  
  for (i=1;i<=poc_bodov;i++) if (body[i].ycoord()<min)
  {
    ktory=i;
    min=body[i].ycoord();
  }
  
  point sk=body[ktory];
  point pomm;
  
  pomm=body[1];
  body[1]=body[ktory];
  body[ktory]=pomm;
  
  for (i=2;i<=poc_bodov;i++) for (i2=i+1;i2<=poc_bodov;i2++) if (segment(body[1],body[i]).direction()>segment(body[1],body[i2]).direction())
  {
    pomm=body[i];
    body[i]=body[i2];
    body[i2]=pomm;      
  }

  for (i=1;i<=poc_bodov;i++)
    if ((i==1)|| (body[i].distance(body[i-1])>0.04))
    {
      if ((i>1)||(body[1].distance(body[poc_bodov]))>0.04) prienik.push(body[i]);    
    }  

//  printf("sss\n");

  // ODSTRANENE DUPLIKATY

  list<point> bodos;
  for (i=1;i<=poc_bodov;i++) bodos.push(body[i]);
  
//  prienik=CONVEX_HULL(bodos);

  int i3=0;
  while (i3==0)
  { 
    i3=1;
    for (i=0;i<prienik.size();i++) 
    {
      for (i2=i+1;i2<prienik.size();i2++)
      {
        point kl1=prienik.contents(prienik.get_item(i));
        point kl2=prienik.contents(prienik.get_item(i2));
        if (kl1.distance(kl2)<0.2) 
	{
	  prienik.del(prienik.get_item(i));
	  i3=0;
	} 
        if (i3==0) break;
      }
      if (i3==0) break;
    }
  }    
    
    
  if (prienik.size()<3) return(prienik.size());

/*
  for (i=0;i<prienik.size();i++) 
  {
    point vypis=prienik.contents(prienik.get_item(i));
    printf("%f %f  ,  ",vypis.xcoord(),vypis.ycoord());    
  }
  printf("\n");
*/
//  printf("konstruujem....\n");
//  printf("ccc\n");

  if (WEAKLY_SIMPLE(prienik)!=prienik.size()) return(2);
  if (!Is_Simple_Polygon(prienik)) return(2);
  
  polygon ahoj(prienik);
  
//  printf("mam\n");
//  printf("bbb\n");

  if (ahoj.inside(point(-1000,-1000)))  ahoj=ahoj.complement();  
//  printf("aaa\n");
  Prien=ahoj;
//  printf("eee\n");
  
//  printf("finito\n");
  return(prienik.size());  
}

int Pretinaju(polygon P1,polygon P2)
{
  list<point> hrany_1=P1.vertices();
  list<point> hrany_2=P2.vertices();
  
  int poc_kr=0;
  
  point hrana;
  while (hrany_1.size()>0)
  {
    hrana=hrany_1.pop();    
    if (P2.inside(hrana)) poc_kr++;
  }
  if (poc_kr==0) return(0);
  
  poc_kr=0;
  while (hrany_2.size()>0)
  {
    hrana=hrany_2.pop();    
    if (P1.inside(hrana)) poc_kr++;
  }
  if (poc_kr==0) return(0);
  
  return(1);
}

void HEURISTIKA_2(graph &G,list<node>& fixed,node& vrch,node_array<double>& xpos,node_array<double>& ypos,
            double xleft, double xright,double ybottom,double ytop,double &pos_x,double &pos_y,node_array<int>& typ,
	    node_array<int>& deg_all,node_array<int>& deg_my)
{

  pos_x=50;
  pos_y=50;
  
 // skopcim graf do tychto poli 
 
  array<double> xcoord;    //x-ove surednice vrcholov
  array<double> ycoord;   // y-nove suradnice vrcholov
  array<int>typ_vrchola;
  array<int>typ_hrany;
  int pocet_vrcholov=0;  // pocet vrcholov
  int pocet_hran=0;     //pocet hran
  int pocet_susedov=0;   //pocet susedov doplnovaneho vrchola
  array<int> susedia;   //susedia doplnovaneho vrchola
  array<int> typ_suseda; //jeho typ

  list<node> vyber_suseda;  //susedia z ktorych bude vyberat ktorych zobrerie do uvahy
  vyber_suseda.clear();

  int i=0,i2=0,i3=0;
  node v,v1;

  i=0;
  v=G.first_node();
  while(v!=nil)
  {
    i++; 
    //tu pridam vrchol
    i3=xcoord.size();
    xcoord.resize(1,i3+1);
    ycoord.resize(1,i3+1);    
    typ_vrchola.resize(1,i3+1);
    xcoord[i3+1]=xpos[v];          
    ycoord[i3+1]=ypos[v]; 
    typ_vrchola[i3+1]=typ[v];                     
    
    v=G.succ_node(v);
  }
  pocet_vrcholov=i;
  
  //zistim susedov
  edge e1;
  node n1zac,n1kon;
  point p1zac,p1kon;
  list<edge> skryte;
  skryte=G.hidden_edges();

  while (skryte.size()>0)
  {
    e1=skryte.pop();
    
      n1zac=G.source(e1); n1kon=G.target(e1);    
      p1zac=point(xpos[n1zac],ypos[n1zac]);
      p1kon=point(xpos[n1kon],ypos[n1kon]);
      i2=0;
    
    if ((n1zac==vrch)&&(!G.is_hidden(n1kon))) 
    {
       pocet_susedov++;            
       for (i=1;i<=pocet_vrcholov;i++) if ((xcoord[i]==p1kon.xcoord())&&(ycoord[i]==p1kon.ycoord()))
       {
         i2=i;
	 vyber_suseda.push(n1kon);
       }       
    }
    if ((n1kon==vrch)&&(!G.is_hidden(n1zac)))
    {
      pocet_susedov++;                
       for (i=1;i<=pocet_vrcholov;i++) if ((xcoord[i]==p1zac.xcoord())&&(ycoord[i]==p1zac.ycoord()))
       {
         i2=i;
	 vyber_suseda.push(n1zac);
       }       
    }
    if (i2>0)
    {
      i3=susedia.size();
      susedia.resize(1,i3+1);
      susedia[i3+1]=i2;    
      typ_suseda.resize(1,i3+1);
      typ_suseda[i3+1]=typ_vrchola[i2];
    }    
  }
  
//  printf("pocet susedov : %d \n",pocet_susedov);
 // for (i=1;i<=pocet_susedov;i++) printf("sus %d %d ",i,susedia[i]);
  //koniec zistovania susedov

  i=(pocet_vrcholov+1);
  int hrana[i][i];  // ci je hrana medzi vrcholmi
    
  for (i2=1;i2<i;i2++) for (i3=1;i3<i;i3++) hrana[i2][i3]=0; 
    
 // zistovanie hran v grafe
  list<node> pomoc;
  v=G.first_node();
  i=0;
  while(v!=nil)
  {
    i++; 
    i2=0;    
    v1=G.first_node();
    while(v1!=nil)
    {   
      i2++;
     // if ((i<i2))  //tu pridam hranu
      {
        pomoc=G.adj_nodes(v); //if(i==1) printf("bbb %d \n",pomoc.size());
        if (pomoc.rank(v1)>0)
	{
	  hrana[i][i2]=1;
	  hrana[i2][i]=1;			  
	  pocet_hran++;	
	}
      }            
      v1=G.succ_node(v1);
    }
    v=G.succ_node(v);
  }                


  list<segment> hranas;
  list<segment> vsetko;
  list<segment> vsetko1;
  list<segment> vsetko2;
  hranas.clear();
  list<int> typ_hranas;
  
  i3=0;
  for (i=1;i<=pocet_vrcholov;i++) for (i2=1;i2<=pocet_vrcholov;i2++) if ((i<i2)&&(hrana[i][i2]==1))
  {
    i3++;
    typ_hrany.resize(1,i3);
    if ((typ_vrchola[i]==1)&&(typ_vrchola[i2]==1)) typ_hrany[i3]=HRANA_1;
    if ((typ_vrchola[i]==2)&&(typ_vrchola[i2]==2)) typ_hrany[i3]=HRANA_2;
    if ((typ_vrchola[i]!=typ_vrchola[i2])) typ_hrany[i3]=HRANA_3;
    hranas.append(segment(point(xcoord[i],ycoord[i]),point(xcoord[i2],ycoord[i2])));   
    
  }
  
  //kontrola spravnosti vrcholov a hran
/*
  printf("Pocet vrcholov : %d \n",pocet_vrcholov);
  for (i=1;i<=pocet_vrcholov;i++)
  {  
    printf("vrch %d : %f %f \n",i,xcoord[i],ycoord[i]);    
  }
  
  printf("Pocet hran : %d \n",pocet_hran);  
  i3=0;
  for (i=1;i<=pocet_vrcholov;i++)
    for (i2=i+1;i2<=pocet_vrcholov;i2++)
      if (hrana[i][i2]==1)
      {
        i3++;
        printf("hrana %d spaja %d %d \n",i3,i,i2);
      }
*/
// zaciatok implementovania heu 2

//pocet_ktorych uvazujem

  int i4;

//tu budu ulozene jednotlive polygony a ich cisla !!!
 array<polygon> faces1;
 array<polygon> faces2; 
 array<polygon> faces3; 
 array<int> kriz_1;   //krizove cisla k polygonom
 array<int> kriz_2;   //krizove cisla k polygonom
 array<int> kriz_3;   //krizove cisla k polygonom 

 //najprv vyberiem suseda 1

int pocet_ktorych_uvazujem=MAX_POCET_SUSEDOV;
int ktory_teraz=0;

 
while (pocet_ktorych_uvazujem>ktory_teraz)
{
 ktory_teraz++;
 int sused;  
 
 segment hranic1(point(xleft,ytop),point(xleft,ybottom));
 segment hranic2(point(xleft,ybottom),point(xright,ybottom));
 segment hranic3(point(xright,ybottom),point(xright,ytop));
 segment hranic4(point(xright,ytop),point(xleft,ytop)); 
 
 if (vyber_suseda.size()>0)
 {
   v1=VYBER_VRCHOL(G,vyber_suseda,typ,deg_all,deg_my,3,2);              //deg v celov , deg v nakreslenom
   sused=0;
//   printf("%f %f \n",xpos[v1],ypos[v1]);
   for (i=1;i<=pocet_vrcholov;i++) if ((xcoord[i]==xpos[v1])&&(ycoord[i]==ypos[v1])) sused=i;
   
//   printf("vyberam suseda %d ",sused);   
   
   //teraz spravim luce
   array<ray> luce;   
   point sused_p(xcoord[sused],ycoord[sused]);   
   for (i=1;i<=pocet_vrcholov;i++) if (i!=sused)
   {
     i2=luce.size();
     luce.resize(1,i2+1);     
     luce[i2+1]=ray(sused_p,point(xcoord[i],ycoord[i]));        
   }
   
//   printf("pocet lucov %d \n",luce.size());
   
   i3=1; 
   while (i3>=1)  //odstranim duplicitne luce
   {
     i3=0;
     for (i=1;i<=luce.size();i++) for (i2=1;i2<=luce.size();i2++) if ((i<i2)&&(luce[i].angle(luce[i2])==0)) i3=i2;
     
     if (i3>0) for (i=i3;i<luce.size();i++) luce[i]=luce[i+1];
     if (i3>0) luce.resize(1,luce.size()-1);           
   }

   int pocet_lucov=luce.size();
//   printf("pocet lucov %d \n",pocet_lucov);
                  
   //teraz pre kazdy luc urcim jeho luc vlavo 
   for (i=1;i<=pocet_lucov;i++) 
   {
     float uhol=2*PI;
     i3=0;
     for (i2=1;i2<=pocet_lucov;i2++) if ((i!=i2)&&(uhol>luce[i].angle(luce[i2])))
     {
       i3=i2;
       uhol=luce[i].angle(luce[i2]);     
     }
     i2=i3;
//     printf("luce %d %d %f\n",i,i2,uhol);   
     if (uhol<PI)  //mam dvojicu lucov -> i,i2  , musim najst ich dolezite body
     {                    
//       printf("blink2 \n");
       point von1(0,0),von2(0,0),von;
       
       if (!luce[i].intersection(hranic1,von1))  if (!luce[i].intersection(hranic2,von1)) 
           if (!luce[i].intersection(hranic3,von1)) (!luce[i].intersection(hranic4,von1)); 
       if (!luce[i2].intersection(hranic1,von2))  if (!luce[i2].intersection(hranic2,von2)) 
           if (!luce[i2].intersection(hranic3,von2)) (!luce[i2].intersection(hranic4,von2));        
	   
       segment luc1(sused_p,von1),luc2(sused_p,von2);
       
       if (sused_p.distance(von1)>sused_p.distance(von2)) 
       {
         von=von1;
         von2=von1.rotate(sused_p,uhol);
       } else 
       {       	 
         von1=von2.rotate(sused_p,-uhol);
         von=von1;
       }        
       
//       printf("pretinam : %f %f %f %f",von1.xcoord(),von1.ycoord(),von2.xcoord(),von2.ycoord());                           

       list<point> body_1;
       list<int> typ_body_1;
       list<point> body_2;
       list<int> typ_body_2;
       list<point> body_pom1;
       list<point> body_pom2;
       body_1.clear(); body_2.clear();
       array<int> typ_bodu;
       array<point> body;
       int pocet_bodov=0;
       point pompom1,pompom2;
      
       vsetko.clear();   	     
       vsetko1.clear();
       vsetko2.clear();
       for (i3=1;i3<=hranas.size();i3++) 
       {
          segment pod_pomoct=hranas.contents(hranas.get_item(i3-1));
	  
          if (luce[i].intersection(pod_pomoct,pompom1)) 
	    if (luce[i2].intersection(pod_pomoct,pompom2))
          {
//	    printf("spolocna : %f %f %f %f \n",pompom1.xcoord(),pompom1.ycoord(),pompom2.xcoord(),pompom2.ycoord());
	    
	    if (sused_p.distance(pompom1)<=sused_p.distance(pompom2))
	      {  body_1.push(pompom1); typ_body_1.push(typ_hrany[i3]); }    
	      else  { body_2.push(pompom2);  typ_body_2.push(typ_hrany[i3]); }
	  }
	  
       }
       
      // body_1.unique(); body_2.unique();
       i3=0;
       int i5;
       while (i3==0)
       {
         i3=1;
         point slama1,slama2;
         for (i4=0;i4<body_1.size();i4++)
	 {
	   slama1=body_1.contents(body_1.get_item(i4));
	   for (i5=i4+1;i5<body_1.size();i5++)
	   {
	     slama2=body_1.contents(body_1.get_item(i5));
	     if (slama1.distance(slama2)<ODCHYLKA)
	     {
	       i3=0;
	       body_1.del(body_1.get_item(i5));          
	       typ_body_1.del(typ_body_1.get_item(i5));
	     }
	     if (i3==0) break; 	     	     	   
	   }
	   if (i3==0) break; 	     	     	   	   	 
         }	 
       }
       while (i3==0)
       {
         i3=1;
         point slama1,slama2;
         for (i4=0;i4<body_2.size();i4++)
	 {
	   slama1=body_2.contents(body_2.get_item(i4));
	   for (i5=i4+1;i5<body_2.size();i5++)
	   {
	     slama2=body_2.contents(body_2.get_item(i5));
	     if (slama1.distance(slama2)<ODCHYLKA)
	     {
	       i3=0;
	       body_2.del(body_2.get_item(i5));          
	       typ_body_2.del(typ_body_2.get_item(i5));
	     }
	     if (i3==0) break; 	     	     	   
	   }
	   if (i3==0) break; 	     	     	   	   	 
         }	 
       }
       
//       printf("bnody1 : %d body2:  %d \n",body_1.size(),body_2.size());
 
       //teraz okresem body len na tie dolezite 
      
       point pom1,pom2;
       int kkk1=0,kkk2=0;
       
       while (body_1.size()>0) 
       {
         kkk2++;
         pom1=body_1.pop();
	 kkk1=typ_body_1.pop();
     	 if ((luc1.distance(pom1)) <ODCHYLKA) 
	 {
	   i4=0;
	   for (i3=1;i3<=body.size();i3++) if (pom1.distance(body[i3])<ODCHYLKA) i4=1;
	   if (i4==0)
	   {
   	     i3=body.size();
	     body.resize(1,i3+1);
	     body[i3+1]=pom1;	   
//	     printf("%f %f \n ",pom1.xcoord(),pom1.ycoord());
	     typ_bodu.resize(1,i3+1);
	     typ_bodu[i3+1]=kkk1;	 
	   }     
	 }                          
       }    
       kkk2=0;
//       printf("prestavka \n");                                    
       while (body_2.size()>0) 
       {
         kkk2++;
         pom2=body_2.pop();
	 kkk1=typ_body_2.pop();
     	 
	 if ((luc2.distance(pom2)) <ODCHYLKA) 
	 {
	   pom1=pom2.rotate(sused_p,-uhol);
	   i4=0;
	   for (i3=1;i3<=body.size();i3++) if (pom1.distance(body[i3])<ODCHYLKA) i4=1;
	   if (i4==0)
	   {
	     i3=body.size();
	     body.resize(1,i3+1);
//	     printf("%f %f \n ",pom1.xcoord(),pom1.ycoord());
	     body[i3+1]=pom1;
	     typ_bodu.resize(1,i3+1);
	     typ_bodu[i3+1]=kkk1;	 
	   }     
	 }                          
       }                                 
       
       i3=body.size();       
       body.resize(1,i3+1);
       body[i3+1]=von;       
       
       pocet_bodov=body.size();
       
       //usporiadam body podla vzdialenosti od sused_p
       for (i3=1;i3<=pocet_bodov;i3++) for (i4=i3+1;i4<=pocet_bodov;i4++) 
       if (sused_p.distance(body[i3])>sused_p.distance(body[i4]))
	  {
	    point vymen;
	    vymen=body[i3];
	    body[i3]=body[i4];
	    body[i4]=vymen;
	    
	    kkk1=typ_bodu[i3];
	    typ_bodu[i3]=typ_bodu[i4];
	    typ_bodu[i4]=kkk1;	  
	  }                     
       
//       printf("pocet bodov %d\n",pocet_bodov);
//       for (i3=1;i3<=pocet_bodov;i3++) printf("%f %f \n",body[i3].xcoord(),body[i3].ycoord());
       
       //body uz mam usporiadane !!!
       
       point zacc1,zacc2;
       int cccislo=0;
       for (i3=1;i3<pocet_bodov;i3++)
       {
         pom1=body[i3+1];
	 pom2=pom1.rotate(sused_p,uhol);
         
         zacc1=body[i3];
	 zacc2=zacc1.rotate(sused_p,uhol);
       
         list<point> pointy;
	 pointy.clear();
       
         if (i3==1)
	 {
	   pointy.push(sused_p);  
	   pointy.push(pom1);  
	   pointy.push(pom2);  
	   cccislo=0;
//           printf("polygon %d ",pointy.size());
//	   printf("%f %f    %f %f     %f %f",sused_p.xcoord(),sused_p.ycoord(),pom1.xcoord(),pom1.ycoord(),
//	     pom2.xcoord(),pom2.ycoord());
	 }  else
	 {
	              pointy.push(zacc1);
	   pointy.push(pom1);  
	   pointy.push(pom2);  
	   pointy.push(zacc2);	 	 
	   cccislo+=typ_bodu[i3];
//	   printf("polygon %d ",pointy.size());
//           printf("%f %f    %f %f     %f %f      %f %f",zacc1.xcoord(),zacc1.ycoord(),pom1.xcoord(),pom1.ycoord(),
//	     pom2.xcoord(),pom2.ycoord(),zacc2.xcoord(),zacc2.ycoord());
	 }
//	 printf("\n\n");
	 if (Is_Simple_Polygon(pointy))
	 {
	   pointy.reverse();
           polygon P(pointy);
	   if (P.inside(point(-1000,-1000))) P=P.complement();
	   
	   int i8;
	   if (ktory_teraz==1)    //facesx, kriz_x
	   {
	     i8=faces1.size();
	     faces1.resize(1,i8+1);
	     faces1[i8+1]=P;
	   
	     i8=kriz_1.size();
	     kriz_1.resize(1,i8+1);
	     kriz_1[i8+1]=cccislo;	 	 
	   }

	   if (ktory_teraz==2)    //facesx, kriz_x
	   {
	     i8=faces2.size();
	     faces2.resize(1,i8+1);
	     faces2[i8+1]=P;
	   
	     i8=kriz_2.size();
	     kriz_2.resize(1,i8+1);
	     kriz_2[i8+1]=cccislo;	 	 
	   }

	   if (ktory_teraz==3)    //facesx, kriz_x
	   {
	     i8=faces3.size();
	     faces3.resize(1,i8+1);
	     faces3[i8+1]=P;
	   
	     i8=kriz_3.size();
	     kriz_3.resize(1,i8+1);
	     kriz_3[i8+1]=cccislo;	 	 
	   }	               
	 }  
       }                            
     }  
   }         
 }
    
}

//uz mam polygony aspon troch susedov, teraz by som mal zistit ich prieniky
 
  pos_x=(double(rand()%(int(xright-xleft)*100))/100+xleft);
  pos_y=(double(rand()%(int(ytop-ybottom)*100))/100+ybottom); 

  polygon p;
  int vymena;
  
  //usporiadam ich podla krizoveho cisla
  for (i=1;i<=kriz_1.size();i++) for (i2=i+1;i2<=kriz_1.size();i2++) if (kriz_1[i]>kriz_1[i2])
  {
    vymena=kriz_1[i];
    kriz_1[i]=kriz_1[i2];
    kriz_1[i2]=vymena;    
    p=faces1[i];
    faces1[i]=faces1[i2];
    faces1[i2]=p;          
  }
/*  for (i=1;i<=kriz_1.size();i++) printf("%d ",kriz_1[i]);
  printf("\n");*/
  for (i=1;i<=kriz_2.size();i++) for (i2=i+1;i2<=kriz_2.size();i2++) if (kriz_2[i]>kriz_2[i2])
  {
    vymena=kriz_2[i];
    kriz_2[i]=kriz_2[i2];
    kriz_2[i2]=vymena;    
    p=faces2[i];
    faces2[i]=faces2[i2];
    faces2[i2]=p;          
  }

  for (i=1;i<=kriz_3.size();i++) for (i2=i+1;i2<=kriz_3.size();i2++) if (kriz_3[i]>kriz_3[i2])
  {
    vymena=kriz_3[i];
    kriz_3[i]=kriz_3[i2];
    kriz_3[i2]=vymena;    
    p=faces3[i];
    faces3[i]=faces3[i2];
    faces3[i2]=p;          
  }

  int min_cr_number=MAXINT;  
  int poc_pokusov=0;
  float skus_x,skus_y;
  float ako_daleko,max_vzd=0;  

  
  if (pocet_susedov>MAX_POCET_SUSEDOV) pocet_susedov=MAX_POCET_SUSEDOV; 

//  printf("som tu %d\n",pocet_susedov);

  int poc_skusania=0;

  if (pocet_susedov>=1)
  {
    for (i=1;i<=kriz_1.size();i++) if ((kriz_1[i]==0)&&(poc_skusania<MAX_ROVNAKYCH))
    {
      
      poc_skusania++;
      poc_pokusov=0;
      while (poc_pokusov<MAX_POKUSOV)
      {
         
        point pomocny=vrat_bod(faces1[i]);  //(skus_x,skus_y);             
        skus_x=pomocny.xcoord(); skus_y=pomocny.ycoord();

//        if (faces1[i].inside(pomocny))
        {
	  poc_pokusov++;
  	  i3=cross_num(skus_x,skus_y,xcoord,ycoord,susedia,hranas,typ_hrany,typ_suseda,typ[vrch]);
  	  ako_daleko=vzd_od_vrchol(skus_x,skus_y,xcoord,ycoord);
  //	  printf("%f %f %d\n",skus_x,skus_y,i3);
  	  if ((i3<min_cr_number)||((i3==min_cr_number)&&(ako_daleko>max_vzd)))
	  {
	    min_cr_number=i3; max_vzd=ako_daleko;
	    pos_x=skus_x; pos_y=skus_y; 
	  }            
        }                        
      }                
      
      if (poc_skusania==MAX_ROVNAKYCH) break;
    }  
  }

  poc_skusania=0;

  polygon pomocP;
 
  if (pocet_susedov>=2)
  {
    int min_sucet=MAXINT;
    i3=0;
    for (i=1;i<=faces1.size();i++) for (i2=1;i2<=faces2.size();i2++) 
     if ((Pretinaju(faces1[i],faces2[i2]))&& (Prienik(faces1[i],faces2[i2],pomocP)>2))
      if (kriz_1[i]+kriz_2[i2]<=min_sucet) 
      {  
        if (kriz_1[i]+kriz_2[i2]==min_sucet) i3++; else i3=1;
        min_sucet=kriz_1[i]+kriz_2[i2];      
      }
    
    for (i=1;i<=faces1.size();i++) for (i2=1;i2<=faces2.size();i2++) 
      if ((Pretinaju(faces1[i],faces2[i2]))&& (Prienik(faces1[i],faces2[i2],pomocP)>2))
      if ((kriz_1[i]+kriz_2[i2]==min_sucet)&&(poc_skusania<MAX_ROVNAKYCH))
      {
        poc_skusania++;
	poc_pokusov=0;
	//i3=0;
	
        while (poc_pokusov<MAX_POKUSOV)
        { 
	//  i3=4;
	//  if (i3>=MAX_SKUSANIA) break;
	
//	  printf("robim prienik \n");  
	//  i3= Prienik(faces1[i],faces2[i2],pomocP);	  
//	  printf("prienik hotovy %d\n",i3);  
	  
	  point pomocny;
	  pomocny=vrat_bod(pomocP);
           skus_x=pomocny.xcoord(); skus_y=pomocny.ycoord();  
	  
	/*    TOTO TREBA NAJST NAHRADU
          if (i3 % 2== 1) pomocny=vrat_bod(faces1[i]);  //(skus_x,skus_y);             
	    else pomocny=vrat_bod(faces2[i2]);
          skus_x=pomocny.xcoord(); skus_y=pomocny.ycoord();  
  		
         // if ( (faces1[i].inside(pomocny))&&(faces2[i2].inside(pomocny)))*/	  
          {
	  /*
	     if ( (faces1[i].inside(pomocny))&&(faces2[i2].inside(pomocny))) printf("OKEJ\n"); 
	         else printf("NIEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEeEEEEEEEEEEEEEEEEEEE\n");
*/
//            printf("uspech\n");
            poc_pokusov++;
    	    i3=cross_num(skus_x,skus_y,xcoord,ycoord,susedia,hranas,typ_hrany,typ_suseda,typ[vrch]);
  	    ako_daleko=vzd_od_vrchol(skus_x,skus_y,xcoord,ycoord);
  //	  printf("%f %f %d\n",skus_x,skus_y,i3);
  	    if ((i3<min_cr_number)||((i3==min_cr_number)&&(ako_daleko>max_vzd)))
	    {
	      min_cr_number=i3; max_vzd=ako_daleko;
	      pos_x=skus_x; pos_y=skus_y;
	    }            
          }
        }                      
	
	if (poc_skusania==MAX_ROVNAKYCH) break;
      }    
  }
  
  if (pocet_susedov>=3)
  {
    int min_sucet=MAXINT;
    
    for (i=1;i<=faces1.size();i++) for (i2=1;i2<=faces2.size();i2++) for (i3=1;i3<=faces3.size();i3++) 
      if ((Pretinaju(faces1[i],faces2[i2])) && (Pretinaju(faces1[i],faces3[i3])) && (Pretinaju(faces2[i2],faces3[i3])))
         if (min_sucet>kriz_1[i]+kriz_2[i2]+kriz_3[i3]) min_sucet=kriz_1[i]+kriz_2[i2]+kriz_3[i3];
        
    for (i=1;i<=faces1.size();i++) for (i2=1;i2<=faces2.size();i2++) for (i3=1;i3<=faces3.size();i3++) 
      if ((Pretinaju(faces1[i],faces2[i2])) && (Pretinaju(faces1[i],faces3[i3])) && (Pretinaju(faces2[i2],faces3[i3])))
    
      if (kriz_1[i]+kriz_2[i2]+kriz_3[i3]==min_sucet)
      {
	poc_pokusov=0;
        i4=0;
        while (poc_pokusov<MAX_POKUSOV/5)
        {
	  i4++;
	  if (i4>MAX_SKUSANIA/100) break;
          skus_x=(double(rand()%(int(xright-xleft)*100))/100+xleft);
          skus_y=(double(rand()%(int(ytop-ybottom)*100))/100+ybottom); 
          point pomocny(skus_x,skus_y);             
  		
          if ( (faces1[i].inside(pomocny))&&(faces2[i2].inside(pomocny))&&(faces3[i3].inside(pomocny)))
          {
            poc_pokusov++;
    	    i4=cross_num(skus_x,skus_y,xcoord,ycoord,susedia,hranas,typ_hrany,typ_suseda,typ[vrch]);
  	    ako_daleko=vzd_od_vrchol(skus_x,skus_y,xcoord,ycoord);
  //	  printf("%f %f %d\n",skus_x,skus_y,i3);
  	    if ((i4<min_cr_number)||((i4==min_cr_number)&&(ako_daleko>max_vzd)))
	    {
	      min_cr_number=i4; max_vzd=ako_daleko;
	      pos_x=skus_x; pos_y=skus_y;
	    }            
          }
        }
	                  
      }    
  }	
  
// koniec implementovania heu 2 
  
//printf("Finalne umiestnenie : %f %f\n",pos_x,pos_y);
}

void VYTVOR_DOKRESLOVANIM(graph& G,list<node>& fixed,list<node>& nonfixed,node_array<double>& xpos,node_array<double>& ypos,
  node_array<int>& typ,double xleft, double xright,double ybottom,double ytop,int param1,int param2,int param3,int param4,
  int param5,int param6, node_array<int> &cis)
{
  list<node> dokreslovane;
  dokreslovane.clear();

  list<edge> hrany;
  edge e;
  node u,v,v1,v2;
  
// stupne jednotlivych vrcholov !!!!

  node_array<int> deg_all(G);
  node_array<int> deg_my(G);

  list<node> susedia;
  
  v=G.first_node();
  while (v!=nil)
  {
    deg_all[v]=G.degree(v);
    deg_my[v]=0;
    susedia.clear();
    
    susedia=G.adj_nodes(v);
    while (susedia.size()>0)
    {
      v1=susedia.pop();
      if ((typ[v]==typ[v1])) deg_my[v]++;
    }    
    v=G.succ_node(v);    
  }

// end_ stupne jednotlivych vrcholov

  if (param1==1) param2=0;   // ak mam planarne, tak nemoze mat ani jedno krizenie !!!
  
  if (param3==0)    //pridavanim  -> fixed prazdne, nonfixed plne
  {
  
     v=G.first_node();
     while (v!=nil)     //vsetky vrcholy musim schovat
     {       
       u=G.succ_node(v);
       G.hide_node(v); 
       v=u;
     }    
  
    while (!nonfixed.empty())
    {
      v=VYBER_VRCHOL(G,nonfixed,typ,deg_all,deg_my,param4,2);           
      
      //teraz vrchol zviditelnin z zistim ci po nakresleni sa este zmestim do Crossings
      G.restore_node(v);
      
      // tu treba restorovat hrany spojene s tymto vrcholom !!!!!
      hrany=G.hidden_edges();
      while (hrany.size()>0)
      {
        e=hrany.pop();
	v1=G.source(e); v2=G.target(e);
	
	if ((!G.is_hidden(v1))&&(!G.is_hidden(v2))) 
	{
	  G.restore_edge(e);       
	}
      }
      
      if (param1==0)   //skusim randomne
      {
        xpos[v]=((rand()%int(xright-xleft))+xleft);
        ypos[v]=((rand()%int(ytop-ybottom))+ybottom);        
	
        if (crossing2(G,xpos,ypos)>param2) 
	{
	  G.hide_node(v);	  
	  dokreslovane.push(v);
        } else
 	{
	  fixed.push(v);			
	}      
      }

      if (param1==2)   //skusim spring
      {
        xpos[v]=((rand()%int(xright-xleft))+xleft);
        ypos[v]=((rand()%int(ytop-ybottom))+ybottom);        
	
        SPRING_EMBEDDING(G,xpos,ypos,xleft,xright,ybottom,ytop,250);        	
	
        if (crossing2(G,xpos,ypos)>param2) 
	{
	  G.hide_node(v);	  
	  dokreslovane.push(v);
        } else
 	{
	  fixed.push(v);			
	}      
      }
      
      if (param1==1)   //skusim planarne
      {
        if (!PLANAR(G,false)) 
	{
	  G.hide_node(v);	  
	  dokreslovane.push(v);
        } else
 	{
	  fixed.push(v);			
	}      
      }            
    }      
    
    // teraz by som mal nakreslit zakladny graf
    if (param1==1)
    {
      PLANAR_NAK(G,xpos,ypos,typ,xleft,xright,ybottom,ytop);                
    }    
    
  }
  
  if (param3==1)   //odoberam, fixed plne nonfixed prazdne
  {
      
    if (param1==1) // ak to mam nakreslit planarne tak to bude takto
    {    
      while (!PLANAR(G,false))
      {
        v=VYBER_VRCHOL(G,fixed,typ,deg_all,deg_my,param4,1);             
	dokreslovane.push(v);
        G.hide_node(v);        
      }          
      PLANAR_NAK(G,xpos,ypos,typ,xleft,xright,ybottom,ytop);                
    } 
    
    if (param1==0)
    {    
      RANDOM(G,xpos,ypos,xleft,xright,ybottom,ytop);        
      while (crossing2(G,xpos,ypos)>param2)
      {
        v=VYBER_VRCHOL(G,fixed,typ,deg_all,deg_my,param4,1);             
	dokreslovane.push(v);
        G.hide_node(v);        
      }          
    }
    
    if (param1==2)
    {
      RANDOM(G,xpos,ypos,xleft,xright,ybottom,ytop);        
      SPRING_EMBEDDING(G,xpos,ypos,xleft,xright,ybottom,ytop,250);        
      while (crossing2(G,xpos,ypos)>param2)
      {
        v=VYBER_VRCHOL(G,fixed,typ,deg_all,deg_my,param4,1);             
	dokreslovane.push(v);
        G.hide_node(v);        
      }                            
    }
  }
  
  NASKALUJ(G,xpos,ypos,xleft,xright,ybottom,ytop);
    
  // teraz by som mal postupne dokreslovat vrcholy !!!!!!!!!!! 
  if (param6==3)
  {
    while (dokreslovane.size()>0)
    { 
      v=VYBER_VRCHOL(G,dokreslovane,typ,deg_all,deg_my,param5,2);             
    
      //obnovim vrchol a hrany 
      G.restore_node(v);
    
      hrany=G.hidden_edges();
      while (hrany.size()>0)
      {
        e=hrany.pop();
        v1=G.source(e); v2=G.target(e);
	
        if ((!G.is_hidden(v1))&&(!G.is_hidden(v2))) 
        {
     	  G.restore_edge(e);       
        }
      }
    
      SPRING_EMBEDDING(G,fixed,xpos,ypos,xleft,xright,ybottom,ytop,250);        
      fixed.push(v);    
    }
  }
  
  if (param6==4)
  {
    G.restore_all_nodes();
    G.restore_all_edges();
    
    SPRING_EMBEDDING(G,fixed,xpos,ypos,xleft,xright,ybottom,ytop,250);        
  }
  
  if (param6<=2)
  {
    double pos_x=50,pos_y=50; //nove pozicie dokreslovaneho vrchola
    
    int pppp=0;
    if (param6==1) printf("\nHeuristika 1 : \n"); else  printf("\nHeuristika 2 : \n");
    while (dokreslovane.size()>0)
    { 
//      printf("vyberam vrchol \n");
      v=VYBER_VRCHOL(G,dokreslovane,typ,deg_all,deg_my,param5,2);             
      pppp++;
      printf("Pridavam vrchol cislo %d \n",G.number_of_nodes()+1);
//      if (pppp<3)
//      {
      if (param6==1) HEURISTIKA_1(G,fixed,v,xpos,ypos,xleft,xright,ybottom,ytop,pos_x,pos_y,typ); 
          else       HEURISTIKA_2(G,fixed,v,xpos,ypos,xleft,xright,ybottom,ytop,pos_x,pos_y,typ,deg_all,deg_my);       
//      }	  
	  
//      printf("restorujem maxim\n");
      xpos[v]=pos_x;
      ypos[v]=pos_y;
      
//      printf("restorujem\n");
      //restornem vrchol a jeho hrany s nim spojene !!!
      G.restore_node(v);
      hrany=G.hidden_edges();
//      printf("restorujem hrany\n");
      while (hrany.size()>0)
      {
        e=hrany.pop();
	v1=G.source(e); v2=G.target(e);
	
	if ((!G.is_hidden(v1))&&(!G.is_hidden(v2))) 
	{
	  G.restore_edge(e);     //   printf("restore.... \n");
	}
	
      }
            
      // koniec restorovania
//      printf("fixed push\n");

      fixed.push(v);    
/*!!!!!*/ //  dokreslovane.clear();     //toto spravi ze pridam len jeden vrchol -> sluzi na skusku pri robeni HEU
    } printf("Kreslenie ukoncene !!! \n");
  }    
}
