// Edge.cpp: implementation of the CEdge class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VRP.h"
#include "Edge.h"
#include "Globals.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CEdge::CEdge()
{
	m_state = 0;
	m_value = 0;
	m_nRouteId = 0;
	m_firstNode = NULL;
	m_secondNode = NULL;
}

CEdge::CEdge(CNode* f, CNode* s)
{
	m_state = 0;
	m_value = 0;
	m_nRouteId = 0;
	m_firstNode = f;
	m_secondNode = s;
}


CEdge::~CEdge()
{

}


void CEdge::setState(int state)
{
	m_state = state;
}

int CEdge::getState()
{
	return m_state;
}

void CEdge::setValue(float value)
{
	m_value = value;
}

float CEdge::getValue()
{
	return m_value;
}

void CEdge::Show(CDC *pDC)
{
	CPoint f = g_AppData->LPtoDP(m_firstNode->getLocation());
	CPoint s = g_AppData->LPtoDP(m_secondNode->getLocation());
	
	if (m_state == 1) {
		CPen newPen(PS_DASHDOTDOT,3,(COLORREF) 200000*m_nRouteId);
		CPen* pOldPen = pDC->SelectObject(&newPen);
		pDC->MoveTo(f.x, f.y);
		pDC->LineTo(s.x, s.y);
		pDC->SelectObject(pOldPen);
	} 
}

/*void CEdge::setNode(int index, CNode *node)
{
	if (index == 1) m_firstNode = node; 
	if (index == 2) m_secondNode = node;
}*/

void CEdge::SetRouteId(int id)
{
	m_nRouteId = id;
}

CPoint CEdge::GetFirstLocation()
{
	return m_firstNode->getLocation();
}

CPoint CEdge::GetSecondLocation()
{
	return m_secondNode->getLocation();
}
