// FJAlgorithm.cpp: implementation of the CFJAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VRP.h"
#include "FJAlgorithm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFJAlgorithm::CFJAlgorithm()
{

}

CFJAlgorithm::CFJAlgorithm(CVRPDoc* doc) 
	:CAlgorithm(doc)
{

}

CFJAlgorithm::~CFJAlgorithm()
{

}

// computing GAP using depth first tree search over all posibilietes
void CFJAlgorithm::ComputeGAP(int n,int k)
{
	for (int i=0; i < k; i++) {
		m_pDoc->m_Graph->GetNode(n)->setRouteId(i);
		m_pDoc->m_Graph->IncRouteDemand(i,m_pDoc->m_Graph->GetNode(n)->getDemand());
		m_fGAP += m_fCostTableCR[n][i];
		// check capacity constrains and best solution
		if (((m_pDoc->m_Graph->GetRouteDemand(i) <= m_pDoc->m_Graph->GetCapacity()) && 
			((m_fGAP <= m_fMinGAP) || (m_fMinGAP == -1)))) {
			// if all customers are added to route
			if (n == m_pDoc->m_Graph->GetNodeCount()-1) {
				if (m_fMinGAP == -1) m_fMinGAP = m_fGAP;
				else if (m_fMinGAP > m_fGAP) m_fMinGAP = m_fGAP;

			}
			else ComputeGAP(n+1,k);
		};
		m_pDoc->m_Graph->DecRouteDemand(i,m_pDoc->m_Graph->GetNode(n)->getDemand());
		m_fGAP -= m_fCostTableCR[n][i];
	};
}



void CFJAlgorithm::SolveFJ(int RouteNumber)
{
//	m_fMinGAP = -1;
//	m_fGAP = 0;
	m_nRouteNumber = RouteNumber;
	m_pDoc->m_Graph->CreateRoutes(RouteNumber);
	m_pDoc->m_Graph->UpdateEdgeValues();
	SelectSeeds();
	ComputeCostTable();
	AssignCustomers();
	FinishRoutes();
	m_pDoc->UpdateAllViews(NULL);
//	ComputeGAP(1,RouteNumber);
}

void CFJAlgorithm::ComputeCostTable()
{
	int CustomerCount = m_pDoc->m_Graph->GetNodeCount();
	
	m_fCostTableCR = new float*[CustomerCount];
	for (int i=0; i < CustomerCount; i++) 
		m_fCostTableCR[i] = new float[m_nRouteNumber];

	for (i = 0; i < CustomerCount; i++) {
		for (int j = 0; j < m_nRouteNumber; j++)
		{
			m_fCostTableCR[i][j] = m_pDoc->m_Graph->GetEdgeValue(0,i) +
								   m_pDoc->m_Graph->GetEdgeValue(i,m_nSeedIdArrray[j]) -
								   m_pDoc->m_Graph->GetEdgeValue(0,m_nSeedIdArrray[j]);
		}				
	}
}

void CFJAlgorithm::SelectSeeds()
{
	m_nSeedIdArrray = new int[m_nRouteNumber];

	for (int i = 0; i < m_nRouteNumber; i ++) {
		m_nSeedIdArrray[i] = i+5;
		m_pDoc->m_Graph->GetNode(m_nSeedIdArrray[i])->SetState(1);
		m_pDoc->m_Graph->GetNode(m_nSeedIdArrray[i])->setRouteId(i);
		m_pDoc->m_Graph->AddNodeToRouteTail(i,m_pDoc->m_Graph->GetNode(0));
		m_pDoc->m_Graph->AddNodeToRouteTail(i,m_pDoc->m_Graph->GetNode(m_nSeedIdArrray[i]));
		m_pDoc->m_Graph->IncRouteDemand(i,m_pDoc->m_Graph->GetNodeDemand(m_nSeedIdArrray[i]));
	}
}

void CFJAlgorithm::AssignCustomers()
{
	int index;
	int demand;
	int CustomerCount = m_pDoc->m_Graph->GetNodeCount();

	for (int i=0; i < CustomerCount ;i++) {
		if (m_pDoc->m_Graph->GetNode(i)->GetState() == 0) {
			index = -1;
			for (int j = 0; j < m_nRouteNumber; j++) {
				demand = m_pDoc->m_Graph->GetRouteDemand(j) + m_pDoc->m_Graph->GetNodeDemand(i); 
				if (demand <= m_pDoc->m_Graph->GetCapacity()) {
					if (index == -1) index = 0;
					if ((m_fCostTableCR[i][index] > m_fCostTableCR[i][j])) {
							index = j;
					}
				}
			}
			if (index != -1) {
				m_pDoc->m_Graph->IncRouteDemand(index,m_pDoc->m_Graph->GetNodeDemand(i)); 
				m_pDoc->m_Graph->AddNodeToRouteTail(index,m_pDoc->m_Graph->GetNode(i));
				m_pDoc->m_Graph->GetNode(i)->setRouteId(index);
			}
		}
	}
}

void CFJAlgorithm::FinishRoutes()
{
	for (int i = 0; i < m_nRouteNumber; i ++) {
		m_pDoc->m_Graph->AddNodeToRouteTail(i,m_pDoc->m_Graph->GetNode(0));
	}
}
