// FJAlgorithm.h: interface for the CFJAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FJALGORITHM_H__C11BC587_3AA3_4B96_96CF_AFCEAE70C313__INCLUDED_)
#define AFX_FJALGORITHM_H__C11BC587_3AA3_4B96_96CF_AFCEAE70C313__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Algorithm.h"

class CFJAlgorithm : public CAlgorithm  
{
public:
	void SolveFJ(int RouteNumber);
	CFJAlgorithm();
	CFJAlgorithm(CVRPDoc* doc);
	virtual ~CFJAlgorithm();

private:
	void FinishRoutes();
	int m_nRouteNumber;
	void AssignCustomers();
	void SelectSeeds();
	int* m_nSeedIdArrray;
	void ComputeCostTable();
	float** m_fCostTableCR;
	float m_fGAP;
	float m_fMinGAP;
	void ComputeGAP(int n,int k);
};

#endif // !defined(AFX_FJALGORITHM_H__C11BC587_3AA3_4B96_96CF_AFCEAE70C313__INCLUDED_)
