// GreedyTSP.cpp: implementation of the CGreedyTSP class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VRP.h"
#include "GreedyTSP.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGreedyTSP::CGreedyTSP()
{

}

CGreedyTSP::CGreedyTSP(CVRPDoc* doc) 
	:CAlgorithm(doc)
{

}

CGreedyTSP::~CGreedyTSP()
{

}

void CGreedyTSP::ProcessRoute(int id)
{
	int index;
	CRoute* route = m_pDoc->m_Graph->GetRoute(id);
	
	for (int i = 0;i < route->getLength()-1; i++) {
		index = i+1; 
		for (int j = i+1;j < route->getLength()-1;j++) {
			if (m_pDoc->m_Graph->GetEdgeValue(route->GetNodeId(i),route->GetNodeId(j)) <= 
				m_pDoc->m_Graph->GetEdgeValue(route->GetNodeId(i),route->GetNodeId(index))) {
				index = j;
			}
		}
		route->ExchangeNodes(i+1,index);
	}
}

void CGreedyTSP::SolveGreedyTSP()
{
	for (int i=0; i < m_pDoc->m_Graph->GetRouteCount();i++) {
		ProcessRoute(i);
	}
	m_pDoc->UpdateAllViews(NULL);
}
