// MJInsertAlgorithm.cpp: implementation of the CMJInsertAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VRP.h"
#include "MJInsertAlgorithm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMJInsertAlgorithm::CMJInsertAlgorithm()
{

}

CMJInsertAlgorithm::CMJInsertAlgorithm(CVRPDoc* doc) 
	:CAlgorithm(doc)
{

}

CMJInsertAlgorithm::~CMJInsertAlgorithm()
{

}

void CMJInsertAlgorithm::InitVariables()
{
	for (int i=0; i < m_pDoc->m_Graph->GetNodeCount(); i++) {
		m_pDoc->m_Graph->GetNode(i)->SetState(0);
	}
}

int CMJInsertAlgorithm::SetNewRoute()
{
	int result = -1;
	BOOL test = true;
	int count = 1;
	while ((test) && (count < m_pDoc->m_Graph->GetNodeCount())) {
		if (m_pDoc->m_Graph->GetNodeState(count) == 0) {
			test = false;
			
			m_pDoc->m_Graph->GetNode(count)->SetState(1);
			// set new route
			m_pDoc->m_Graph->AddRoute();
			int last = m_pDoc->m_Graph->GetRouteCount()-1;
			m_pDoc->m_Graph->AddNodeToRouteTail(last,m_pDoc->m_Graph->GetNode(0));
			m_pDoc->m_Graph->AddNodeToRouteTail(last,m_pDoc->m_Graph->GetNode(count));
			m_pDoc->m_Graph->AddNodeToRouteTail(last,m_pDoc->m_Graph->GetNode(0));
			m_pDoc->m_Graph->IncRouteDemand(last,m_pDoc->m_Graph->GetNodeDemand(count));
			result = last;
		}
		count++;
	}
	return result; 
}

void CMJInsertAlgorithm::SolveMJ(float lambda, float mu)
{	
	m_fLambda = lambda;
	m_fMu = mu;

	m_pDoc->m_Graph->CreateRoutes(0);
	m_pDoc->m_Graph->UpdateEdgeValues();
	InitVariables();
	
	int routeId = SetNewRoute();
	while (routeId != -1) {
		CountInsertCost(routeId);
		int nodeId = ChooseNodeToInsert();
		while (nodeId != -1) {
			InsertNodeToRoute(nodeId,routeId);
			CountInsertCost(routeId);
			nodeId = ChooseNodeToInsert();
		};
		routeId = SetNewRoute();
	};
	m_pDoc->UpdateAllViews(NULL);
}

void CMJInsertAlgorithm::CountInsertCost(int id)
{
	CRoute* route = m_pDoc->m_Graph->GetRoute(id);
	int demand;
	float cost;

	for (int i=1; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		m_pDoc->m_Graph->GetNode(i)->SetInsertCost(-1);
		m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(-1);
		// check only unrouted nodes
		if (m_pDoc->m_Graph->GetNodeState(i) == 0) {
			demand = route->getDemand() + m_pDoc->m_Graph->GetNodeDemand(i);
			if (demand <= m_pDoc->m_Graph->GetCapacity()) {
				// check all possibilieties to insert in route
				for (int j=0;j < route->getLength()-1; j++) {
					cost = m_pDoc->m_Graph->GetEdgeValue(route->GetNodeId(j),i) + 
						   m_pDoc->m_Graph->GetEdgeValue(route->GetNodeId(j+1),i) -
						   (m_fLambda * m_pDoc->m_Graph->GetEdgeValue(route->GetNodeId(j),route->GetNodeId(j+1)));
					// if it is first possible
					if (m_pDoc->m_Graph->GetNode(i)->GetInsertCost() == -1) {
						m_pDoc->m_Graph->GetNode(i)->SetInsertCost(cost);
						m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(j+1);
					// if insertion is cheaper
					} else if (m_pDoc->m_Graph->GetNode(i)->GetInsertCost() >= cost) {
						m_pDoc->m_Graph->GetNode(i)->SetInsertCost(cost);
						m_pDoc->m_Graph->GetNode(i)->SetInsertIndex(j+1);
					};

				}
			}
		}
	}
}

int CMJInsertAlgorithm::ChooseNodeToInsert()
{
	int result = -1;
	float max = -1;
	float cost;

	for (int i = 1 ; i < m_pDoc->m_Graph->GetNodeCount();i++) {
		// check only unrouted nodes 
		if ((m_pDoc->m_Graph->GetNodeState(i) == 0) && 
			(m_pDoc->m_Graph->GetNode(i)->GetInsertIndex() != -1)) {
			cost = (m_fMu * m_pDoc->m_Graph->GetEdgeValue(0,i)) -
					m_pDoc->m_Graph->GetNode(i)->GetInsertCost();
			if (max == -1) {
				result = i;
				max = cost; 
			} else if (max <= cost) {
				result = i;
				max = cost;
			}
		}
	}
	return result;
}

void CMJInsertAlgorithm::InsertNodeToRoute(int NodeId,int RouteId)
{
	CNode* node = m_pDoc->m_Graph->GetNode(NodeId);

	m_pDoc->m_Graph->GetRoute(RouteId)->InsertNode(node->GetInsertIndex(),node);
	m_pDoc->m_Graph->IncRouteDemand(RouteId,node->getDemand());
	node->SetState(1);
	node->setRouteId(RouteId);
			
}
