// NodeDialog.cpp : implementation file
//

#include "stdafx.h"
#include "VRP.h"
#include "Globals.h"
#include "NodeDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNodeDialog dialog


CNodeDialog::CNodeDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CNodeDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNodeDialog)
	m_Id = _T("");
	m_Demand = _T("");
	m_LocationX = _T("");
	m_LocationY = _T("");
	m_Route = _T("");
	//}}AFX_DATA_INIT
	m_pView = NULL;
}

CNodeDialog::CNodeDialog(CView* pView)
{
	m_pView = pView;
}


void CNodeDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNodeDialog)
	DDX_Text(pDX, IDC_ID, m_Id);
	DDX_Text(pDX, IDC_DEMAND, m_Demand);
	DDX_Text(pDX, IDC_X, m_LocationX);
	DDX_Text(pDX, IDC_Y, m_LocationY);
	DDX_Text(pDX, IDC_ROUTE, m_Route);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNodeDialog, CDialog)
	//{{AFX_MSG_MAP(CNodeDialog)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNodeDialog message handlers

void CNodeDialog::OnOK()
{

}

void CNodeDialog::OnCancel()
{
	if (m_pView != NULL) {
		m_pView->PostMessage(WM_CLOSE_DIALOG, IDCANCEL);
	}
	else {
		// for modal dialog
		CDialog::OnCancel();
	}
}

void CNodeDialog::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnClose();

}

void CNodeDialog::setData(CNode *node)
{
	CPoint point;
	if (node != NULL) {
		m_Id = g_AppData->IntToStr(node->getId());
		m_Demand = g_AppData->IntToStr(node->getDemand());
		point = node->getLocation();
		m_LocationX = g_AppData->IntToStr(point.x);
		m_LocationY = g_AppData->IntToStr(point.y);
		m_Route = g_AppData->IntToStr(node->getRouteId());
	}
	else {
		m_Id = "No Data";
		m_Demand = "No Data";
		m_LocationX = "No Data";
		m_LocationY = "No Data";
		m_Route = "No Data";
	}
	UpdateData(FALSE);
}
