// VRPView.cpp : implementation of the CVRPView class
//

#include "stdafx.h"
#include "VRP.h"

#include "VRPDoc.h"
#include "VRPView.h"
#include "SavingsAlgorithm.h"
#include "FJAlgorithm.h"
#include "GreedyTSP.h"
#include "MJInsertAlgorithm.h"
#include "InsertionAlgorithm.h"
#include "SweepAlgorithm.h"
#include "OptAlgorithm.h"
#include "SizeDialog.h"
#include "LambdaDialog.h"
#include "VehicleDialog.h"
#include "LMDialog.h"

#include "Globals.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVRPView

IMPLEMENT_DYNCREATE(CVRPView, CView)

BEGIN_MESSAGE_MAP(CVRPView, CView)
	//{{AFX_MSG_MAP(CVRPView)
	ON_WM_LBUTTONDOWN()
	ON_WM_SIZE()
	ON_COMMAND(ID_TOOL_ADDNODE, OnToolAddnode)
	ON_UPDATE_COMMAND_UI(ID_TOOL_ADDNODE, OnUpdateToolAddnode)
	ON_COMMAND(ID_TOOL_SELECTNODE, OnToolSelectnode)
	ON_UPDATE_COMMAND_UI(ID_TOOL_SELECTNODE, OnUpdateToolSelectnode)
	ON_COMMAND(ID_VIEW_NODEINFO, OnViewNodeinfo)
	ON_UPDATE_COMMAND_UI(ID_VIEW_NODEINFO, OnUpdateViewNodeinfo)
	ON_COMMAND(ID_SOLVE, OnSolve)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ROUTEINFO, OnUpdateViewRouteinfo)
	ON_COMMAND(ID_VIEW_ROUTEINFO, OnViewRouteinfo)
	ON_COMMAND(ID_NEW_INSTANCE, OnNewInstance)
	ON_COMMAND(ID_SOLVE_SEQUENTIALSAVINGSALGORITHMS_BASIC2OPT, OnSolveSequentialsavingsalgorithmsBasic2opt)
	ON_COMMAND(ID_SOLVE_SAVINGSALGORITHMS_SEQUENTIAL_BASIC, OnSolveSavingsalgorithmsSequentialBasic)
	ON_COMMAND(ID_SOLVE_SEQUENTIALSAVINGSALGORITHMS_PARAMETER, OnSolveSequentialsavingsalgorithmsParameter)
	ON_COMMAND(ID_SOLVE_SEQUENTIALSAVINGSALGORITHMS_PARAMETER2OPT, OnSolveSequentialsavingsalgorithmsParameter2opt)
	ON_COMMAND(ID_SOLVE_PARALLELSAVINGSALGORITHMS_BASIC, OnSolveParallelsavingsalgorithmsBasic)
	ON_COMMAND(ID_SOLVE_PARALLELSAVINGSALGORITHMS_BASIC2OPT, OnSolveParallelsavingsalgorithmsBasic2opt)
	ON_COMMAND(ID_SOLVE_PARALLELSAVINGSALGORITHMS_PARAMETER, OnSolveParallelsavingsalgorithmsParameter)
	ON_COMMAND(ID_SOLVE_PARALLELSAVINGSALGORITHMS_PARAMETER2OPT, OnSolveParallelsavingsalgorithmsParameter2opt)
	ON_COMMAND(ID_SOLVE_2PHASEALGORITHMS_FJALGORITHM, OnSolve2phasealgorithmsFjalgorithm)
	ON_COMMAND(ID_SOLVE_2PHASEALGORITHMS_FJALGORITHM2OPT, OnSolve2phasealgorithmsFjalgorithm2opt)
	ON_COMMAND(ID_SOLVE_2PHASEALGORITHMS_SWEEPALGORITHM, OnSolve2phasealgorithmsSweepalgorithm)
	ON_COMMAND(ID_SOLVE_2PHASEALGORITHMS_SWEEPALGORITHM2OPT, OnSolve2phasealgorithmsSweepalgorithm2opt)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_MJALGORITHM, OnSolveInsertionalgorithmsMjalgorithm)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_MJALGORITHM2OPT, OnSolveInsertionalgorithmsMjalgorithm2opt)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_BESTNODEFIRST, OnSolveInsertionparallelalgorithmsBestnodefirst)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_FARESTNODEFIRST, OnSolveInsertionalgorithmsparallelalgorithmsFarestnodefirst)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_NEARESTNODEFIRST, OnSolveInsertionalgorithmsparallelalgorithmsNearestnodefirst)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_BESTNODEFIRST, OnSolveInsertionalgorithmssequentialalgorithmsBestnodefirst)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_FARESR, OnSolveInsertionalgorithmssequentialalgorithmsFaresr)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_NEARESTNODEFIRST, OnSolveInsertionalgorithmssequentialalgorithmsNearestnodefirst)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_BESTNODEFIRST2OPT, OnSolveInsertionalgorithmsparallelalgorithmsBestnodefirst2opt)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_FARESTNODEFIRST2OPT, OnSolveInsertionalgorithmsparallelalgorithmsFarestnodefirst2opt)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_NEARESTNODEFIRST2OPT, OnSolveInsertionalgorithmsparallelalgorithmsNearest2opt)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_BESTNODEFIRST2OPT, OnSolveInsertionalgorithmssequentialalgorithmsBest2opt)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_FARESTNODEFIRST2OPT, OnSolveInsertionalgorithmssequentialalgorithmsFarest2opt)
	ON_COMMAND(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_NEARESTNODEFIRST2OPT, OnSolveInsertionalgorithmssequentialalgorithmsNearest2opt)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_2PHASEALGORITHMS_FJALGORITHM, OnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_2PHASEALGORITHMS_FJALGORITHM2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_2PHASEALGORITHMS_SWEEPALGORITHM, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_2PHASEALGORITHMS_SWEEPALGORITHM2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_MJALGORITHM, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_MJALGORITHM2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_BESTNODEFIRST, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_BESTNODEFIRST2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_FARESTNODEFIRST, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_FARESTNODEFIRST2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_NEARESTNODEFIRST, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONPARALLELALGORITHMS_NEARESTNODEFIRST2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_BESTNODEFIRST, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_BESTNODEFIRST2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_FARESR, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_FARESTNODEFIRST2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_NEARESTNODEFIRST, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_INSERTIONALGORITHMS_NEARESTINSERTIONSEQUENTIALALGORITHMS_NEARESTNODEFIRST2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_PARALLELSAVINGSALGORITHMS_BASIC, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_PARALLELSAVINGSALGORITHMS_BASIC2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_PARALLELSAVINGSALGORITHMS_PARAMETER, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_PARALLELSAVINGSALGORITHMS_PARAMETER2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_SAVINGSALGORITHMS_SEQUENTIAL_BASIC, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_SEQUENTIALSAVINGSALGORITHMS_BASIC2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_SEQUENTIALSAVINGSALGORITHMS_PARAMETER, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE_SEQUENTIALSAVINGSALGORITHMS_PARAMETER2OPT, OnUpdateOnUpdateSolveAlgorithm)
	ON_UPDATE_COMMAND_UI(ID_SOLVE, OnUpdateSolveAlgorithm)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_CLOSE_DIALOG, OnCloseInfoDialog)
	ON_MESSAGE(WM_CLOSE_ROUTE_DIALOG, OnCloseRouteDialog)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVRPView construction/destruction

CVRPView::CVRPView()
{
	// TODO: add construction code here
	m_bAddTool = FALSE;
	m_bSlctTool = TRUE;
	m_pNodeDlg = new CNodeDialog(this);
	m_bNodeDlg = FALSE;
	m_pRouteDlg = new CRouteDialog(this);
	m_bRouteDlg = FALSE;
}

CVRPView::~CVRPView()
{
	delete m_pNodeDlg;
	delete m_pRouteDlg;
}

BOOL CVRPView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CVRPView drawing

void CVRPView::OnDraw(CDC* pDC)
{
	CVRPDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
	// aktualize size of client rect
	CRect rect;
	GetClientRect(rect);
	g_AppData->setWndRect(rect);
	
	if (g_AppData->m_bGraphChange) {
		pDoc->m_Graph->UpdateGraphRect();
		pDoc->m_Graph->CreateRoutes(0);
		g_AppData->setGraphRect(pDoc->m_Graph->getGraphRect());
		g_AppData->m_bGraphChange = false;
	}
	if (g_AppData->m_SetVehicleCapacity) {
		pDoc->m_Graph->SetCapacity(g_AppData->m_nVehicleCapacity);
		g_AppData->m_SetVehicleCapacity = false;
	}

	// draw the graph on the screen	
	pDoc->m_Graph->Show(pDC);
}

/////////////////////////////////////////////////////////////////////////////
// CVRPView diagnostics

#ifdef _DEBUG
void CVRPView::AssertValid() const
{
	CView::AssertValid();
}

void CVRPView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CVRPDoc* CVRPView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVRPDoc)));
	return (CVRPDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVRPView message handlers

void CVRPView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class

	Invalidate();
}

void CVRPView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CVRPDoc* pDoc = GetDocument();
	CNode* node;

	// If Add tool is selected
	if (m_bAddTool) {
		node = new CNode;
		node->setLocation(g_AppData->DPtoLP(point));
		CNewNodeDialog dlg;
		if (dlg.DoModal() == 1) {
			pDoc->m_Graph->addNodeTail(node);
			pDoc->SetModifiedFlag();
			Invalidate();
		}
	}
	if (m_bSlctTool) {
		node = pDoc->m_Graph->SelectNode(point);	
		if (m_bNodeDlg) {
			m_pNodeDlg->setData(node);
		}
		Invalidate();
	}

	CView::OnLButtonDown(nFlags, point);


}

void CVRPView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	
	// aktualize size of client rect
	CRect rect;
	GetClientRect(rect);
	g_AppData->setWndRect(rect);
}

void CVRPView::OnToolAddnode() 
{
	// TODO: Add your command handler code here
	m_bAddTool = TRUE;
	m_bSlctTool = FALSE;
	
}

void CVRPView::OnUpdateToolAddnode(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bAddTool);
}

void CVRPView::OnToolSelectnode() 
{
	// TODO: Add your command handler code here
	m_bAddTool = FALSE;
	m_bSlctTool = TRUE;

}

void CVRPView::OnUpdateToolSelectnode(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bSlctTool);
}

void CVRPView::OnViewNodeinfo() 
{
	CVRPDoc* pDoc = GetDocument();	
	
	if (!m_bNodeDlg) {
		m_pNodeDlg->Create(CNodeDialog::IDD);
		m_pNodeDlg->setData(pDoc->m_Graph->getSlctNode());
		m_bNodeDlg = TRUE;
	}
	else {
		m_pNodeDlg->DestroyWindow();
		m_bNodeDlg = FALSE;
	}
}

void CVRPView::OnUpdateViewNodeinfo(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bNodeDlg);
}

LRESULT CVRPView::OnCloseInfoDialog(WPARAM wParam, LPARAM lParam)
{
	m_pNodeDlg->DestroyWindow();
	m_bNodeDlg = FALSE;
	return 0L;
}

LRESULT CVRPView::OnCloseRouteDialog(WPARAM wParam, LPARAM lParam)
{
	m_pRouteDlg->DestroyWindow();
	m_bRouteDlg = FALSE;
	return 0L;
}




void CVRPView::OnSolve() 
{
	CVRPDoc* pDoc = GetDocument();
	
	pDoc->m_Graph->CreateEdgeTable();
	CSolveDialog dlg;
		if (dlg.DoModal() == 1) {
			// savings algorithm
			if (dlg.m_sAlgCombo == "Savings Algorithm") {
				if (dlg.m_sVerCombo == "Sequential") {
					CSavingsAlgorithm* alg;
					alg = new CSavingsAlgorithm(pDoc);
					alg->SolveSequntial();
					delete alg;
				}
				if (dlg.m_sVerCombo == "Parallel") {
					CSavingsAlgorithm* alg;
					alg = new CSavingsAlgorithm(pDoc);
					alg->SolveParalel();
					delete alg;
				}
				if (dlg.m_sVerCombo == "Sequential + Parameter") {
					CSavingsAlgorithm* alg;
					alg = new CSavingsAlgorithm(pDoc);
					alg->SolveSeqParameter(dlg.m_fLambdaEdit);
					delete alg;
				}
				if (dlg.m_sVerCombo == "Parallel + Parameter") {
					CSavingsAlgorithm* alg;
					alg = new CSavingsAlgorithm(pDoc);
					alg->SolveParParameter(dlg.m_fLambdaEdit);
					delete alg;
				}
			}
			if (dlg.m_sAlgCombo == "Insertion Algorithm") {
				if (dlg.m_sVerCombo == "M&J Insertion") {
					CMJInsertAlgorithm* alg;
					alg = new CMJInsertAlgorithm(pDoc);
					alg->SolveMJ(dlg.m_fLambdaEdit,dlg.m_fMuEdit);
					delete alg;
				}
				if (dlg.m_sVerCombo == "Best - Nearest Addition Sequential") {
					CInsertionAlgorithm* alg;
					alg = new CInsertionAlgorithm(pDoc);
					alg->SolveAdditionBestSeq();
					delete alg;
				}
				if (dlg.m_sVerCombo == "Best - Nearest Addition Parallel") {
					CInsertionAlgorithm* alg;
					alg = new CInsertionAlgorithm(pDoc);
					alg->SolveAdditionBestPar();
					delete alg;
				}
				if (dlg.m_sVerCombo == "Near - Nearest Addition Sequential") {
					CInsertionAlgorithm* alg;
					alg = new CInsertionAlgorithm(pDoc);
					alg->SolveAdditionNearSeq();
					delete alg;
				}
				if (dlg.m_sVerCombo == "Near - Nearest Addition Parallel") {
					CInsertionAlgorithm* alg;
					alg = new CInsertionAlgorithm(pDoc);
					alg->SolveAdditionNearPar();
					delete alg;
				}
				if (dlg.m_sVerCombo == "Far - Nearest Addition Sequential") {
					CInsertionAlgorithm* alg;
					alg = new CInsertionAlgorithm(pDoc);
					alg->SolveAdditionFarSeq();
					delete alg;
				}
				if (dlg.m_sVerCombo == "Far - Nearest Addition Parallel") {
					CInsertionAlgorithm* alg;
					alg = new CInsertionAlgorithm(pDoc);
					alg->SolveAdditionFarPar();
					delete alg;
				}
			}
			if (dlg.m_sAlgCombo == "2-phase Algorithm") {
				if (dlg.m_sVerCombo == "Sweep algorithm") {
					CSweepAlgorithm* alg;
					alg = new CSweepAlgorithm(pDoc);
					alg->Solve();
					delete alg;
					CGreedyTSP* alg1;
					alg1 = new CGreedyTSP(pDoc);
					alg1->SolveGreedyTSP();
					delete alg1;
				}
				if (dlg.m_sVerCombo == "F&J Algorithm") {
					CFJAlgorithm* alg;
					alg = new CFJAlgorithm(pDoc);
					alg->SolveFJ(dlg.m_nVehicleEdit);
					delete alg;
					CGreedyTSP* alg1;
					alg1 = new CGreedyTSP(pDoc);
					alg1->SolveGreedyTSP();
					delete alg1;
				}
			}

			if (dlg.m_sOptCombo == "2-Opt Algorithm") {
					COptAlgorithm* opt;
					opt = new COptAlgorithm(pDoc);
					opt->SolveOpt2();
					delete opt;
			}
		}
		



}

void CVRPView::OnUpdateViewRouteinfo(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_bRouteDlg);
}

void CVRPView::OnViewRouteinfo() 
{
	
	CVRPDoc* pDoc = GetDocument();	
	
	if (!m_bRouteDlg) {
		m_pRouteDlg->Create(CRouteDialog::IDD);
		m_pRouteDlg->SetData(pDoc);
		m_bRouteDlg = TRUE;
	}
	else {
		m_pRouteDlg->DestroyWindow();
		m_bRouteDlg = FALSE;
	}
}

void CVRPView::OnNewInstance() 
{
	CVRPDoc* pDoc = GetDocument();
	CPoint point;
	CNode* node;
	node = new CNode();
	CNewInstanceDlg dlg;
		if (dlg.DoModal() == 1) {
			pDoc->m_Graph->CreateNodeArray(dlg.m_nNodeEdit);
			for (int i=0;i < dlg.m_nNodeEdit; i++) {
				node = new CNode();
				int demand = (rand()%(dlg.m_nMaxDemandEdit-dlg.m_MinDemandEdit)) + 
						dlg.m_MinDemandEdit;
				if (i == 0) node->setDemand(0);
				else node->setDemand(demand);
				point.x = (rand()%dlg.m_Width)+1;
				point.y = (rand()%dlg.m_Height)+1;
				node->setLocation(point);
				node->setId(i);
				pDoc->m_Graph->AddNodeToPos(i,node);
			}
			pDoc->m_Graph->SetCapacity(dlg.m_nCapacity);
			//pDoc->m_Graph->UpdateGraphRect();
			g_AppData->setGraphRect(CRect(0,0,dlg.m_Width,dlg.m_Height));
			pDoc->m_Graph->CreateEdgeTable();
			Invalidate();
		}
}


void CVRPView::OnSolveSequentialsavingsalgorithmsBasic2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();
	
	CSavingsAlgorithm* alg;
	alg = new CSavingsAlgorithm(pDoc);
	alg->SolveSequntial();
	delete alg;
		
	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;
}

void CVRPView::OnSolveSavingsalgorithmsSequentialBasic() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();
	
	CSavingsAlgorithm* alg;
	alg = new CSavingsAlgorithm(pDoc);
	alg->SolveSequntial();
	delete alg;
}

void CVRPView::OnSolveSequentialsavingsalgorithmsParameter() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();
	
	CLambdaDialog dlg;
	if (dlg.DoModal() == 1) {
		CSavingsAlgorithm* alg;
		alg = new CSavingsAlgorithm(pDoc);
		alg->SolveSeqParameter(dlg.m_fLambda);
		delete alg;
	}
	
}

void CVRPView::OnSolveSequentialsavingsalgorithmsParameter2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();
	
	CLambdaDialog dlg;
	if (dlg.DoModal() == 1) {
		CSavingsAlgorithm* alg;
		alg = new CSavingsAlgorithm(pDoc);
		alg->SolveSeqParameter(dlg.m_fLambda);
		delete alg;
	}
	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;
}

void CVRPView::OnSolveParallelsavingsalgorithmsBasic() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CSavingsAlgorithm* alg;
	alg = new CSavingsAlgorithm(pDoc);
	alg->SolveParalel();
	delete alg;
	
}

void CVRPView::OnSolveParallelsavingsalgorithmsBasic2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CSavingsAlgorithm* alg;
	alg = new CSavingsAlgorithm(pDoc);
	alg->SolveParalel();
	delete alg;

	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;
	
}

void CVRPView::OnSolveParallelsavingsalgorithmsParameter() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();
	
	CLambdaDialog dlg;
	if (dlg.DoModal() == 1) {
		CSavingsAlgorithm* alg;
		alg = new CSavingsAlgorithm(pDoc);
		alg->SolveParParameter(dlg.m_fLambda);
		delete alg;
	}
}

void CVRPView::OnSolveParallelsavingsalgorithmsParameter2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();
	
	CLambdaDialog dlg;
	if (dlg.DoModal() == 1) {
		CSavingsAlgorithm* alg;
		alg = new CSavingsAlgorithm(pDoc);
		alg->SolveParParameter(dlg.m_fLambda);
		delete alg;
	
		COptAlgorithm* opt;
		opt = new COptAlgorithm(pDoc);
		opt->SolveOpt2();
		delete opt;
	}
}

void CVRPView::OnSolve2phasealgorithmsFjalgorithm() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CVehicleDialog dlg;
	if (dlg.DoModal() == 1) {
			CFJAlgorithm* alg;
			alg = new CFJAlgorithm(pDoc);
			alg->SolveFJ(dlg.m_VehicleNumber);
			delete alg;
			CGreedyTSP* alg1;
			alg1 = new CGreedyTSP(pDoc);
			alg1->SolveGreedyTSP();
			delete alg1;
	}
}

void CVRPView::OnSolve2phasealgorithmsFjalgorithm2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CVehicleDialog dlg;
	if (dlg.DoModal() == 1) {
			CFJAlgorithm* alg;
			alg = new CFJAlgorithm(pDoc);
			alg->SolveFJ(dlg.m_VehicleNumber);
			delete alg;

			CGreedyTSP* alg1;
			alg1 = new CGreedyTSP(pDoc);
			alg1->SolveGreedyTSP();
			delete alg1;

			COptAlgorithm* opt;
			opt = new COptAlgorithm(pDoc);
			opt->SolveOpt2();
			delete opt;
	}
}

void CVRPView::OnSolve2phasealgorithmsSweepalgorithm() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CSweepAlgorithm* alg;
	alg = new CSweepAlgorithm(pDoc);
	alg->Solve();
	delete alg;
	CGreedyTSP* alg1;
	alg1 = new CGreedyTSP(pDoc);
	alg1->SolveGreedyTSP();
	delete alg1;
}

void CVRPView::OnSolve2phasealgorithmsSweepalgorithm2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();
	
	CSweepAlgorithm* alg;
	alg = new CSweepAlgorithm(pDoc);
	alg->Solve();
	delete alg;

	CGreedyTSP* alg1;
	alg1 = new CGreedyTSP(pDoc);
	alg1->SolveGreedyTSP();
	delete alg1;

	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;
}

void CVRPView::OnSolveInsertionalgorithmsMjalgorithm() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CLMDialog dlg;
	if (dlg.DoModal() == 1) {
		CMJInsertAlgorithm* alg;
		alg = new CMJInsertAlgorithm(pDoc);
		alg->SolveMJ(dlg.m_fLambda,dlg.m_fMu);
		delete alg;
	}
}

void CVRPView::OnSolveInsertionalgorithmsMjalgorithm2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CLMDialog dlg;
	if (dlg.DoModal() == 1) {
		CMJInsertAlgorithm* alg;
		alg = new CMJInsertAlgorithm(pDoc);
		alg->SolveMJ(dlg.m_fLambda,dlg.m_fMu);
		delete alg;

		COptAlgorithm* opt;
		opt = new COptAlgorithm(pDoc);
		opt->SolveOpt2();
		delete opt;
	}
}

void CVRPView::OnSolveInsertionparallelalgorithmsBestnodefirst() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionBestPar();
	delete alg;
}

void CVRPView::OnSolveInsertionalgorithmsparallelalgorithmsFarestnodefirst() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionFarPar();
	delete alg;
}

void CVRPView::OnSolveInsertionalgorithmsparallelalgorithmsNearestnodefirst() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionNearPar();
	delete alg;

	
}

void CVRPView::OnSolveInsertionalgorithmssequentialalgorithmsBestnodefirst() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionBestSeq();
	delete alg;
}

void CVRPView::OnSolveInsertionalgorithmssequentialalgorithmsFaresr() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionFarSeq();
	delete alg;
}

void CVRPView::OnSolveInsertionalgorithmssequentialalgorithmsNearestnodefirst() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionNearSeq();
	delete alg;
}

void CVRPView::OnSolveInsertionalgorithmsparallelalgorithmsBestnodefirst2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionBestPar();
	delete alg;

	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;

}

void CVRPView::OnSolveInsertionalgorithmsparallelalgorithmsFarestnodefirst2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionFarPar();
	delete alg;

	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;
}

void CVRPView::OnSolveInsertionalgorithmsparallelalgorithmsNearest2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionNearPar();
	delete alg;

	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;
}

void CVRPView::OnSolveInsertionalgorithmssequentialalgorithmsBest2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionBestSeq();
	delete alg;

	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;
}

void CVRPView::OnSolveInsertionalgorithmssequentialalgorithmsFarest2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionFarSeq();
	delete alg;

	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;

}

void CVRPView::OnSolveInsertionalgorithmssequentialalgorithmsNearest2opt() 
{
	CVRPDoc* pDoc = GetDocument();
	pDoc->m_Graph->CreateEdgeTable();

	CInsertionAlgorithm* alg;
	alg = new CInsertionAlgorithm(pDoc);
	alg->SolveAdditionNearSeq();
	delete alg;

	COptAlgorithm* opt;
	opt = new COptAlgorithm(pDoc);
	opt->SolveOpt2();
	delete opt;

}



void CVRPView::OnUpdateSolveAlgorithm(CCmdUI* pCmdUI) 
{
	CVRPDoc* pDoc = GetDocument();
	if (pDoc->m_Graph->GetNodeCount() == 0) pCmdUI->Enable(false);
	else pCmdUI->Enable(true);
}

void CVRPView::OnUpdateOnUpdateSolveAlgorithm(CCmdUI* pCmdUI) 
{
	CVRPDoc* pDoc = GetDocument();
	if (pDoc->m_Graph->GetNodeCount() == 0) pCmdUI->Enable(false);
	else pCmdUI->Enable(true);
	
}
