// Node.h: interface for the CNode class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_NODE_H__6E25D6D5_0355_4301_800F_19B7638DC53B__INCLUDED_)
#define AFX_NODE_H__6E25D6D5_0355_4301_800F_19B7638DC53B__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

const int nodeRadius = 5;

// definition of class CNode
class CNode : public CObject
{

DECLARE_SERIAL(CNode)

public:
	void SetInsertRouteId(int id);
	int GetInsertRouteId();
	int GetInsertIndex();
	void SetInsertIndex(int id);
	void SetInsertCost(float cost);
	float GetInsertCost();
	void SetState(int state);
	int GetState();
	void Serialize(CArchive& ar);
	void setSelected(BOOL value);
	BOOL getSelected();
	BOOL isLocation(CPoint point);
	void Show(CDC* pDC);
	
	int getId();
	void setId(int id);
	int getDemand();
	void setDemand(int demand);
	int getRouteId();
	void setRouteId(int id);
	float getAngle();
	void setAngle(float angle);

	CPoint getLocation();
	void setLocation(CPoint location);
	
	
	CNode();
	virtual ~CNode();

/*	const CNode& operator =(const CNode& node) {
	
		m_fAngle = node.m_fAngle;
		m_nId = node.m_nId;
		m_nDemand = node.m_nDemand;
		m_nRoute = node.m_nRoute;
		m_bSelected = node.m_bSelected;
		m_nPoint = node.m_nPoint;

		return *this;
	}*/

private:
	int m_nInsertRouteId;
	int m_nInsertIndex;
	float m_fInsertCost;
	int m_nState;
	float m_fAngle;
	int m_nId;
	int m_nDemand;
	int m_nRoute;
	BOOL m_bSelected;
	CPoint m_nPoint;
};

#endif // !defined(AFX_NODE_H__6E25D6D5_0355_4301_800F_19B7638DC53B__INCLUDED_)
