// SavingsAlgorithm.h: interface for the CSavingsAlgorithm class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SAVINGSALGORITHM_H__C486F546_028E_4FD6_9BF7_14C92E95C0EA__INCLUDED_)
#define AFX_SAVINGSALGORITHM_H__C486F546_028E_4FD6_9BF7_14C92E95C0EA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Algorithm.h"

struct sSaving {
    int f_NodeId;
    int s_NodeId;
	float value;
};

class CSavingsAlgorithm : public CAlgorithm  
{
public:
	void SolveParParameter(float lambda);
	void SolveSeqParameter(float lambda);
	void SolveParalel();
	void SolveSequntial();

	CSavingsAlgorithm();
	CSavingsAlgorithm(CVRPDoc* doc);
	virtual ~CSavingsAlgorithm();

private:
	void ComputeSavingsPar(float lambda);
	int FindPossibleSaving(CNode* f, CNode* s);
	void GenerateRoute(int id);
	int FindRouteToProces();
	void ProcesSavingsSequential();
	void ChooseMerge(CRoute* fr,CRoute* sr,int fn,int sn);
	void ProcesSavingsParalel();
	void SetSimpleRoutes();
	void ComputeSavings();
	sSaving* m_pSavingArray;
	
};

#endif // !defined(AFX_SAVINGSALGORITHM_H__C486F546_028E_4FD6_9BF7_14C92E95C0EA__INCLUDED_)


/*
public:
	void solveSeqOpt2();
	void solveSequentialProblem();
	void solveParalelProblem();
	

private:
	void Opt2(CRoute* route);
	float countSolutionCost(CRoute* route);
	int findRouteToProcess();
	void generateRoute(int routeId);
	void mergeRoutesFL(int f, int s);
	int findPossibleSaving(CNode* firstId, CNode* secondId);
	void procesSequentialSavings();
	void routesToEdges();
	void mergeRoutesFF(int f,int s);
	void mergeRoutesLL(int f,int s);
	void mergeRoutesLF(int f,int s);
	void mergeRoutes(int f,int s,int x,int y);
	
	

	void procesParalelSavings();

	void setSimpleRoute();
	void initData();

  */
