/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.ProxySettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbProxySelector
extends ProxySelector {
    private ProxySelector original = ProxySelector.getDefault();
    private static Logger log = Logger.getLogger(NbProxySelector.class.getName());
    private static Object useSystemProxies;

    public NbProxySelector() {
        log.fine("Override the original ProxySelector: " + this.original);
        log.fine("java.net.useSystemProxies has been set to " + NbProxySelector.useSystemProxies());
        log.fine("In launcher was detected netbeans.system_http_proxy: " + System.getProperty("netbeans.system_http_proxy", "N/A"));
        log.fine("In launcher was detected netbeans.system_socks_proxy: " + System.getProperty("netbeans.system_socks_proxy", "N/A"));
        ProxySettings.addPreferenceChangeListener(new ProxySettingsListener());
        this.copySettingsToSystem();
    }

    @Override
    public List<Proxy> select(URI uRI) {
        List<Object> list = new ArrayList();
        int n = ProxySettings.getProxyType();
        if (0 == n) {
            list = Collections.singletonList(Proxy.NO_PROXY);
        } else if (1 == n) {
            if (NbProxySelector.useSystemProxies()) {
                list = this.original.select(uRI);
            } else {
                String string = uRI.getScheme();
                assert (string != null) : "Invalid scheme of uri " + uRI + ". Scheme cannot be null!";
                if (NbProxySelector.dontUseProxy(ProxySettings.SystemProxySettings.getNonProxyHosts(), uRI.getHost())) {
                    list.add(Proxy.NO_PROXY);
                }
                if (string.toLowerCase(Locale.US).startsWith("http")) {
                    String string2 = ProxySettings.SystemProxySettings.getHttpPort();
                    if (string2 != null && string2.length() > 0 && ProxySettings.SystemProxySettings.getHttpHost().length() > 0) {
                        int n2 = Integer.parseInt(string2);
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxySettings.SystemProxySettings.getHttpHost(), n2));
                        list.add(proxy);
                    }
                } else {
                    String string3 = ProxySettings.SystemProxySettings.getSocksPort();
                    String string4 = ProxySettings.SystemProxySettings.getSocksHost();
                    if (string3 != null && string3.length() > 0 && string4.length() > 0) {
                        int n3 = Integer.parseInt(string3);
                        Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string4, n3));
                        list.add(proxy);
                    }
                }
                list.addAll(this.original.select(uRI));
            }
        } else if (2 == n) {
            String string = uRI.getScheme();
            assert (string != null) : "Invalid scheme of uri " + uRI + ". Scheme cannot be null!";
            if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uRI.getHost())) {
                list.add(Proxy.NO_PROXY);
            }
            if (string.toLowerCase(Locale.US).startsWith("http")) {
                String string5 = ProxySettings.getHttpHost();
                String string6 = ProxySettings.getHttpPort();
                if (string6 != null && string6.length() > 0 && string5.length() > 0) {
                    int n4 = Integer.parseInt(string6);
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string5, n4));
                    list.add(proxy);
                } else {
                    log.info("Incomplete HTTP Proxy [" + string5 + "/" + string6 + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uRI + ". ");
                    log.finest("Fallback to the default ProxySelector which returns " + this.original.select(uRI));
                    list.addAll(this.original.select(uRI));
                }
            } else {
                String string7 = ProxySettings.getSocksPort();
                String string8 = ProxySettings.getSocksHost();
                if (string7 != null && string7.length() > 0 && string8.length() > 0) {
                    int n5 = Integer.parseInt(string7);
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string8, n5));
                    list.add(proxy);
                } else {
                    log.info("Incomplete SOCKS Server [" + string8 + "/" + string7 + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uRI + ". ");
                    log.finest("Fallback to the default ProxySelector which returns " + this.original.select(uRI));
                    list.addAll(this.original.select(uRI));
                }
            }
            list.add(Proxy.NO_PROXY);
        } else assert (false) : "Invalid proxy type: " + ProxySettings.getProxyType();
        log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + ", Use HTTP for all protocols: " + ProxySettings.useProxyAllProtocols() + "] returns " + list + " for URI " + uRI);
        return list;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        log.log(Level.INFO, "connectionFailed(" + uRI + ", " + socketAddress + ")", iOException);
    }

    private void copySettingsToSystem() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = ProxySettings.getProxyType();
        if (0 == n) {
            string = null;
            string2 = null;
            string6 = null;
            string7 = null;
            string3 = null;
            string4 = null;
            string5 = null;
        } else if (1 == n) {
            string = ProxySettings.SystemProxySettings.getHttpHost();
            string2 = ProxySettings.SystemProxySettings.getHttpPort();
            string6 = ProxySettings.SystemProxySettings.getHttpsHost();
            string7 = ProxySettings.SystemProxySettings.getHttpsPort();
            string3 = ProxySettings.SystemProxySettings.getNonProxyHosts();
            string4 = ProxySettings.SystemProxySettings.getSocksHost();
            string5 = ProxySettings.SystemProxySettings.getSocksPort();
        } else if (2 == n) {
            string = ProxySettings.getHttpHost();
            string2 = ProxySettings.getHttpPort();
            string6 = ProxySettings.getHttpsHost();
            string7 = ProxySettings.getHttpsPort();
            string3 = ProxySettings.getNonProxyHosts();
            string4 = ProxySettings.getSocksHost();
            string5 = ProxySettings.getSocksPort();
        } else assert (false) : "Invalid proxy type: " + n;
        this.setOrClearProperty("http.proxyHost", string, false);
        this.setOrClearProperty("http.proxyPort", string2, true);
        this.setOrClearProperty("http.nonProxyHosts", string3, false);
        this.setOrClearProperty("https.proxyHost", string6, false);
        this.setOrClearProperty("https.proxyPort", string7, true);
        this.setOrClearProperty("https.nonProxyHosts", string3, false);
        this.setOrClearProperty("socksProxyHost", string4, false);
        this.setOrClearProperty("socksProxyPort", string5, true);
        log.fine("Set System's http.proxyHost/Port/NonProxyHost to " + string + "/" + string2 + "/" + string3);
        log.fine("Set System's https.proxyHost/Port to " + string6 + "/" + string7);
        log.fine("Set System's socksProxyHost/Port to " + string4 + "/" + string5);
    }

    private void setOrClearProperty(String string, String string2, boolean bl) {
        assert (string != null);
        if (string2 == null || string2.length() == 0) {
            System.clearProperty(string);
        } else {
            if (bl) {
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    log.log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
                }
            }
            System.setProperty(string, string2);
        }
    }

    static boolean dontUseProxy(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (NbProxySelector.dontUseIp(string, string2)) {
            return true;
        }
        return NbProxySelector.dontUseHostName(string, string2);
    }

    private static boolean dontUseHostName(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("*");
            if (n == -1) {
                bl = string3.equals(string2);
                if (!bl) continue;
                log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + string2 + " found in nonProxyHosts: " + string);
                continue;
            }
            String string4 = string3.substring(0, n - 1 < 0 ? 0 : n - 1);
            String string5 = string3.substring(n + 1 > string3.length() ? string3.length() : n + 1);
            bl = string2.startsWith(string4) && string2.endsWith(string5);
            if (!bl) continue;
            log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + string2 + " found in nonProxyHosts: " + string);
        }
        return bl;
    }

    private static boolean dontUseIp(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        String string3 = null;
        try {
            string3 = InetAddress.getByName(string2).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            log.log(Level.FINE, unknownHostException.getLocalizedMessage(), unknownHostException);
        }
        if (string3 == null) {
            return false;
        }
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf("*");
            if (n == -1) {
                bl = string4.equals(string3);
                if (!bl) continue;
                log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host's IP " + string3 + " found in nonProxyHosts: " + string);
                continue;
            }
            try {
                bl = Pattern.matches(string4, string3);
                if (!bl) continue;
                log.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host's IP" + string3 + " found in nonProxyHosts: " + string);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        return bl;
    }

    static boolean useSystemProxies() {
        if (useSystemProxies == null) {
            try {
                Class<?> clazz = Class.forName("sun.net.NetProperties");
                Method method = clazz.getMethod("getBoolean", String.class);
                useSystemProxies = method.invoke(null, "java.net.useSystemProxies");
            }
            catch (Exception exception) {
                log.log(Level.FINEST, "Cannot get value of java.net.useSystemProxies bacause " + exception.getMessage(), exception);
            }
        }
        return useSystemProxies != null && "true".equalsIgnoreCase(useSystemProxies.toString());
    }

    private class ProxySettingsListener
    implements PreferenceChangeListener {
        private ProxySettingsListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey().startsWith("proxy") || preferenceChangeEvent.getKey().startsWith("useProxy")) {
                NbProxySelector.this.copySettingsToSystem();
            }
        }
    }
}

