/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class FloatingWindowTransparencyManager {
    private static FloatingWindowTransparencyManager theInstance;
    private PropertyChangeListener topComponentRegistryListener;

    private FloatingWindowTransparencyManager() {
    }

    public static synchronized FloatingWindowTransparencyManager getDefault() {
        if (null == theInstance) {
            theInstance = new FloatingWindowTransparencyManager();
        }
        return theInstance;
    }

    public void start() {
        if (!NativeWindowSystem.getDefault().isWindowAlphaSupported()) {
            return;
        }
        if (null == this.topComponentRegistryListener) {
            this.topComponentRegistryListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FloatingWindowTransparencyManager.this.toggleFloatingWindowTransparency();
                }
            };
            TopComponent.getRegistry().addPropertyChangeListener(this.topComponentRegistryListener);
        }
    }

    public void stop() {
        if (null != this.topComponentRegistryListener) {
            TopComponent.getRegistry().removePropertyChangeListener(this.topComponentRegistryListener);
            this.topComponentRegistryListener = null;
        }
    }

    public void update() {
        this.toggleFloatingWindowTransparency();
    }

    protected void toggleFloatingWindowTransparency() {
        if (!NativeWindowSystem.getDefault().isWindowAlphaSupported()) {
            return;
        }
        if (WinSysPrefs.HANDLER.getBoolean("transparency.floating", true)) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (null != topComponent) {
                Object object;
                final WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
                ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
                if (null != modeImpl && modeImpl.getState() == 1 && modeImpl.getKind() != 1 && null != (object = SwingUtilities.windowForComponent((Component)topComponent))) {
                    NativeWindowSystem.getDefault().setWindowAlpha((Window)object, 1.0f);
                }
                object = new Runnable(){

                    public void run() {
                        if (!SwingUtilities.isEventDispatchThread()) {
                            SwingUtilities.invokeLater(this);
                            return;
                        }
                        TopComponent topComponent = TopComponent.getRegistry().getActivated();
                        if (null == topComponent) {
                            return;
                        }
                        ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
                        FloatingWindowTransparencyManager.this.makeFloatingWindowsTransparent(modeImpl);
                    }
                };
                RequestProcessor.getDefault().post((Runnable)object, WinSysPrefs.HANDLER.getInt("transparency.floating.timeout", 1000));
            }
        } else {
            this.turnTransparencyOff();
        }
    }

    private void turnTransparencyOff() {
        NativeWindowSystem nativeWindowSystem = NativeWindowSystem.getDefault();
        for (ModeImpl modeImpl : WindowManagerImpl.getInstance().getModes()) {
            Window window;
            TopComponent topComponent;
            if (modeImpl.getState() != 1 || modeImpl.getKind() == 1 || null == (topComponent = modeImpl.getSelectedTopComponent()) || null == (window = SwingUtilities.windowForComponent((Component)topComponent))) continue;
            nativeWindowSystem.setWindowAlpha(window, 1.0f);
        }
    }

    private void makeFloatingWindowsTransparent(ModeImpl modeImpl) {
        float f = WinSysPrefs.HANDLER.getFloat("transparency.floating.alpha", 0.5f);
        NativeWindowSystem nativeWindowSystem = NativeWindowSystem.getDefault();
        for (ModeImpl modeImpl2 : WindowManagerImpl.getInstance().getModes()) {
            Window window;
            TopComponent topComponent;
            if (modeImpl2.getState() != 1 || modeImpl2.equals(modeImpl) || modeImpl2.getKind() == 1 || null == (topComponent = modeImpl2.getSelectedTopComponent()) || null == (window = SwingUtilities.windowForComponent((Component)topComponent))) continue;
            nativeWindowSystem.setWindowAlpha(window, f);
        }
    }
}

