/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ClusterCenterWidgetClickAction;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.DeleteClusterCenterAction;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.kmeansalgorithm.KMeansAlgorithm;
import org.tpo.visminerapi.algorithm.Algorithm;

public abstract class AbstractClusterCenterWidget
extends LabelWidget
implements MoveProvider,
PropertyChangeListener,
PopupMenuProvider {
    protected ClusterCenter clusterCenter;
    protected ScatterPlot2DSettings scatterPlot2DSettings;
    protected Double xCoord;
    protected Double yCoord;
    protected Scene scene;

    public AbstractClusterCenterWidget(Scene aScene, ScatterPlot2DSettings aScatterPlot2DSettings, ClusterCenter aClusterCenter) {
        super(aScene, aClusterCenter.getClusterName());
        this.clusterCenter = aClusterCenter;
        this.clusterCenter.addPropertyChangeListener((PropertyChangeListener)this);
        this.scatterPlot2DSettings = aScatterPlot2DSettings;
        this.scene = aScene;
        this.initFromClusterCenter();
        KMeansAlgorithm theKMeansAlgorithm = this.clusterCenter.getKMeansSettings().getKMeansAlgorithm();
        if (Algorithm.AlgorithmState.CONFIGURING.equals((Object)theKMeansAlgorithm.getAlgorithmState())) {
            this.getActions().addAction(aScene.createWidgetHoverAction());
            this.getActions().addAction((WidgetAction)new ClusterCenterWidgetClickAction(aClusterCenter, this.scatterPlot2DSettings, this));
            this.getActions().addAction(ActionFactory.createMoveAction(null, (MoveProvider)this));
            this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        }
        this.setColorAccordingToCenterState();
    }

    public void movementStarted(Widget arg0) {
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getPreferredLocation();
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        this.setColorAccordingToCenterState();
    }

    protected void setColorAccordingToCenterState() {
        if (this.clusterCenter.isHovered()) {
            this.setBackground(Color.GREEN);
        } else {
            this.setBackground(Color.WHITE);
        }
        if (this.clusterCenter.isSelected()) {
            this.setBorder(new LineBorder(Color.BLUE, 4));
        } else {
            this.setBorder(new LineBorder(Color.BLACK, 1));
        }
        this.scene.validate();
    }

    protected void notifyStateChanged(ObjectState anOldState, ObjectState aNewState) {
        super.notifyStateChanged(anOldState, aNewState);
        if (!anOldState.isHovered() && aNewState.isHovered()) {
            this.clusterCenter.setHovered(true);
        }
        if (anOldState.isHovered() && !aNewState.isHovered()) {
            this.clusterCenter.setHovered(false);
        }
    }

    protected abstract void initFromClusterCenter();

    public JPopupMenu getPopupMenu(Widget aWidget, Point aPoint) {
        JPopupMenu theMenu = new JPopupMenu();
        theMenu.add(new DeleteClusterCenterAction(this.clusterCenter));
        theMenu.setLocation(aPoint);
        return theMenu;
    }
}

