/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.tpo.applicationframework.logging.ApplicationLogger;

public class ArrowWidget
extends Widget {
    public static Color STANDARD_COLOR = Color.BLACK;
    public static Color SELECTED_COLOR = Color.BLUE;
    public static int CONTROL_POINT_SIZE = 4;
    public static int WIDGET_DELTA = 5;
    public static int POINT_CIRCLE_SIZE = 3;
    private Point fromPoint;
    private Point toPoint;
    private Point drawFromPoint;
    private Point drawToPoint;
    private boolean paintStartPoint;
    private boolean selected;

    public ArrowWidget(Scene aScene, boolean aPaintStartPointFlag) {
        super(aScene);
        this.paintStartPoint = aPaintStartPointFlag;
        this.getActions().addAction((WidgetAction)new ArrowEditAction(this));
    }

    protected void paintWidget() {
        super.paintWidget();
        if (this.fromPoint != null && this.toPoint != null) {
            Graphics2D theGraphics = this.getGraphics();
            theGraphics.setStroke(new BasicStroke(2.0f));
            theGraphics.setPaint(this.getArrowColor());
            theGraphics.drawLine(this.convertSceneToLocal((Point)this.fromPoint).x, this.convertSceneToLocal((Point)this.fromPoint).y, this.convertSceneToLocal((Point)this.toPoint).x, this.convertSceneToLocal((Point)this.toPoint).y);
            if (this.paintStartPoint) {
                theGraphics.drawOval(this.convertSceneToLocal((Point)this.fromPoint).x - POINT_CIRCLE_SIZE, this.convertSceneToLocal((Point)this.fromPoint).y - POINT_CIRCLE_SIZE, 2 * POINT_CIRCLE_SIZE, 2 * POINT_CIRCLE_SIZE);
            }
            theGraphics.setStroke(new BasicStroke(1.0f));
        }
    }

    public void setFromPoint(Point fromPoint) {
        this.fromPoint = fromPoint;
        fromPoint.setLocation(this.convertSceneToLocal(fromPoint));
    }

    public void setToPoint(Point toPoint) {
        this.toPoint = toPoint;
        this.computeBounds();
    }

    public Point getFromPoint() {
        return this.fromPoint;
    }

    public Point getToPoint() {
        return this.toPoint;
    }

    private void computeBounds() {
        this.setPreferredLocation(this.fromPoint);
        int w = this.toPoint.x - this.fromPoint.x;
        int h = this.toPoint.y - this.fromPoint.y;
        int theXModif = 1;
        int theYModif = 1;
        if (w < 0) {
            theXModif = -1;
        }
        if (h < 0) {
            theYModif = -1;
        }
        this.setPreferredLocation(new Point(this.getPreferredLocation().x - theXModif * WIDGET_DELTA, this.getPreferredLocation().y - theYModif * WIDGET_DELTA));
        this.setPreferredBounds(new Rectangle((w += theXModif * 2 * WIDGET_DELTA) >= 0 ? 0 : w, h >= 0 ? 0 : (h += theYModif * 2 * WIDGET_DELTA), w >= 0 ? w : -w, h >= 0 ? h : -h));
    }

    public void setSelected(boolean aSelected) {
        this.selected = aSelected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Color getArrowColor() {
        if (this.isSelected()) {
            return SELECTED_COLOR;
        }
        return STANDARD_COLOR;
    }

    private class ArrowEditAction
    extends WidgetAction.Adapter {
        ArrowWidget arrowWidget;

        public ArrowEditAction(ArrowWidget anArrowWidget) {
            this.arrowWidget = anArrowWidget;
        }

        public WidgetAction.State mouseMoved(Widget arg0, WidgetAction.WidgetMouseEvent arg1) {
            return super.mouseMoved(arg0, arg1);
        }

        public WidgetAction.State mouseClicked(Widget aWidget, WidgetAction.WidgetMouseEvent aMouseEvent) {
            ApplicationLogger.logInfo(ArrowEditAction.class, (String)("Widget clicked: " + aWidget.getToolTipText()), null);
            return super.mouseClicked(aWidget, aMouseEvent);
        }
    }
}

