/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.AbstractClusterCenterWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ClusterCenterPointWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.visminerbase.VisMinerApplication;

public class ClusterCenterLineWidget
extends AbstractClusterCenterWidget {
    private boolean horizontal;

    public ClusterCenterLineWidget(Scene aScene, ScatterPlot2DSettings aScatterPlot2DSettings, ClusterCenter aClusterCenter) {
        super(aScene, aScatterPlot2DSettings, aClusterCenter);
    }

    protected void initFromClusterCenter() {
        ApplicationLogger.logInfo(ClusterCenterPointWidget.class, (String)"Initializing ClusterCenterWidget");
        if (this.clusterCenter == null) {
            return;
        }
        this.xCoord = this.clusterCenter.getCoordinateForDimension(this.scatterPlot2DSettings.getXDimension());
        this.yCoord = this.clusterCenter.getCoordinateForDimension(this.scatterPlot2DSettings.getYDimension());
        double theXCoord = 0.0;
        double theYCoord = 0.0;
        double theWidth = 0.0;
        double theHeight = 0.0;
        this.setOpaque(true);
        this.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.9f));
        Border theBorder = BorderFactory.createLineBorder(Color.BLACK, 1);
        this.setBorder(theBorder);
        this.setForeground(Color.BLACK);
        if (this.xCoord != null) {
            theXCoord = this.xCoord * (double)this.scatterPlot2DSettings.getGraphWidth();
            theYCoord = 0.0;
            theWidth = 18.0;
            theHeight = this.scatterPlot2DSettings.getGraphHeight();
            this.setPreferredSize(new Dimension((int)theWidth, (int)theHeight));
            this.horizontal = false;
        } else {
            theYCoord = this.yCoord * (double)this.scatterPlot2DSettings.getGraphHeight();
            theXCoord = 0.0;
            theHeight = 18.0;
            theWidth = this.scatterPlot2DSettings.getGraphWidth();
            this.setPreferredSize(new Dimension((int)theWidth, (int)theHeight));
            this.horizontal = true;
        }
        this.setPreferredLocation(new Point((int)theXCoord, (int)theYCoord));
    }

    public void movementFinished(Widget widget) {
        ApplicationLogger.logInfo(ClusterCenterPointWidget.class, (String)"Updating cluster center coordinates!");
        if (!this.horizontal) {
            this.clusterCenter.setCoordinateForDimension(this.scatterPlot2DSettings.getXDimension(), Double.valueOf(this.getPreferredLocation().getX() / (double)this.scatterPlot2DSettings.getGraphWidth()));
        } else {
            this.clusterCenter.setCoordinateForDimension(this.scatterPlot2DSettings.getYDimension(), Double.valueOf(this.getPreferredLocation().getY() / (double)this.scatterPlot2DSettings.getGraphHeight()));
        }
        VisMinerApplication.getInstance().repaintAllVisualization();
    }

    public void setNewLocation(Widget widget, Point location) {
        if (this.horizontal) {
            widget.setPreferredLocation(new Point(0, (int)location.getY()));
        } else {
            widget.setPreferredLocation(new Point((int)location.getX(), 0));
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }
}

