/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.AbstractClusterCenterWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.visminerbase.VisMinerApplication;

public class ClusterCenterPointWidget
extends AbstractClusterCenterWidget {
    public ClusterCenterPointWidget(Scene aScene, ScatterPlot2DSettings aScatterPlot2DSettings, ClusterCenter aClusterCenter) {
        super(aScene, aScatterPlot2DSettings, aClusterCenter);
    }

    protected void initFromClusterCenter() {
        if (this.clusterCenter == null) {
            return;
        }
        this.xCoord = this.clusterCenter.getCoordinateForDimension(this.scatterPlot2DSettings.getXDimension());
        this.yCoord = this.clusterCenter.getCoordinateForDimension(this.scatterPlot2DSettings.getYDimension());
        double theXCoord = this.xCoord * (double)this.scatterPlot2DSettings.getGraphWidth();
        double theYCoord = this.yCoord * (double)this.scatterPlot2DSettings.getGraphHeight();
        int pointX = (int)Math.round(theXCoord);
        int pointY = (int)Math.round(theYCoord);
        this.setPreferredLocation(new Point(pointX, pointY));
        this.setOpaque(true);
        this.setColorAccordingToCenterState();
        Border theBorder = BorderFactory.createLineBorder(Color.BLACK, 1);
        this.setBorder(theBorder);
        this.setForeground(Color.BLACK);
    }

    private void setupLineWidget() {
        double theXCoord = 0.0;
        double theYCoord = 0.0;
        double theWidth = 0.0;
        double theHeight = 0.0;
        if (this.xCoord != null) {
            theXCoord = this.xCoord * (double)this.scatterPlot2DSettings.getGraphWidth();
            theYCoord = 0.0;
            theWidth = 8.0;
            theHeight = this.scatterPlot2DSettings.getGraphHeight();
        } else {
            theYCoord = this.yCoord * (double)this.scatterPlot2DSettings.getGraphHeight();
            theXCoord = 0.0;
            theWidth = this.scatterPlot2DSettings.getGraphWidth();
            theHeight = 8.0;
        }
        this.setPreferredLocation(new Point((int)theXCoord, (int)theYCoord));
        this.setPreferredSize(new Dimension((int)theWidth, (int)theHeight));
    }

    public void movementFinished(Widget widget) {
        ApplicationLogger.logInfo(ClusterCenterPointWidget.class, (String)"Updating cluster center coordinates!");
        this.clusterCenter.setCoordinateForDimension(this.scatterPlot2DSettings.getXDimension(), Double.valueOf(this.getPreferredLocation().getX() / (double)this.scatterPlot2DSettings.getGraphWidth()));
        this.clusterCenter.setCoordinateForDimension(this.scatterPlot2DSettings.getYDimension(), Double.valueOf(this.getPreferredLocation().getY() / (double)this.scatterPlot2DSettings.getGraphHeight()));
        VisMinerApplication.getInstance().repaintAllVisualization();
    }

    public void setNewLocation(Widget widget, Point location) {
        widget.setPreferredLocation(location);
    }
}

