/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.AbstractClusterCenterWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ClusterCenterLineWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.visminerbase.VisMinerApplication;

public class ClusterCenterWidgetClickAction
extends WidgetAction.Adapter {
    private ClusterCenter clusterCenter;
    private ScatterPlot2DSettings scatterPlot2DSettings;
    private AbstractClusterCenterWidget parentWidget;

    public ClusterCenterWidgetClickAction(ClusterCenter aClusterCenter, ScatterPlot2DSettings aSettings, AbstractClusterCenterWidget aParentWidget) {
        this.clusterCenter = aClusterCenter;
        this.scatterPlot2DSettings = aSettings;
        this.parentWidget = aParentWidget;
    }

    public WidgetAction.State mouseClicked(Widget aWidget, WidgetAction.WidgetMouseEvent aMouseEvent) {
        ApplicationLogger.logInfo(ClusterCenterWidgetClickAction.class, (String)"Cluster center clicked");
        if (aMouseEvent.getClickCount() == 1) {
            ApplicationLogger.logInfo(ClusterCenterWidgetClickAction.class, (String)("Selecting cluster center: " + this.clusterCenter));
            this.clusterCenter.getKMeansSettings().selectClusterCenter(this.clusterCenter);
            return WidgetAction.State.CONSUMED;
        }
        if (aMouseEvent.getClickCount() > 1 && this.parentWidget instanceof ClusterCenterLineWidget) {
            ApplicationLogger.logInfo(ClusterCenterWidgetClickAction.class, (String)"Double clicked on cluster center line widget");
            ClusterCenterLineWidget theLineWidget = (ClusterCenterLineWidget)this.parentWidget;
            if (theLineWidget.isHorizontal()) {
                ApplicationLogger.logInfo(ClusterCenterWidgetClickAction.class, (String)"Horizontal line widget was double cliked!");
                this.clusterCenter.setCoordinateForDimension(this.scatterPlot2DSettings.getXDimension(), Double.valueOf(aMouseEvent.getPoint().getX() / (double)this.scatterPlot2DSettings.getGraphWidth()));
            } else {
                ApplicationLogger.logInfo(ClusterCenterWidgetClickAction.class, (String)"Vertical line widget was double cliked!");
                this.clusterCenter.setCoordinateForDimension(this.scatterPlot2DSettings.getYDimension(), Double.valueOf(aMouseEvent.getPoint().getY() / (double)this.scatterPlot2DSettings.getGraphHeight()));
            }
            VisMinerApplication.getInstance().repaintAllVisualization();
        }
        return super.mouseClicked(aWidget, aMouseEvent);
    }
}

