/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.jdom.Content;
import org.jdom.Element;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.NbBundle;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DTopComponent;
import org.tpo.graphvisualizations.tools.SceneToPngExporter;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerbase.visualization.AbstractVisMinerVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScatterPlot2D
extends AbstractVisMinerVisualization {
    public static final String SCATTER_PLOT_2D_XML_NAME = "ScatterPlot";
    public static final String X_DIM_NAME_ATTR_NAME = "xDimension";
    public static final String Y_DIM_NAME_ATTR_NAME = "yDimension";
    private ScatterPlot2DSettings settings;
    private ScatterPlot2DTopComponent topComponent;

    public void showVisualization() {
        this.settings.setScatterPlot2D(this);
        this.topComponent = new ScatterPlot2DTopComponent(this.settings);
        this.topComponent.open();
        this.topComponent.requestActive();
        this.registerVisualizationInProject();
    }

    public void showVisualization(ScatterPlot2DSettings aSettings) {
        this.settings = aSettings;
        this.settings.setScatterPlot2D(this);
        this.logInfo("Displaying ScatterPlot2D using given settings.");
        this.topComponent = new ScatterPlot2DTopComponent(this.settings);
        this.topComponent.open();
        this.topComponent.requestActive();
        this.registerVisualizationInProject();
    }

    public DataSet getDataSet() {
        return this.settings.getDataSet();
    }

    public void makeActive() {
        if (this.topComponent != null) {
            this.logInfo("Making top component active.");
            this.topComponent.requestActive();
        }
    }

    public String getVisualizationName() {
        return NbBundle.getMessage(ScatterPlot2D.class, (String)"ScatterPlot2D_NodeName", (Object[])new Object[]{this.settings.getXDimension().getDimensionName(), this.settings.getYDimension().getDimensionName()});
    }

    public void closeVisualization() {
        this.topComponent.close();
    }

    public void setSettings(ScatterPlot2DSettings settings) {
        this.settings = settings;
    }

    public void repaint() {
        this.topComponent.repaintGraph();
    }

    public ScatterPlot2DSettings getSettings() {
        return this.settings;
    }

    public void saveToElement(Element anElement) {
        Element theElement = new Element(SCATTER_PLOT_2D_XML_NAME);
        theElement.setAttribute(X_DIM_NAME_ATTR_NAME, this.getSettings().getXDimension().getDimensionName());
        theElement.setAttribute(Y_DIM_NAME_ATTR_NAME, this.getSettings().getYDimension().getDimensionName());
        anElement.addContent((Content)theElement);
    }

    public void exportToFile() {
        SceneToPngExporter.exportSceneToPng((Scene)this.topComponent.getScene());
    }

    public List<Action> getAdditionalAction() {
        return new ArrayList<Action>();
    }
}

