/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import org.jdom.Element;
import org.openide.util.NbBundle;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2D;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.session.XMLSessionBuilder;
import org.tpo.visminerapi.exceptions.SessionBuilderException;
import org.tpo.visminerapi.visualization.Visualization;
import org.tpo.visminerapi.visualization.VisualizationFactory;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.ui.VisMinerUI;

public class ScatterPlot2DFactory
extends VisMinerObject
implements VisualizationFactory {
    private ScatterPlot2DSettings settings;

    public String getVisualizationName() {
        return NbBundle.getMessage(ScatterPlot2D.class, (String)"ScatterPlot2D_Name");
    }

    public String getVisualizationDescription() {
        return NbBundle.getMessage(ScatterPlot2D.class, (String)"ScatterPlot2D_Description");
    }

    public Visualization createVisualization() {
        if (!VisMinerApplication.getInstance().isInitialized()) {
            VisMinerUI.showInitProjectMessage();
            return null;
        }
        return null;
    }

    public Visualization createVisualizationFromElement(Element anElement, XMLSessionBuilder aSessionBuilder) throws SessionBuilderException {
        DataSet thePhysicalDataSet = VisMinerApplication.getInstance().getPhysicalDataSet();
        String theXDimName = anElement.getAttributeValue("xDimension");
        String theYDimName = anElement.getAttributeValue("yDimension");
        if (theXDimName == null || theYDimName == null) {
            throw new SessionBuilderException("Missing X or Y data dimension name for ScatterPlot 2D visualization.");
        }
        DataDimension theXDataDimension = thePhysicalDataSet.getDimensionForName(theXDimName);
        DataDimension theYDataDimension = thePhysicalDataSet.getDimensionForName(theYDimName);
        if (theXDataDimension == null || theYDataDimension == null) {
            throw new SessionBuilderException("X or Y data dimension not found for ScatterPlot 2D visualization.");
        }
        this.settings = new ScatterPlot2DSettings();
        this.settings.setDataSet(thePhysicalDataSet);
        this.settings.setXDimension((DataDimension<Double>)theXDataDimension);
        this.settings.setYDimension((DataDimension<Double>)theYDataDimension);
        ScatterPlot2D theScatterPlot2D = new ScatterPlot2D();
        theScatterPlot2D.setSettings(this.settings);
        return theScatterPlot2D;
    }

    public boolean canCreateAlgortihmFromElement(Element anElement) {
        return "ScatterPlot".equals(anElement.getName());
    }
}

