/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.api.visual.widget.general.IconNodeWidget;
import org.openide.windows.TopComponent;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ArrowWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ClusterCenterLineWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ClusterCenterPointWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.DeleteSeparatingAxisAction;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.Scatterplot2DRectangularDataSelectionAction;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.Scatterplot2DRectangularSelectionProvider;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.SelectionRectangleAreaWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.SeperatingAxisSelectionAction;
import org.tpo.kmeansalgorithm.ClusterCenter;
import org.tpo.kmeansalgorithm.KMeansAlgorithm;
import org.tpo.kmeansalgorithm.KMeansSettings;
import org.tpo.kmeansalgorithm.SeparatingAxis;
import org.tpo.visminerapi.algorithm.Algorithm;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerapi.datastorage.data.Filter;
import org.tpo.visminerapi.selection.DataSelection;
import org.tpo.visminerapi.visualization.Visualization;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.actions.visualization.ExportVisualizationToFileAction;
import org.tpo.visminerbase.selection.RectangularDataSelection;

public class ScatterPlot2DTopComponent
extends TopComponent
implements Runnable,
PropertyChangeListener,
PopupMenuProvider {
    public static final double AXIS_MIN_DIST = 0.01;
    private ObjectScene scene = new ObjectScene();
    private JComponent sceneView = this.scene.createView();
    private JScrollPane scenePanel = new JScrollPane(this.sceneView);
    private ScatterPlot2DSettings settings;
    private IconNodeWidget graphWidget;
    private RectangularDataSelection rectangularDataSelection;
    private KMeansAlgorithm kMeansAlgorithm;
    private List<Widget> selectionAreaWidgets = new ArrayList<Widget>();
    private List<Widget> clusterCenterWidgets = new ArrayList<Widget>();
    private List<Widget> separatingAxisWidgets = new ArrayList<Widget>();
    private LayerWidget selectionLayerWidget;
    private LayerWidget selectionLayer;
    private LayerWidget sceneLayerWidget;
    private Image graphImage;
    private DataSelection dataSelection;
    private DataSet dataSet;
    private Filter filter;
    private AffineTransform affineTransform;
    private Integer[] xDatavalueCoordCache;
    private Integer[] yDatavalueCoordCache;
    private SeparatingAxis selectedAxis;
    private Map<SeparatingAxis, ArrowWidget> axisArrowMap = new HashMap<SeparatingAxis, ArrowWidget>();
    Scatterplot2DRectangularDataSelectionAction selectionAction;
    KMeansClusterCenterSelectionAction pointClickAction;
    SeperatingAxisSelectionAction seperatingAxisSelectionAction;
    ArrowSelectAction arrowSelectAction;
    public static NumberFormat coordFormatter = new DecimalFormat("0.00");

    public ScatterPlot2DTopComponent(ScatterPlot2DSettings aSettings) {
        this.settings = aSettings;
        this.setLayout(new BorderLayout());
        this.add(this.scenePanel, "Center");
        this.setName(this.settings.getScatterPlot2D().getVisualizationName());
        this.initScene();
        VisMinerApplication.getInstance().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public int getPersistenceType() {
        return 2;
    }

    private void initScene() {
        this.precomputeCoordinates();
        this.sceneLayerWidget = new LayerWidget((Scene)this.scene);
        this.selectionLayer = new LayerWidget((Scene)this.scene);
        this.selectionLayerWidget = new LayerWidget((Scene)this.scene);
        this.sceneLayerWidget.addChild((Widget)this.selectionLayer);
        this.sceneLayerWidget.addChild((Widget)this.selectionLayerWidget);
        this.selectionAction = new Scatterplot2DRectangularDataSelectionAction(ActionFactory.createDefaultRectangularSelectDecorator((Scene)this.scene), this.selectionLayer, new Scatterplot2DRectangularSelectionProvider(this.settings));
        this.pointClickAction = new KMeansClusterCenterSelectionAction();
        this.seperatingAxisSelectionAction = new SeperatingAxisSelectionAction(this.settings, this.scene, this.selectionLayerWidget);
        this.scene.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        this.updateSceneActions();
        this.graphWidget = new IconNodeWidget((Scene)this.scene);
        this.paintSceneToGraphWidget();
        this.sceneLayerWidget.addChild((Widget)this.graphWidget);
        this.scene.addChild((Widget)this.sceneLayerWidget);
        this.initSessionObjects();
        this.updateSceneActions();
        this.scene.getActions().addAction((WidgetAction)new PositionInfoAction());
    }

    private synchronized void updateSceneActions() {
        KMeansAlgorithm theKMeansAlgorithm;
        this.scene.getActions().removeAction((WidgetAction)this.selectionAction);
        this.scene.getActions().removeAction((WidgetAction)this.pointClickAction);
        this.scene.getActions().removeAction((WidgetAction)this.seperatingAxisSelectionAction);
        this.scene.getActions().removeAction((WidgetAction)this.arrowSelectAction);
        Filter theSelectedFilter = VisMinerApplication.getInstance().getSelectedFilter();
        DataSet theSelectedDataSet = VisMinerApplication.getInstance().getSelectedDataSet();
        ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)("updateSceneActions() - Selected Filter: " + theSelectedFilter));
        ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)("updateSceneActions() - Selected DataSet: " + theSelectedDataSet));
        if (theSelectedFilter != null && theSelectedFilter instanceof KMeansAlgorithm && Algorithm.AlgorithmState.CONFIGURING.equals((Object)(theKMeansAlgorithm = (KMeansAlgorithm)theSelectedFilter).getAlgorithmState())) {
            ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"Adding point selection action and separating axis selection action.");
            this.pointClickAction.setKMeansAlgorithm((KMeansAlgorithm)theSelectedFilter);
            this.scene.getActions().addAction((WidgetAction)this.pointClickAction);
            this.seperatingAxisSelectionAction.setKMeansAlgorithm((KMeansAlgorithm)theSelectedFilter);
            this.scene.getActions().addAction((WidgetAction)this.seperatingAxisSelectionAction);
            this.arrowSelectAction = new ArrowSelectAction(theKMeansAlgorithm.getKMeansSettings().getSeparatingAxises(), this.settings);
            this.scene.getActions().addAction((WidgetAction)this.arrowSelectAction);
        }
        if (theSelectedFilter == null && theSelectedDataSet != null) {
            ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"Adding selection action to scene.");
            this.scene.getActions().addAction((WidgetAction)this.selectionAction);
        }
    }

    private synchronized void paintPoint(int anIndex, Graphics2D aGraphics) {
        if (this.xDatavalueCoordCache[anIndex] != null && this.yDatavalueCoordCache[anIndex] != null) {
            aGraphics.translate(this.xDatavalueCoordCache[anIndex].floatValue(), this.yDatavalueCoordCache[anIndex].floatValue());
            aGraphics.setPaint(this.determinePointColor(anIndex));
            aGraphics.fill(this.settings.getPointShape());
            aGraphics.draw(this.settings.getPointShape());
            aGraphics.translate(-this.xDatavalueCoordCache[anIndex].floatValue(), -this.yDatavalueCoordCache[anIndex].floatValue());
        }
    }

    private synchronized Color determinePointColor(int anIndex) {
        Color theResult = Color.BLACK;
        if (this.filter != null) {
            theResult = this.filter.chooseDataRecordColor(anIndex);
        } else if (this.dataSelection != null && this.dataSelection.isDataValueInFilter(anIndex) && this.dataSet != null) {
            theResult = this.dataSet.isDataValueInDataSet(anIndex) ? this.settings.getPointInSelectionColor() : this.dataSet.chooseDataRecordColor(anIndex);
        } else if (this.dataSet != null) {
            theResult = this.dataSet.chooseDataRecordColor(anIndex);
        }
        return theResult;
    }

    protected void componentClosed() {
        this.settings.getScatterPlot2D().unregisterVisualizationInProject();
        super.componentClosed();
    }

    public void repaintGraph() {
        ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"repaintGraph() - Repainting graph ScaterPlot2D visualization.");
        this.paintSceneToGraphWidget();
    }

    public synchronized void precomputeCoordinates() {
        ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"Precomputing record coordinates.");
        int recCount = this.settings.getXDimension().getValues().size();
        this.xDatavalueCoordCache = new Integer[recCount];
        this.yDatavalueCoordCache = new Integer[recCount];
        for (int index = 0; index < recCount; ++index) {
            Double dXCoord = this.settings.getXDimension().getNormalizedValue(index);
            Double dYCoord = this.settings.getYDimension().getNormalizedValue(index);
            if (dXCoord == null || dYCoord == null) continue;
            this.xDatavalueCoordCache[index] = Math.round((float)this.settings.getGraphWidth() * dXCoord.floatValue());
            this.yDatavalueCoordCache[index] = Math.round((float)this.settings.getGraphHeight() * dYCoord.floatValue());
        }
    }

    public synchronized void paintSceneToGraphWidget() {
        ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"Repainting graph widget!");
        this.dataSelection = VisMinerApplication.getInstance().getCurrentDataSelection();
        this.dataSet = VisMinerApplication.getInstance().getSelectedDataSet();
        this.filter = VisMinerApplication.getInstance().getSelectedFilter();
        int recCount = this.settings.getXDimension().getValues().size();
        ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"paintSceneToGraphWidget() - Painting graph scene with {0} records.", (Object[])new Object[]{new Integer(recCount)});
        BufferedImage theSceneBuffImg = new BufferedImage(this.settings.getGraphWidth() + 10, this.settings.getGraphHeight() + 10, 2);
        Graphics2D theGraphics = theSceneBuffImg.createGraphics();
        this.affineTransform = theGraphics.getTransform();
        for (int index = 0; index < recCount; ++index) {
            this.paintPoint(index, theGraphics);
        }
        this.graphImage = Toolkit.getDefaultToolkit().createImage(theSceneBuffImg.getSource());
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.updateGraphWidget(this.graphImage);
        this.updateSceneActions();
        this.updateSceneAccordingToDataSelectionAndFilter();
    }

    public synchronized void updateGraphWidget(Image anImage) {
        this.graphWidget.setImage(anImage);
        this.repaint();
    }

    public void initSessionObjects() {
        if (VisMinerApplication.getInstance().getCurrentDataSelection() instanceof RectangularDataSelection) {
            this.rectangularDataSelection = (RectangularDataSelection)VisMinerApplication.getInstance().getCurrentDataSelection();
        }
        if (VisMinerApplication.getInstance().getSelectedFilter() instanceof KMeansAlgorithm) {
            ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"Adding KMeansAlgorithmWIdgets to graph widget");
            this.kMeansAlgorithm = (KMeansAlgorithm)VisMinerApplication.getInstance().getSelectedFilter();
            this.kMeansAlgorithm.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentSelection".equals(evt.getPropertyName())) {
            if (this.rectangularDataSelection != null) {
                this.rectangularDataSelection.removePropertyChangeListener((PropertyChangeListener)this);
                this.rectangularDataSelection = null;
            }
            if (VisMinerApplication.getInstance().getCurrentDataSelection() instanceof RectangularDataSelection) {
                this.rectangularDataSelection = (RectangularDataSelection)VisMinerApplication.getInstance().getCurrentDataSelection();
            }
            this.updateSceneAccordingToDataSelectionAndFilter();
        } else if ("selectedFilter".equals(evt.getPropertyName())) {
            if (this.rectangularDataSelection != null) {
                this.rectangularDataSelection.removePropertyChangeListener((PropertyChangeListener)this);
                this.rectangularDataSelection = null;
            }
            if (this.kMeansAlgorithm != null) {
                this.kMeansAlgorithm.removePropertyChangeListener((PropertyChangeListener)this);
                this.kMeansAlgorithm = null;
            }
            if (evt.getNewValue() != null) {
                if (evt.getNewValue() instanceof RectangularDataSelection && this.isSelectionCompatible((RectangularDataSelection)evt.getNewValue())) {
                    ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"Compatible selection found. Painting selection areas.");
                    this.rectangularDataSelection = (RectangularDataSelection)evt.getNewValue();
                    this.rectangularDataSelection.addPropertyChangeListener((PropertyChangeListener)this);
                }
                if (evt.getNewValue() instanceof KMeansAlgorithm) {
                    ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"Adding KMeansAlgorithmWIdgets to graph widget");
                    this.kMeansAlgorithm = (KMeansAlgorithm)evt.getNewValue();
                    this.kMeansAlgorithm.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            this.updateSceneAccordingToDataSelectionAndFilter();
        } else if ("RectAreaCount".equals(evt.getPropertyName()) || "propertyKMmeansSettings".equals(evt.getPropertyName())) {
            this.updateSceneAccordingToDataSelectionAndFilter();
        }
    }

    private boolean isSelectionCompatible(RectangularDataSelection aSelection) {
        return aSelection.getXDataDimension().equals(this.settings.getXDimension()) && aSelection.getYDataDimension().equals(this.settings.getYDimension());
    }

    private synchronized void updateSceneAccordingToDataSelectionAndFilter() {
        ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"updateSceneAccordingToDataSelectionAndFilter()");
        for (Widget eachWidget : this.selectionAreaWidgets) {
            this.sceneLayerWidget.removeChild(eachWidget);
        }
        this.selectionAreaWidgets.clear();
        for (Widget eachClusterCenterWidget : this.clusterCenterWidgets) {
            this.sceneLayerWidget.removeChild(eachClusterCenterWidget);
        }
        this.clusterCenterWidgets.clear();
        for (Widget eachSeparatingAxisWidget : this.separatingAxisWidgets) {
            this.sceneLayerWidget.removeChild(eachSeparatingAxisWidget);
        }
        this.separatingAxisWidgets.clear();
        if (this.rectangularDataSelection != null && this.rectangularDataSelection.getXDataDimension().equals(this.settings.getXDimension()) && this.rectangularDataSelection.getYDataDimension().equals(this.settings.getYDimension())) {
            for (int anIndex = 0; anIndex < this.rectangularDataSelection.getAreaRectangles().size(); ++anIndex) {
                SelectionRectangleAreaWidget theWidget = new SelectionRectangleAreaWidget((Scene)this.scene, this.rectangularDataSelection, anIndex, this.settings);
                ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)("Adding widget: " + (Object)((Object)theWidget)));
                this.sceneLayerWidget.addChild((Widget)theWidget);
                this.selectionAreaWidgets.add(theWidget);
            }
        }
        if (this.kMeansAlgorithm != null) {
            Widget theWidget;
            ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)"updateSceneAccordingToDataSelectionAndFilter() - Some KMeansAlgorithm is selected");
            KMeansSettings theKMeansSettings = this.kMeansAlgorithm.getKMeansSettings();
            this.axisArrowMap.clear();
            for (SeparatingAxis eachSeparatingAxis : theKMeansSettings.getSeparatingAxises()) {
                if (!eachSeparatingAxis.getXDataDimension().equals(this.settings.getXDimension()) || !eachSeparatingAxis.getYDataDimension().equals(this.settings.getYDimension())) continue;
                theWidget = this.createSeparatingAxisWidget(eachSeparatingAxis);
                this.sceneLayerWidget.addChild(theWidget);
                this.separatingAxisWidgets.add(theWidget);
                this.axisArrowMap.put(eachSeparatingAxis, (ArrowWidget)theWidget);
            }
            for (ClusterCenter eachClusterCenter : theKMeansSettings.getClusterCenters()) {
                theWidget = this.createClusterCenterWidget(eachClusterCenter);
                if (theWidget == null) continue;
                this.sceneLayerWidget.addChild(theWidget);
                this.clusterCenterWidgets.add(theWidget);
            }
        }
        this.scene.validate();
        this.scene.repaint();
        this.repaint();
    }

    private Widget createClusterCenterWidget(ClusterCenter aClusterCenter) {
        if (aClusterCenter.getCoordinateForDimension(this.settings.getXDimension()) != null && aClusterCenter.getCoordinateForDimension(this.settings.getYDimension()) != null) {
            return new ClusterCenterPointWidget((Scene)this.scene, this.settings, aClusterCenter);
        }
        if (aClusterCenter.getCoordinateForDimension(this.settings.getXDimension()) != null) {
            return new ClusterCenterLineWidget((Scene)this.scene, this.settings, aClusterCenter);
        }
        if (aClusterCenter.getCoordinateForDimension(this.settings.getYDimension()) != null) {
            return new ClusterCenterLineWidget((Scene)this.scene, this.settings, aClusterCenter);
        }
        return null;
    }

    private ArrowWidget createSeparatingAxisWidget(SeparatingAxis aSeparatingAxis) {
        ArrowWidget theArrowWidget = new ArrowWidget((Scene)this.scene, false);
        Line2D.Double theNormalizedLine = aSeparatingAxis.getNormalizedLine();
        theArrowWidget.setFromPoint(new Point((int)(theNormalizedLine.getX1() * (double)this.settings.getGraphWidth()), (int)(theNormalizedLine.getY1() * (double)this.settings.getGraphHeight())));
        theArrowWidget.setToPoint(new Point((int)(theNormalizedLine.getX2() * (double)this.settings.getGraphWidth()), (int)(theNormalizedLine.getY2() * (double)this.settings.getGraphHeight())));
        return theArrowWidget;
    }

    public ObjectScene getScene() {
        return this.scene;
    }

    public String getXValueForPosition(int anXCoord) {
        double normalizedValue = (double)anXCoord / (double)this.settings.getGraphWidth();
        if (normalizedValue < 0.0 || normalizedValue > 1.0) {
            return " ";
        }
        return coordFormatter.format(this.settings.getXDimension().getMinimalValue() + normalizedValue * (this.settings.getXDimension().getMaximalValue() - this.settings.getXDimension().getMinimalValue()));
    }

    public String getYValueForPosition(int anYCoord) {
        double normalizedValue = (double)anYCoord / (double)this.settings.getGraphHeight();
        if (normalizedValue < 0.0 || normalizedValue > 1.0) {
            return " ";
        }
        return coordFormatter.format(this.settings.getYDimension().getMinimalValue() + normalizedValue * (this.settings.getYDimension().getMaximalValue() - this.settings.getYDimension().getMinimalValue()));
    }

    public void setSelectedAxis(SeparatingAxis aSelectedAxis) {
        ArrowWidget theSelectedArrowWidget;
        if (this.selectedAxis != null && this.selectedAxis.equals(aSelectedAxis)) {
            return;
        }
        if (this.selectedAxis != null && (theSelectedArrowWidget = this.axisArrowMap.get(this.selectedAxis)) != null) {
            theSelectedArrowWidget.setSelected(false);
        }
        this.selectedAxis = aSelectedAxis;
        theSelectedArrowWidget = this.axisArrowMap.get(this.selectedAxis);
        if (theSelectedArrowWidget != null) {
            theSelectedArrowWidget.setSelected(true);
        }
    }

    public SeparatingAxis getSelectedAxis() {
        return this.selectedAxis;
    }

    public JPopupMenu getPopupMenu(Widget arg0, Point arg1) {
        JPopupMenu theMenu = new JPopupMenu();
        if (this.getSelectedAxis() != null) {
            theMenu.add(new DeleteSeparatingAxisAction(this.selectedAxis));
        } else {
            theMenu.add((Action)new ExportVisualizationToFileAction((Visualization)this.settings.getScatterPlot2D()));
        }
        return theMenu;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrowSelectAction
    extends WidgetAction.Adapter {
        List<SeparatingAxis> axisList;
        ScatterPlot2DSettings settings;

        public ArrowSelectAction(List<SeparatingAxis> anAxisList, ScatterPlot2DSettings aSettings) {
            this.axisList = anAxisList;
            this.settings = aSettings;
        }

        public WidgetAction.State mouseMoved(Widget aWidget, WidgetAction.WidgetMouseEvent anEvent) {
            Point theMousePoint = anEvent.getPoint();
            Point2D.Double theNorPoint = new Point2D.Double(theMousePoint.getX() / (double)this.settings.getGraphWidth(), theMousePoint.getY() / (double)this.settings.getGraphHeight());
            double theNearestDist = Double.MAX_VALUE;
            SeparatingAxis theNearestAxis = null;
            for (SeparatingAxis eachAxis : this.axisList) {
                Double theDistance = eachAxis.getNormalizedLine().ptSegDist(theNorPoint);
                if (!(theDistance < theNearestDist)) continue;
                theNearestDist = theDistance;
                theNearestAxis = eachAxis;
            }
            if (theNearestDist <= 0.01) {
                ScatterPlot2DTopComponent.this.setSelectedAxis(theNearestAxis);
            } else {
                ScatterPlot2DTopComponent.this.setSelectedAxis(null);
            }
            return super.mouseMoved(aWidget, anEvent);
        }

        public WidgetAction.State mouseClicked(Widget aWidget, WidgetAction.WidgetMouseEvent aMouseEvent) {
            return super.mouseClicked(aWidget, aMouseEvent);
        }
    }

    private class PositionInfoAction
    extends WidgetAction.Adapter {
        private PositionInfoAction() {
        }

        public WidgetAction.State mouseMoved(Widget aWidget, WidgetAction.WidgetMouseEvent anEvent) {
            StringBuffer theName = new StringBuffer();
            theName.append(ScatterPlot2DTopComponent.this.settings.getScatterPlot2D().getVisualizationName());
            theName.append("[");
            theName.append(ScatterPlot2DTopComponent.this.getXValueForPosition(anEvent.getPoint().x));
            theName.append(" : ");
            theName.append(ScatterPlot2DTopComponent.this.getYValueForPosition(anEvent.getPoint().y));
            theName.append("]");
            ScatterPlot2DTopComponent.this.setName(theName.toString());
            return super.mouseMoved(aWidget, anEvent);
        }
    }

    private class KMeansClusterCenterSelectionAction
    extends WidgetAction.Adapter {
        private KMeansAlgorithm kMeansAlgorithm;

        private KMeansClusterCenterSelectionAction() {
        }

        public void setKMeansAlgorithm(KMeansAlgorithm kMeansAlgorithm) {
            this.kMeansAlgorithm = kMeansAlgorithm;
        }

        public WidgetAction.State mouseClicked(Widget aWidget, WidgetAction.WidgetMouseEvent aMouseEvent) {
            if (aMouseEvent.getClickCount() == 1 && aMouseEvent.getButton() == 1) {
                ApplicationLogger.logInfo(KMeansClusterCenterSelectionAction.class, (String)"Scene clicked at point [{0},{1}]", (Object[])new Object[]{aMouseEvent.getPoint().getX(), aMouseEvent.getPoint().getY()});
                this.kMeansAlgorithm.pointClikced(ScatterPlot2DTopComponent.this.settings.getXDimension(), aMouseEvent.getPoint().getX() / (double)ScatterPlot2DTopComponent.this.settings.getGraphWidth(), ScatterPlot2DTopComponent.this.settings.getYDimension(), aMouseEvent.getPoint().getY() / (double)ScatterPlot2DTopComponent.this.settings.getGraphHeight());
            }
            return super.mouseClicked(aWidget, aMouseEvent);
        }
    }
}

