/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2D;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.visminerapi.common.VisMinerObject;
import org.tpo.visminerapi.selection.DataSelection;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.selection.RectangularDataSelection;

public class Scatterplot2DRectangularSelectionProvider
extends VisMinerObject
implements RectangularSelectProvider {
    private ScatterPlot2DSettings scatterPlot2DSettings;
    private ScatterPlot2D scatterPlot2D;

    public Scatterplot2DRectangularSelectionProvider(ScatterPlot2DSettings aScatterPlot2DSettings) {
        this.scatterPlot2DSettings = aScatterPlot2DSettings;
        this.scatterPlot2D = this.scatterPlot2DSettings.getScatterPlot2D();
    }

    public void performSelection(Rectangle aRectangle) {
        Double temp;
        this.logInfo("Perform rectangular selection for rectangle: " + aRectangle);
        Double theULX = new Double(aRectangle.getMinX() / (double)this.scatterPlot2DSettings.getGraphWidth());
        Double theULY = new Double(aRectangle.getMinY() / (double)this.scatterPlot2DSettings.getGraphHeight());
        Double theDRX = new Double(aRectangle.getMaxX() / (double)this.scatterPlot2DSettings.getGraphWidth());
        Double theDRY = new Double(aRectangle.getMaxY() / (double)this.scatterPlot2DSettings.getGraphHeight());
        if (theULX > theDRX) {
            temp = theULX;
            theULX = theDRX;
            theDRX = temp;
        }
        if (theULY > theDRY) {
            temp = theULY;
            theULY = theDRY;
            theDRY = temp;
        }
        Rectangle2D.Double theNormalizedRectangle = new Rectangle2D.Double(theULX, theULY, theDRX - theULX, theDRY - theULY);
        RectangularDataSelection theRectangularDataSelection = null;
        DataSelection theCurrentSelection = VisMinerApplication.getInstance().getCurrentDataSelection();
        if (theCurrentSelection != null && theCurrentSelection instanceof RectangularDataSelection && this.isSelectionCompatible((RectangularDataSelection)theCurrentSelection)) {
            this.logInfo("Existing rectangular selection is compatible and will be used.");
            theRectangularDataSelection = (RectangularDataSelection)theCurrentSelection;
        }
        if (theRectangularDataSelection == null) {
            this.logInfo("New rectangularDataSelection will be created.");
            theRectangularDataSelection = new RectangularDataSelection(this.scatterPlot2DSettings.getXDimension(), this.scatterPlot2DSettings.getYDimension());
        }
        theRectangularDataSelection.addRectangularAreaToSelection(theNormalizedRectangle, VisMinerApplication.getInstance().getCurrentSelectionOperator());
        VisMinerApplication.getInstance().setCurrentDataSelection(theRectangularDataSelection);
    }

    private boolean isSelectionCompatible(RectangularDataSelection aSelection) {
        return aSelection.getXDataDimension().equals(this.scatterPlot2D.getSettings().getXDimension()) && aSelection.getYDataDimension().equals(this.scatterPlot2D.getSettings().getYDimension());
    }
}

