/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.ResizeControlPointResolver;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ChangeAreaTypeAction;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.DeleteRectangularAreaAction;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DTopComponent;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.SelectionRectangleWidgetResizeAction;
import org.tpo.visminerapi.selection.DataSelection;
import org.tpo.visminerbase.VisMinerApplication;
import org.tpo.visminerbase.selection.RectangularDataSelection;

public class SelectionRectangleAreaWidget
extends Widget
implements ResizeControlPointResolver,
MoveProvider,
PopupMenuProvider {
    public static int CONTROL_POINT_SIZE = 10;
    public static Dimension CONTROL_POINT_DIMENSION = new Dimension(CONTROL_POINT_SIZE, CONTROL_POINT_SIZE);
    public static Color CONTROL_POINT_COLOR = Color.BLUE;
    private Scene scene;
    private RectangularDataSelection dataSelection;
    private int areaIndex;
    private ScatterPlot2DSettings settings;
    private boolean controlPointsVisibleFlag;

    public SelectionRectangleAreaWidget(Scene aScene, RectangularDataSelection aSelection, int anAreaIndex, ScatterPlot2DSettings aSettings) {
        super(aScene);
        this.scene = aScene;
        this.dataSelection = aSelection;
        this.areaIndex = anAreaIndex;
        this.settings = aSettings;
        this.setBackground(this.getBackgroundColor());
        this.setOpaque(true);
        Border theBorder = BorderFactory.createLineBorder(Color.BLUE, 1);
        this.setBorder(theBorder);
        this.setForeground(Color.RED);
        this.getActions().addAction((WidgetAction)new SelectionRectangleWidgetResizeAction(ActionFactory.createFreeResizeStategy(), this, ActionFactory.createDefaultResizeProvider(), this));
        this.getActions().addAction(this.scene.createWidgetHoverAction());
        this.getActions().addAction(ActionFactory.createMoveAction(null, (MoveProvider)this));
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        Rectangle2D.Double eachRreactangle = (Rectangle2D.Double)this.dataSelection.getAreaRectangles().get(anAreaIndex);
        int recX = (int)Math.round(eachRreactangle.getX() * (double)this.settings.getGraphWidth());
        int recY = (int)Math.round(eachRreactangle.getY() * (double)this.settings.getGraphHeight());
        int recW = (int)Math.round(eachRreactangle.getWidth() * (double)this.settings.getGraphWidth());
        int recH = (int)Math.round(eachRreactangle.getHeight() * (double)this.settings.getGraphHeight());
        Rectangle theRect = new Rectangle(recX, recY, recW, recH);
        ApplicationLogger.logInfo(ScatterPlot2DTopComponent.class, (String)("Rectangle for layer widget: " + theRect));
        this.setPreferredLocation(new Point(recX, recY));
        this.setPreferredSize(new Dimension(recW, recH));
        this.createControlPoints();
        this.updateControlPointsPosition();
        if (this.getState().isHovered()) {
            this.updateControlPointsVisibility(true);
            this.setOpaque(true);
        } else {
            this.updateControlPointsVisibility(false);
            this.setOpaque(false);
        }
    }

    private Color getBackgroundColor() {
        if (DataSelection.SelectionOperator.ADD_RECORDS.equals((Object)this.dataSelection.getSelectionOperatorForAre(this.areaIndex))) {
            return new Color(0, 0, 255, 50);
        }
        return new Color(255, 0, 0, 50);
    }

    public void updateControlPointsPosition() {
    }

    private void createControlPoints() {
    }

    private Widget createControlPointWidget() {
        Widget theWidget = new Widget(this.scene);
        theWidget.setOpaque(true);
        theWidget.setPreferredSize(new Dimension(CONTROL_POINT_SIZE, CONTROL_POINT_SIZE));
        theWidget.setBorder(BorderFactory.createLineBorder(CONTROL_POINT_COLOR, 1));
        theWidget.setBackground((Paint)CONTROL_POINT_COLOR);
        return theWidget;
    }

    protected void notifyStateChanged(ObjectState anOldState, ObjectState aNewState) {
        super.notifyStateChanged(anOldState, aNewState);
        if (!anOldState.isHovered() && aNewState.isHovered()) {
            this.updateControlPointsVisibility(true);
            this.setOpaque(true);
        }
        if (anOldState.isHovered() && !aNewState.isHovered()) {
            this.updateControlPointsVisibility(false);
            this.setOpaque(false);
        }
    }

    private void updateControlPointsVisibility(boolean aVisibility) {
        this.controlPointsVisibleFlag = aVisibility;
    }

    public ResizeProvider.ControlPoint resolveControlPoint(Widget aWidget, Point aPoint) {
        ApplicationLogger.logInfo(SelectionRectangleAreaWidget.class, (String)("Resolve control point: " + aPoint));
        if (this.generateTopLeftControlPointRect().contains(aPoint)) {
            return ResizeProvider.ControlPoint.TOP_LEFT;
        }
        if (this.generateTopRightControlPointRect().contains(aPoint)) {
            return ResizeProvider.ControlPoint.TOP_RIGHT;
        }
        if (this.generateBottomLeftControlPointRect().contains(aPoint)) {
            return ResizeProvider.ControlPoint.BOTTOM_LEFT;
        }
        if (this.generateBottomRightControlPointRect().contains(aPoint)) {
            return ResizeProvider.ControlPoint.BOTTOM_RIGHT;
        }
        return null;
    }

    protected void paintWidget() {
        super.paintWidget();
        if (this.controlPointsVisibleFlag) {
            Graphics2D theGraphics = this.getGraphics();
            theGraphics.setPaint(CONTROL_POINT_COLOR);
            theGraphics.setBackground(CONTROL_POINT_COLOR);
            theGraphics.fill(this.generateTopLeftControlPointRect());
            theGraphics.fill(this.generateBottomLeftControlPointRect());
            theGraphics.fill(this.generateTopRightControlPointRect());
            theGraphics.fill(this.generateBottomRightControlPointRect());
        }
    }

    private Rectangle generateTopLeftControlPointRect() {
        if (!this.isPreferredBoundsSet()) {
            return new Rectangle(new Point(0, 0), CONTROL_POINT_DIMENSION);
        }
        return new Rectangle(this.getPreferredBounds().getLocation(), CONTROL_POINT_DIMENSION);
    }

    private Rectangle generateBottomLeftControlPointRect() {
        if (!this.isPreferredBoundsSet()) {
            return new Rectangle(new Point(0, this.getPreferredSize().height - CONTROL_POINT_SIZE - 2), CONTROL_POINT_DIMENSION);
        }
        return new Rectangle(new Point(this.getPreferredBounds().getLocation().x, this.getPreferredBounds().getLocation().y + this.getPreferredBounds().height - CONTROL_POINT_SIZE - 1), CONTROL_POINT_DIMENSION);
    }

    private Rectangle generateTopRightControlPointRect() {
        if (!this.isPreferredBoundsSet()) {
            return new Rectangle(new Point(this.getPreferredSize().width - CONTROL_POINT_SIZE - 2, 0), CONTROL_POINT_DIMENSION);
        }
        return new Rectangle(new Point(this.getPreferredBounds().getLocation().x + this.getPreferredBounds().width - CONTROL_POINT_SIZE - 1, this.getPreferredBounds().getLocation().y), CONTROL_POINT_DIMENSION);
    }

    private Rectangle generateBottomRightControlPointRect() {
        if (!this.isPreferredBoundsSet()) {
            return new Rectangle(new Point(this.getPreferredSize().width - CONTROL_POINT_SIZE - 2, this.getPreferredSize().height - CONTROL_POINT_SIZE - 2), CONTROL_POINT_DIMENSION);
        }
        return new Rectangle(new Point(this.getPreferredBounds().getLocation().x + this.getPreferredBounds().width - CONTROL_POINT_SIZE - 1, this.getPreferredBounds().getLocation().y + this.getPreferredBounds().height - CONTROL_POINT_SIZE - 1), CONTROL_POINT_DIMENSION);
    }

    public void updateSelection() {
        Rectangle theRect;
        if (this.isPreferredBoundsSet()) {
            theRect = this.getPreferredBounds();
            theRect = this.convertLocalToScene(theRect);
        } else {
            theRect = new Rectangle(this.getPreferredLocation(), this.getPreferredSize());
        }
        ApplicationLogger.logInfo(SelectionRectangleAreaWidget.class, (String)("updateSelection() new rectangle: " + theRect));
        Rectangle2D.Double theDoubleRect = new Rectangle2D.Double(theRect.getX() / (double)this.settings.getGraphWidth(), theRect.getY() / (double)this.settings.getGraphHeight(), theRect.getWidth() / (double)this.settings.getGraphWidth(), theRect.getHeight() / (double)this.settings.getGraphHeight());
        this.dataSelection.updateRectangularArea(this.areaIndex, theDoubleRect);
        VisMinerApplication.getInstance().repaintAllVisualization();
    }

    public void movementStarted(Widget widget) {
    }

    public void movementFinished(Widget widget) {
        this.updateSelection();
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getPreferredLocation();
    }

    public void setNewLocation(Widget widget, Point location) {
        widget.setPreferredLocation(location);
    }

    public JPopupMenu getPopupMenu(Widget aWidget, Point aPoint) {
        JPopupMenu theMenu = new JPopupMenu();
        theMenu.add(new ChangeAreaTypeAction(this.dataSelection, this.areaIndex));
        theMenu.add(new DeleteRectangularAreaAction(this.dataSelection, this.areaIndex));
        theMenu.setLocation(aPoint);
        return theMenu;
    }
}

