/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.ResizeControlPointResolver;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.SelectionRectangleAreaWidget;

public final class SelectionRectangleWidgetResizeAction
extends WidgetAction.LockedAdapter {
    private ResizeStrategy strategy;
    private ResizeControlPointResolver resolver;
    private ResizeProvider provider;
    private Widget resizingWidget = null;
    private ResizeProvider.ControlPoint controlPoint;
    private Rectangle originalSceneRectangle = null;
    private Insets insets;
    private Point dragSceneLocation = null;
    private SelectionRectangleAreaWidget selectionRectangleAreaWidget;

    public SelectionRectangleWidgetResizeAction(ResizeStrategy strategy, ResizeControlPointResolver resolver, ResizeProvider provider, SelectionRectangleAreaWidget aWidget) {
        this.strategy = strategy;
        this.resolver = resolver;
        this.provider = provider;
        this.selectionRectangleAreaWidget = aWidget;
    }

    protected boolean isLocked() {
        return this.resizingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 1) {
            this.insets = widget.getBorder().getInsets();
            this.controlPoint = this.resolver.resolveControlPoint(widget, event.getPoint());
            if (this.controlPoint != null) {
                this.resizingWidget = widget;
                this.originalSceneRectangle = null;
                if (widget.isPreferredBoundsSet()) {
                    this.originalSceneRectangle = widget.getPreferredBounds();
                }
                if (this.originalSceneRectangle == null) {
                    this.originalSceneRectangle = widget.getBounds();
                }
                if (this.originalSceneRectangle == null) {
                    this.originalSceneRectangle = widget.getPreferredBounds();
                }
                this.dragSceneLocation = widget.convertLocalToScene(event.getPoint());
                this.provider.resizingStarted(widget);
                return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
            }
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        boolean state = this.resize(widget, event.getPoint());
        if (state) {
            this.resizingWidget = null;
            this.provider.resizingFinished(widget);
            this.selectionRectangleAreaWidget.updateSelection();
        }
        return state ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.resize(widget, event.getPoint()) ? WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this) : WidgetAction.State.REJECTED;
    }

    private boolean resize(Widget widget, Point newLocation) {
        if (this.resizingWidget != widget) {
            return false;
        }
        newLocation = widget.convertLocalToScene(newLocation);
        int dx = newLocation.x - this.dragSceneLocation.x;
        int dy = newLocation.y - this.dragSceneLocation.y;
        int minx = this.insets.left + this.insets.right;
        int miny = this.insets.top + this.insets.bottom;
        Rectangle rectangle = new Rectangle(this.originalSceneRectangle);
        switch (this.controlPoint) {
            case BOTTOM_CENTER: {
                SelectionRectangleWidgetResizeAction.resizeToBottom(miny, rectangle, dy);
                break;
            }
            case BOTTOM_LEFT: {
                SelectionRectangleWidgetResizeAction.resizeToLeft(minx, rectangle, dx);
                SelectionRectangleWidgetResizeAction.resizeToBottom(miny, rectangle, dy);
                break;
            }
            case BOTTOM_RIGHT: {
                SelectionRectangleWidgetResizeAction.resizeToRight(minx, rectangle, dx);
                SelectionRectangleWidgetResizeAction.resizeToBottom(miny, rectangle, dy);
                break;
            }
            case CENTER_LEFT: {
                SelectionRectangleWidgetResizeAction.resizeToLeft(minx, rectangle, dx);
                break;
            }
            case CENTER_RIGHT: {
                SelectionRectangleWidgetResizeAction.resizeToRight(minx, rectangle, dx);
                break;
            }
            case TOP_CENTER: {
                SelectionRectangleWidgetResizeAction.resizeToTop(miny, rectangle, dy);
                break;
            }
            case TOP_LEFT: {
                SelectionRectangleWidgetResizeAction.resizeToLeft(minx, rectangle, dx);
                SelectionRectangleWidgetResizeAction.resizeToTop(miny, rectangle, dy);
                break;
            }
            case TOP_RIGHT: {
                SelectionRectangleWidgetResizeAction.resizeToRight(minx, rectangle, dx);
                SelectionRectangleWidgetResizeAction.resizeToTop(miny, rectangle, dy);
            }
        }
        widget.setPreferredBounds(this.strategy.boundsSuggested(widget, this.originalSceneRectangle, rectangle, this.controlPoint));
        return true;
    }

    private static void resizeToTop(int miny, Rectangle rectangle, int dy) {
        if (rectangle.height - dy < miny) {
            dy = rectangle.height - miny;
        }
        rectangle.y += dy;
        rectangle.height -= dy;
    }

    private static void resizeToBottom(int miny, Rectangle rectangle, int dy) {
        if (rectangle.height + dy < miny) {
            dy = miny - rectangle.height;
        }
        rectangle.height += dy;
    }

    private static void resizeToLeft(int minx, Rectangle rectangle, int dx) {
        if (rectangle.width - dx < minx) {
            dx = rectangle.width - minx;
        }
        rectangle.x += dx;
        rectangle.width -= dx;
    }

    private static void resizeToRight(int minx, Rectangle rectangle, int dx) {
        if (rectangle.width + dx < minx) {
            dx = minx - rectangle.width;
        }
        rectangle.width += dx;
    }
}

