/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2D;

import java.awt.Point;
import java.awt.geom.Line2D;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ArrowWidget;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.kmeansalgorithm.KMeansAlgorithm;

public final class SeperatingAxisSelectionAction
extends WidgetAction.LockedAdapter {
    public static double MIN_LINE_LENGTH = 0.02;
    private ObjectScene objectScene;
    private LayerWidget selectionLayerWidget;
    private ArrowWidget separatingAxisWidget;
    private KMeansAlgorithm kMeansAlgorithm;
    private ScatterPlot2DSettings scatterPlot2DSettings;
    private boolean wasDragged;

    public SeperatingAxisSelectionAction(ScatterPlot2DSettings aScatterplotSettings, ObjectScene aScene, LayerWidget aSelectionLayerWidget) {
        this.objectScene = aScene;
        this.selectionLayerWidget = aSelectionLayerWidget;
        this.scatterPlot2DSettings = aScatterplotSettings;
    }

    protected boolean isLocked() {
        return this.separatingAxisWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 1) {
            this.separatingAxisWidget = new ArrowWidget((Scene)this.objectScene, true);
            assert (this.separatingAxisWidget != null);
            this.selectionLayerWidget.addChild((Widget)this.separatingAxisWidget);
            this.separatingAxisWidget.setFromPoint(widget.convertLocalToScene(event.getPoint()));
            this.move(widget, event.getPoint());
            this.wasDragged = false;
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.separatingAxisWidget != null) {
            this.move(widget, event.getPoint());
            if (this.wasDragged) {
                this.addSeparatingAxisFromSelectionRectangle();
            }
            this.separatingAxisWidget.getParentWidget().removeChild((Widget)this.separatingAxisWidget);
            this.separatingAxisWidget = null;
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.separatingAxisWidget != null) {
            this.move(widget, event.getPoint());
            this.wasDragged = true;
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    private void addSeparatingAxisFromSelectionRectangle() {
        ApplicationLogger.logInfo(SeperatingAxisSelectionAction.class, (String)"addSeparatingAxisFromWidget() - Creating axis from point {0} to  point {1}", (Object[])new Object[]{this.separatingAxisWidget.getFromPoint(), this.separatingAxisWidget.getToPoint()});
        Line2D.Double theNormalizedAxisLine = new Line2D.Double((double)this.separatingAxisWidget.getFromPoint().x / (double)this.scatterPlot2DSettings.getGraphWidth(), (double)this.separatingAxisWidget.getFromPoint().y / (double)this.scatterPlot2DSettings.getGraphHeight(), (double)this.separatingAxisWidget.getToPoint().x / (double)this.scatterPlot2DSettings.getGraphWidth(), (double)this.separatingAxisWidget.getToPoint().y / (double)this.scatterPlot2DSettings.getGraphHeight());
        if (theNormalizedAxisLine.getP1().distance(theNormalizedAxisLine.getP2()) < MIN_LINE_LENGTH) {
            ApplicationLogger.logInfo(SeperatingAxisSelectionAction.class, (String)"Line is to short!");
            return;
        }
        ApplicationLogger.logInfo(SeperatingAxisSelectionAction.class, (String)"addSeparatingAxisFromWidget() - Creating separating axis from 2D line: [{0},{1}] [{2},{3}]", (Object[])new Object[]{theNormalizedAxisLine.getX1(), theNormalizedAxisLine.getY1(), theNormalizedAxisLine.getX2(), theNormalizedAxisLine.getY2()});
        this.kMeansAlgorithm.addSeparatingAxis(this.scatterPlot2DSettings.getXDimension(), this.scatterPlot2DSettings.getYDimension(), theNormalizedAxisLine);
    }

    private void move(Widget widget, Point newLocation) {
        Point sceneLocation = widget.convertLocalToScene(newLocation);
        this.separatingAxisWidget.setToPoint(sceneLocation);
    }

    public void setKMeansAlgorithm(KMeansAlgorithm kMeansAlgorithm) {
        this.kMeansAlgorithm = kMeansAlgorithm;
    }

    public KMeansAlgorithm getKMeansAlgorithm() {
        return this.kMeansAlgorithm;
    }
}

