/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2DMatrix;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.jdom.Content;
import org.jdom.Element;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.NbBundle;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2D;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2D.ScatterPlot2DSettings;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2DMatrix.ScatterPlot2DMatrixTopComponent;
import org.tpo.graphvisualizations.tools.SceneToPngExporter;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;
import org.tpo.visminerbase.visualization.AbstractVisMinerVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScatterPlot2DMatrix
extends AbstractVisMinerVisualization {
    public static final String SCATTER_PLOT_2D_MATRIX_XML_NAME = "ScatterPlotMatrix";
    private DataSet dataSet;
    private ScatterPlot2DMatrixTopComponent topComponent;

    public void showVisualization() {
        this.topComponent = new ScatterPlot2DMatrixTopComponent(this.dataSet, this);
        this.topComponent.open();
        this.topComponent.requestActive();
        this.registerVisualizationInProject();
    }

    public void displayScatterPlot() {
        this.logInfo("Displaying scatter plot 2D matrix dialog.");
        if (this.topComponent.getSelectedColIndex() >= 0 && this.topComponent.getSelectedRowIndex() >= 0 && this.topComponent.getSelectedRowIndex() < this.dataSet.getDoubleDimensions().size() && this.topComponent.getSelectedColIndex() < this.dataSet.getDoubleDimensions().size()) {
            this.logInfo("Matrix dialog returns valid coordinates for displaying scatterplot graph.");
            ScatterPlot2DSettings theSettings = new ScatterPlot2DSettings();
            theSettings.setDataSet(this.dataSet);
            theSettings.setXDimension((DataDimension<Double>)((DataDimension)this.dataSet.getDoubleDimensions().get(this.topComponent.getSelectedColIndex())));
            theSettings.setYDimension((DataDimension<Double>)((DataDimension)this.dataSet.getDoubleDimensions().get(this.topComponent.getSelectedRowIndex())));
            ScatterPlot2D theScatterPlot2D = new ScatterPlot2D();
            theScatterPlot2D.showVisualization(theSettings);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void makeActive() {
        if (this.topComponent != null) {
            this.logInfo("Making top component active.");
            this.topComponent.requestActive();
        }
    }

    public String getVisualizationName() {
        return NbBundle.getMessage(ScatterPlot2DMatrix.class, (String)"ScatterPlot2DMatrix_NodeName", null);
    }

    public void closeVisualization() {
        this.topComponent.close();
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public void repaint() {
    }

    public void saveToElement(Element anElement) {
        this.logInfo("Saving scatterplot matrix visualization to element");
        Element theElement = new Element(SCATTER_PLOT_2D_MATRIX_XML_NAME);
        anElement.addContent((Content)theElement);
    }

    public void exportToFile() {
        SceneToPngExporter.exportSceneToPng((Scene)this.topComponent.getScene());
    }

    public List<Action> getAdditionalAction() {
        return new ArrayList<Action>();
    }
}

