/*
 * Decompiled with CFR 0.152.
 */
package org.tpo.graphvisualizations.scatterplot.ScatterPlot2DMatrix;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.windows.TopComponent;
import org.tpo.applicationframework.logging.ApplicationLogger;
import org.tpo.graphvisualizations.scatterplot.ScatterPlot2DMatrix.ScatterPlot2DMatrix;
import org.tpo.visminerapi.datastorage.data.DataDimension;
import org.tpo.visminerapi.datastorage.data.DataSet;

public class ScatterPlot2DMatrixTopComponent
extends TopComponent
implements Runnable {
    private static int SCATTERPLOT_SIZE = 50;
    private static int CELL_SPACING = 3;
    private static Color CELL_BORDER_COLOR = Color.BLUE;
    private static Color SELECTED_CELL_BORDER_COLOR = Color.GREEN;
    private DataSet dataSet;
    private ObjectScene scene = new ObjectScene();
    private JComponent sceneView = this.scene.createView();
    private JScrollPane scenePanel = new JScrollPane(this.sceneView);
    private Widget[][] widgetMatrix;
    private List<DataDimension<Double>> doubleDimensions;
    private int selectedColIndex = -1;
    private int selectedRowIndex = -1;
    private boolean shouldShowScatterPlot = false;
    private ScatterPlot2DMatrix scatterPlot2DMatrix;

    public ScatterPlot2DMatrixTopComponent(DataSet aDataSet, ScatterPlot2DMatrix aScatterPlot2DMatrix) {
        this.scatterPlot2DMatrix = aScatterPlot2DMatrix;
        this.dataSet = aDataSet;
        this.doubleDimensions = aDataSet.getDoubleDimensions();
        this.initScene();
        this.scene.validate();
        new Thread(this).start();
        this.setLayout(new BorderLayout());
        this.add(this.scenePanel, "Center");
        this.setName(aScatterPlot2DMatrix.getVisualizationName());
    }

    public void run() {
        int dimCount = this.doubleDimensions.size();
        for (int row = 0; row < dimCount; ++row) {
            for (int col = 0; col < dimCount; ++col) {
                try {
                    this.addCellForPosition(row, col);
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
        this.scene.validate();
    }

    private void initScene() {
        ApplicationLogger.logInfo(ScatterPlot2DMatrixTopComponent.class, (String)"Initializing scene for scatterplot matrix.", null);
        this.scene.getActions().addAction(ActionFactory.createZoomAction());
        this.scene.getActions().addAction(ActionFactory.createPanAction());
        LayerWidget theLayer = new LayerWidget((Scene)this.scene);
        int dimCount = this.doubleDimensions.size();
        this.widgetMatrix = new Widget[dimCount][dimCount];
        for (int row = 0; row < dimCount; ++row) {
            for (int col = 0; col < dimCount; ++col) {
                this.widgetMatrix[row][col] = new LayerWidget((Scene)this.scene);
                this.widgetMatrix[row][col].setBorder(BorderFactory.createLineBorder(CELL_BORDER_COLOR));
                this.widgetMatrix[row][col].setPreferredSize(new Dimension(SCATTERPLOT_SIZE + 2, SCATTERPLOT_SIZE + 2));
                this.widgetMatrix[row][col].setPreferredLocation(new Point(CELL_SPACING + col * (SCATTERPLOT_SIZE + 2 + CELL_SPACING), CELL_SPACING + row * (SCATTERPLOT_SIZE + 2 + CELL_SPACING)));
                theLayer.addChild(this.widgetMatrix[row][col]);
            }
        }
        this.scene.addChild((Widget)theLayer);
        this.scene.validate();
    }

    private void addCellForPosition(int aRowIndex, int aColIndex) {
        ScatterPlotImageWidget theWidget = new ScatterPlotImageWidget((Scene)this.scene, this.createScatterPlotImage(aColIndex, aRowIndex), aRowIndex, aColIndex);
        theWidget.setToolTipText(this.doubleDimensions.get(aRowIndex).getDimensionName() + " - " + this.doubleDimensions.get(aColIndex).getDimensionName());
        theWidget.getActions().addAction(this.scene.createWidgetHoverAction());
        theWidget.getActions().addAction((WidgetAction)new WidgetActionAdapter());
        theWidget.setPreferredLocation(new Point(0, 0));
        this.widgetMatrix[aRowIndex][aColIndex].addChild((Widget)theWidget);
        this.widgetMatrix[aRowIndex][aColIndex].revalidate();
        this.scene.validate();
        this.widgetMatrix[aRowIndex][aColIndex].repaint();
    }

    private Image createScatterPlotImage(int aColIndex, int aRowIndex) {
        ApplicationLogger.logInfo(ScatterPlot2DMatrixTopComponent.class, (String)"Creating image fo widget at row:{0} an col:{1}", (Object[])new Object[]{aColIndex, aRowIndex});
        BufferedImage theImage = new BufferedImage(SCATTERPLOT_SIZE, SCATTERPLOT_SIZE, 1);
        Graphics theGraphics = theImage.getGraphics();
        theGraphics.setColor(Color.WHITE);
        theGraphics.fillRect(0, 0, SCATTERPLOT_SIZE, SCATTERPLOT_SIZE);
        theGraphics.setColor(Color.BLACK);
        DataDimension<Double> xDimension = this.doubleDimensions.get(aColIndex);
        DataDimension<Double> yDimension = this.doubleDimensions.get(aRowIndex);
        int recCount = xDimension.getValues().size();
        for (int anIndex = 0; anIndex < recCount; ++anIndex) {
            Double dXCoord = xDimension.getNormalizedValue(anIndex);
            Double dYCoord = yDimension.getNormalizedValue(anIndex);
            if (dXCoord == null || dYCoord == null) continue;
            Point thePoint = new Point(Math.round((float)SCATTERPLOT_SIZE * dXCoord.floatValue()), Math.round((float)SCATTERPLOT_SIZE * dYCoord.floatValue()));
            theGraphics.drawLine(thePoint.x, thePoint.y, thePoint.x, thePoint.y);
        }
        ApplicationLogger.logInfo(ScatterPlot2DMatrixTopComponent.class, (String)"Image created.", null);
        return Toolkit.getDefaultToolkit().createImage(theImage.getSource());
    }

    private void updateSelectedScatterPlotInfo(int aColIndex, int aRowIndex) {
    }

    public void setSelectedColIndex(int selectedColIndex) {
        this.selectedColIndex = selectedColIndex;
    }

    public void setSelectedRowIndex(int selectedRowIndex) {
        this.selectedRowIndex = selectedRowIndex;
    }

    public int getSelectedColIndex() {
        return this.selectedColIndex;
    }

    public int getSelectedRowIndex() {
        return this.selectedRowIndex;
    }

    protected void componentClosed() {
        this.scatterPlot2DMatrix.unregisterVisualizationInProject();
        super.componentClosed();
    }

    public int getPersistenceType() {
        return 2;
    }

    public ObjectScene getScene() {
        return this.scene;
    }

    private class WidgetActionAdapter
    extends WidgetAction.Adapter {
        private WidgetActionAdapter() {
        }

        public WidgetAction.State mouseClicked(Widget aWidget, WidgetAction.WidgetMouseEvent aMouseEvent) {
            ApplicationLogger.logInfo(WidgetActionAdapter.class, (String)("Widget clicked: " + aWidget.getToolTipText()), null);
            if (aMouseEvent.getClickCount() > 1) {
                ApplicationLogger.logInfo(WidgetActionAdapter.class, (String)("Widget double clicked: " + aWidget.getToolTipText()), null);
                ScatterPlot2DMatrixTopComponent.this.setSelectedColIndex(((ScatterPlotImageWidget)aWidget).colIndex);
                ScatterPlot2DMatrixTopComponent.this.setSelectedRowIndex(((ScatterPlotImageWidget)aWidget).rowIndex);
                ScatterPlot2DMatrixTopComponent.this.scatterPlot2DMatrix.displayScatterPlot();
            }
            return super.mouseClicked(aWidget, aMouseEvent);
        }
    }

    private class ScatterPlotImageWidget
    extends ImageWidget {
        private int rowIndex;
        private int colIndex;

        public ScatterPlotImageWidget(Scene aScene, Image aImage, int aRowIndex, int aColIndex) {
            super(aScene, aImage);
            this.rowIndex = aRowIndex;
            this.colIndex = aColIndex;
        }

        public void notifyStateChanged(ObjectState anOldState, ObjectState aNewState) {
            super.notifyStateChanged(anOldState, aNewState);
            if (aNewState.isHovered()) {
                ScatterPlot2DMatrixTopComponent.this.widgetMatrix[this.rowIndex][this.colIndex].setBorder(BorderFactory.createLineBorder(SELECTED_CELL_BORDER_COLOR));
                this.revalidate();
                this.repaint();
                ScatterPlot2DMatrixTopComponent.this.updateSelectedScatterPlotInfo(this.colIndex, this.rowIndex);
            } else {
                ScatterPlot2DMatrixTopComponent.this.widgetMatrix[this.rowIndex][this.colIndex].setBorder(BorderFactory.createLineBorder(CELL_BORDER_COLOR));
                this.revalidate();
                this.repaint();
                ScatterPlot2DMatrixTopComponent.this.updateSelectedScatterPlotInfo(-1, -1);
            }
        }
    }
}

